<?php
namespace App\Modules\CrawlProduct\Controllers\Services;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class SunflowerlyService extends BaseService
{
    public $config = [];
    public $input = [];

    public function __construct($input)
    {
        $this->input = $input;
        parent::__construct($input);
    }

    public function crawl ($url) {
        $htmlStr = $this->getHtml($url);
        return $this->parseHTML($htmlStr, $url);
    }

    private function getHtml($url) {
        $html = file_get_html($url, false, stream_context_create([
            'http' => [
                'method' => 'GET',
                'header' => 'Accept-language: en\r\n' . 'User-Agent: ' . $this->userAgent . '\r\n'
            ]
        ]));
        return $html;
    }

    public function parseHTML($htmlStr, $url) 
    {
        $partUrl = parse_url($url);
        $paths = explode('/', $partUrl['path']);
        $slug = end($paths);

        $this->config = $this->getConfig();
        $html = str_get_html($htmlStr);
        $productObj = $this->getProductData($html);
        if (!$this->getGallery) {
            $productObj['gallery'] = [];
        }
        $asin = $this->generateAsin($url);
        $productObj['gallery'] = array_slice($productObj['gallery'], 0, 2);

        $data = [
            'name' => $productObj['name'],
            'description' => '',
            'content' => '',
            'image_url' => $productObj['image'],
            'galleries' => $productObj['gallery'],
            'price' => $productObj['price'],
            'high_price' => 0,
            'note' => 'Sunflowerly url: ' . $url,
            'crawl_code' => md5($asin),
            'site' => 'sunflowerly',
            'comments' => [],
            'meta_title' => $productObj['name'],
            'meta_description' => $this->getProductMeta($html, 'meta[name=description]'),
            'meta_keywords' => '',
            'ex_tags' => ['Personalization'],
            'metas' => [
                [
                    'key' => 'is_custom_design',
                    'value' => 1
                ]
            ],
            'custom_design_type' => 'customily',
            'customily' => [
                'slug' => $slug,
                'shop' => (!empty($productObj['shop_url'])) ? $productObj['shop_url'] : 'sunfloweric.myshopify.com'
            ],
            'variants' => [],
            'product_variants' => []
        ];

        return $data;
    }

    private function getProductData ($html) 
    {
        $product = [];
        foreach($html->find('h1.product__title') as $element)
            $product['name'] = strip_tags($element->innertext);

        foreach($html->find('h2 .product__price-final') as $element)
            $product['price'] = $element->innertext;
        
        $product['gallery'] = [];
        $product['variants'] = [];
        preg_match('/Shopify.shop = "(.*)"/', $html, $shopUrlMatches);
        if (!empty($shopUrlMatches[1])) {
            $product['shop_url'] = $shopUrlMatches[1];
        }
        $gallery = $html->find('.carousel__slide .carousel__image');
        $dataSrc = 'data-src';

        foreach ($gallery as $key => $image) {
            $url = $image->$dataSrc;

            $urlParts = parse_url($url);
            if (isset($urlParts['scheme'], $urlParts['host'], $urlParts['path'])) {
                $url = $urlParts['scheme'] . '://' . $urlParts['host'] . $urlParts['path'];
            }

            if ($key == 0) {
                $product['image'] = $url;
            } else {
                array_push($product['gallery'], $url);
            }
        }

        return $product;
    }

    private function getProductMeta ($html, $meta) {
        $retval = '';
        $metaTitleElements = $html->find($meta, 0);
        if ($metaTitleElements) {
            $retval = $metaTitleElements->attr['content'];
        }
        return $retval;
    }

    public function getDataVariant ($html, $count) {
        $retval = [];
        $items = $html->find('input[type=radio][name=option-' . $count . ']');
        foreach ($items as $item) {
            $data = [
                'name' => $item->attr['value'],
                'slug' => $this->convertToSlug($item->attr['value']),
                'type' => 'RADIOBOX'
            ];
            array_push($retval, $data);
        }
        return $retval;
    }

    public function convertToSlug ($str) {
        $str = str_replace(' ', '-', $str);
        $str = str_replace('---', '-', $str);
        $str = mb_strtolower($str);
        return $str;
    }

    public function getProductVariants ($product) {
        $retval = [];
        $arr = [];
        foreach ($product['variants'] as $key => $variant) {
            $temp = [];
            foreach ($variant['options'] as $value) {
                array_push($temp, $value['slug']);
            }
            array_push($arr, $temp);
        }
        $variants = $this->combinations($arr);
        foreach ($variants as $choice) {
            $newChoice = [];
            if (is_array($choice)) {
                foreach ($choice as $element) {
                    $temp = [
                        'variant_slug' => $this->getVariantSlug($product, $element),
                        'slug' => $this->convertToSlug($element)
                    ];
                    array_push($newChoice, $temp);
                }
            } else {
                $temp = [
                    'variant_slug' => $this->getVariantSlug($product, $choice),
                    'slug' => $this->convertToSlug($choice)
                ];
                array_push($newChoice, $temp);
            }
            $item = [
                'galleries' => [],
                'high_price' => 0,
                'price' => $product['price'],
                'image_url' => '',
                'variants' => $newChoice
            ];
            array_push($retval, $item);
        }
        return $retval;
    }

    public function getVariantSlug($product, $slug) {
        $retval = '';
        $variants = $product['variants'];
        foreach ($variants as $variant) {
            foreach ($variant['options'] as $option) {
                if ($option['slug'] == $slug) {
                    return $variant['slug'];
                }
            }
        }
        return $retval;
    }
}