<?php
/**
 * Created by PhpStorm.
 * User: DiemND
 * Date: 5/26/21
 * Time: 3:11 PM
 */

namespace App\Modules\CrawlProduct\Controllers\Services;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Schema;
use Modules\CrawlProduct\Models\CrawlLog;
use App\Modules\CrawlProduct\Controllers\Services\BaseService;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class SuzuriService extends BaseService
{
    public $config = [];
    public $input = [];

    public function __construct($input)
    {
        $this->input = $input;
        parent::__construct($input);
    }

    public function crawl ($url) {
//        $url = 'https://lumtest.com/myip.json';
//        $context = $this->getContext();
        $htmlStr = $this->getHtml($url);
//        $html = file_get_html($url, false, $context);
//        try {
//            $html = file_get_html($url, false, $context);
//        } catch (\Exception $exception) {
//            return [];
//        }
        return $this->parseHTML($htmlStr, $url);
        
    }

    public function parseHTML($htmlStr, $url) {
        $this->config = $this->getConfig();
        $html = str_get_html($htmlStr);
        $comments = [];
        $productThumbsLength = count($html->find('.product__thumbs .product__thumb'));
        $productObj = $this->getProductData($html);
        $imageUrl = $this->getImageUrl($productObj->sampleImageUrl);

        $asin = $productObj->material->id . '_' .  $productObj->item->id;
        $name = $productObj->material->title;
        $data = [
            'name' => $name,
            'description' => $productObj->material->description,
            'content' => '',
            'image_url' => $imageUrl,
            'galleries' => [],
            'price' => $productObj->priceWithTax,
            'high_price' => 0,
            'note' => 'Suzuri url: ' . $url,
            'crawl_code' => $asin,
            'site' => 'suzuri',
            'comments' => $comments,
            'meta_title' => $name,
            'meta_description' => $this->getProductMeta($html, 'meta[name=description]'),
            'meta_keywords' => $this->getProductMeta($html, 'meta[name=keywords]'),
            'store_link' => $this->getStoreLink($html)
        ];
        $data['variants'] = $this->getDataVariants($productObj->itemVariants);
        $data['product_variants'] = $this->getProductVariants($productObj, $productThumbsLength);
        return $data;
    }

    private function getProductData ($html) {
        $retVal = null;
        $element = $html->find('.product__contents', 0);
        if ($element) {
            $str = $element->attr['data-product'];
            $retVal = json_decode(html_entity_decode($str));
        }
        return $retVal;
    }

    private function getDataVariants ($itemVariants) {
        $retVal = [];
        $colorOptions = [
            'key' => [],
            'options' => [],
            'name' => 'Color',
            'slug' => 'color',
        ];
        $sizeOptions = [
            'key' => [],
            'options' => [],
            'name' => 'Size',
            'slug' => 'size',
        ];
        foreach ($itemVariants as $itemVariant) {
            if (!empty($itemVariant->color) && !in_array($itemVariant->color->name, $colorOptions['key'])) {
                $colorOptions['key'][] = $itemVariant->color->name;
                $colorOptions['options'][] = [
                    'name' => $itemVariant->color->displayName,
                    'slug' => $this->toFriendlyString($itemVariant->color->name),
                    'type' => 'IMAGE',
                    'image_url' => ''
                ];
            }
            if (!empty($itemVariant->size) && !in_array($itemVariant->size->name, $sizeOptions['key'])) {
                $sizeOptions['key'][] = $itemVariant->size->name;
                $sizeOptions['options'][] = [
                    'name' => $itemVariant->size->displayName,
                    'slug' => $this->toFriendlyString($itemVariant->size->name),
                    'type' => 'OPTION',
                    'image_url' => ''
                ];
            }
        }
        if ($colorOptions['key']) {
            unset($colorOptions['key']);
            $retVal[] = $colorOptions;
        }
        if ($sizeOptions['key']) {
            unset($sizeOptions['key']);
            $retVal[] = $sizeOptions;
        }
        return $retVal;
    }

    private function getProductVariants ($productObj, $productThumbsLength) {
        $itemVariants = $productObj->itemVariants;
        $imageUrls = array_slice($productObj->imageUrls, 0, $productThumbsLength);
        $retVal = [];
        foreach ($imageUrls as $key => $imageUrl) {
            $imageUrls[$key] = str_replace('{width}x{height}', '1024x1024', $imageUrl);
        }
        $defaultSize = '';
        foreach ($itemVariants as $itemVariant) {
            $images = [];
            foreach ($imageUrls as $imageUrl) {
                if ($itemVariant->color) {
                    $imageUrl = str_replace('{color}', $itemVariant->color->name, $imageUrl);
                }
                if ($itemVariant->size) {
                    if (!$defaultSize) {
                        $defaultSize = $itemVariant->size->name;
                    }
                    $imageUrl = str_replace('{size}', $defaultSize, $imageUrl);
                }
                $images[] = $imageUrl;
            }
            $arrVariants = [];
            if ($itemVariant->color) {
                $arrVariants[] = [
                    'variant_slug' => 'color',
                    'slug' => $this->toFriendlyString($itemVariant->color->name),
                ];
            }
            if ($itemVariant->size) {
                $arrVariants[] = [
                    'variant_slug' => 'size',
                    'slug' => $this->toFriendlyString($itemVariant->size->name),
                ];
            }
            $item = [
                'image_url' => array_shift($images),
                'galleries' => $images,
                'price' => $productObj->priceWithTax,
                'high_price' => 0,
                'variants' => $arrVariants
            ];
            if (!$this->getGallery) {
                $item['galleries'] = [];
            }
            $retVal[] = $item;
        }
        return $retVal;
    }

    private function getImageUrl ($url) {
        $re = '/\/v3\/([0-9]+x[0-9]+)\//m';

        return preg_replace($re, '/v3/1024x1024/', $url);
    }

    private function getHtml($url) {
        $countryCode = Input::get('country_code', 'us');
        $configProxy = config('crawl-product::sa.proxy');
        $proxy = isset($configProxy[$countryCode]) ? $configProxy[$countryCode] : $configProxy['us'];
        $proxy['url'] = str_replace('tcp://', '', $proxy['url']);
        $userAgent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36';
        $ch = curl_init();                                              //creates a new cURL resource handle
        curl_setopt($ch, CURLOPT_URL, $url);               // Set URL to download
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);                 //  TRUE to return the transfer as a string of the return value of curl_exec() instead of outputting it out directly.
        curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);               // Should cURL return or print out the data? (true = return, false = print)
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true );                // Should cURL return or print out the data? (true = return, false = print)
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 100);
        curl_setopt($ch, CURLOPT_PROXY, $proxy['url']);
        curl_setopt($ch, CURLOPT_PROXYUSERPWD, $proxy['username'] . ':' . $proxy['password']);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $output = curl_exec($ch);
        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
            dd($error_msg);
        }
        $size = curl_getinfo($ch, CURLINFO_SIZE_DOWNLOAD);
        $log = new CrawlLog();
        $log->size = $size ? intval($size/(1024*8)) : 0;
        $log->url = $url;
        $log->email = Auth::user() && !empty(Auth::user()->email) ? Auth::user()->email : null;
        $log->save();
        return $output;
    }

    private function getProductMeta ($html, $element) {
        $retVal = '';
        $metaTitleElements = $html->find($element, 0);
        if ($metaTitleElements) {
            $retVal = $metaTitleElements->attr['content'];
            $retVal = $this->replaceDomain($retVal);
        }
        return $retVal;
    }

    private function replaceDomain ($content) {
        $retVal = str_ireplace('suzuri.jp', $_SERVER['SERVER_NAME'], $content);
        $retVal = str_ireplace('suzuri', $_SERVER['SERVER_NAME'], $retVal);
        return $retVal;
    }

    private function getStoreLink($html) {
        $retVal = '';

        $element = $html->find('[data-track-label="creator-of-this-product"]', 0);

        if ($element) {
            $retVal = trim($element->href);
            if ($retVal && $retVal[0] == '/') {
                $retVal = 'https://suzuri.jp' . $retVal;
            }
        }

        return $retVal;
    }
}

