<?php

namespace App\Modules\CrawlProduct\Controllers\Services;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class TmarcteeService extends BaseService
{
    static $config = [];
    public function getUrlParams($url) {
        $parseUrl = parse_url($url);
        $values = explode('&', $parseUrl['query']);
        $params = [];
        foreach ($values as $value) {
            if ($value) {
                $arr = explode('=', $value);
                if (count($arr) == 2) {
                    $params[$arr[0]] = $arr[1];
                }
            }
        }

        return $params;
    }

    public function getDefaultVariant($data, $url) {
        $params = $this->getUrlParams($url);
        $variantId = null;
        $defaultVariant = null;
        if (isset($params['variant'])) {
            $variantId = $params['variant'];
        }
        if ($variantId) {
            foreach ($data['variants'] as $item) {
                if ($item['id'] == $variantId) {
                    $defaultVariant = $defaultVariant;
                    break;
                }
            }
        }
        if (!$defaultVariant) {
            $defaultVariant = $data['variants'][0];
        }

        return $defaultVariant;
    }

    public function parseHTML($htmlStr, $url) {
        $html = str_get_html($htmlStr);
        self::$config = $this->getConfig();

        $infoElement = $html->find('form.product_form_options', 0);
        if ($infoElement) {
            $infoStr = $infoElement->getAttribute('data-product');
            $infoStr = str_replace('&quot;', '"', $infoStr);
            $data = json_decode($infoStr, true);
            if (empty($data) && !empty($data['title'])) {
                return;
            }
            $defaultVariant = $this->getDefaultVariant($data, $url);
            if ($defaultVariant) {
                $variants = $this->getVariants($data);
                $productVariants = [];
                if (count($variants)) {
                    $productVariants = $this->getProductVariants($data, $variants, $defaultVariant);   
                }
                
                $validVariants = [];
                foreach ($variants as $variant) {
                    if (count($variant['options'])) {
                        $validVariants[] = $variant;
                    }
                }
                
                return [
                    'name' => $data['title'],
                    'description' => $this->getProductMeta($html, 'meta[property="og:description"]'),
                    'content' => '',
                    'image_url' => $this->removeVersion($defaultVariant['featured_image']['src']),
                    'galleries' => [],
                    'price' => $data['price'] / 100,
                    'high_price' => $data['compare_at_price'] / 100,
                    'note' => 'Tmarctee url: ' . $url,
                    'crawl_code' => $data['id'],
                    'site' => 'tmarctee',
                    'comments' => [],
                    'meta_title' => $this->getProductMeta($html, 'meta[property="og:title"]'),
                    'meta_description' => $this->getProductMeta($html, 'meta[property="og:description"]'),
                    'meta_keywords' => $this->getProductMeta($html, 'meta[name=keywords]'),
                    'is_fast_shipment' => 0,
                    'related_products' => [],
                    'tags' => $data['tags'],
                    'design_crawl_code' => $data['id'],
                    'store_link' => '',
                    'variants' => $validVariants,
                    'product_variants' => $productVariants,
                ];
            }
        }
    }

    public function getVariants($data) {
        $variants = [];
        
        foreach ($data['options'] as $name) {
            $variantSlug = $this->toFriendlyString($name);
            $variant = [
                'name' => $name,
                'slug' => $variantSlug,
                'options' => [],
                'type' => 'OPTION'
            ];
            $variants[] = $variant;
        }

        return $variants;
    }

    public function getProductVariants($data, &$variants, $defaultVariant) {
        $retVal = [];

        $variantIds = $defaultVariant['featured_image']['variant_ids'];
        $skuData = $data['variants'];
        $skuById = [];
        foreach ($skuData as $item) {
            $skuById[$item['id']] = $item;
        }
        foreach ($variantIds as $variantId) {
            $item = $skuById[$variantId];
            $productVariant = [
                'image_url' => $this->removeVersion($item['featured_media']['preview_image']['src']),
                'galleries' => [],
                'price' => $item['price'] / 100,
                'high_price' => $item['compare_at_price'] / 100,
                'variants' => [],
                'is_default' => 0
            ];
            if ($variantId == $defaultVariant['id']) {
                $productVariant['is_default'] = 1;
            }
            if ($item['option1'] && !$item['option2'] && !$item['option2'] && isset($variants[0])) {
                $optionSlug = $this->toFriendlyString($item['option1']);
                $option = [
                    'name' => $item['option1'],
                    'slug' => $optionSlug,
                    'variant_slug' => $variants[0]['slug']
                ];
                $productVariant['variants'][] = $option;
                $variants[0]['options'][$option['slug']] = $option;
            } else if ($item['option2'] && isset($variants[1])) {
                $optionSlug = $this->toFriendlyString($item['option2']);
                $option = [
                    'name' => $item['option2'],
                    'slug' => $optionSlug,
                    'variant_slug' => $variants[1]['slug']
                ];
                $productVariant['variants'][] = $option;
                $variants[1]['options'][$option['slug']] = $option;
                if ($item['option3'] && isset($variants[2])) {
                    $optionSlug = $this->toFriendlyString($item['option3']);
                    $option = [
                        'name' => $item['option3'],
                        'slug' => $optionSlug,
                        'variant_slug' => $variants[2]['slug']
                    ];
                    $productVariant['variants'][] = $option;
                    $variants[2]['options'][$option['slug']] = $option;
                }
            }
            $retVal[] = $productVariant;
        }

        return $retVal;
    }

    private function removeVersion($src) {
        return substr($src, 0, strpos($src, '?'));
    }

    private function getProductMeta ($html, $element) {
        $retVal = '';
        $metaTitleElements = $html->find($element, 0);
        if ($metaTitleElements) {
            $retVal = $metaTitleElements->attr['content'];
            $retVal = $this->replaceDomain($retVal);
            $retVal = trim($retVal);
        }
        return $retVal;
    }

    private function replaceDomain ($content) {
        $content = str_ireplace('tmarctee.com', $_SERVER['SERVER_NAME'], $content);
        $retVal = str_ireplace('tmarctee', $_SERVER['SERVER_NAME'], $content);
        return trim($retVal);
    }
}
