<?php

namespace App\Modules\CrawlProduct\Controllers\Services;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class TrendingCustomService extends BaseService
{
    public $config = [];
    public $input = [];

    public function __construct($input)
    {
        $this->input = $input;
        parent::__construct($input);
    }

    public function parseHTML($htmlStr, $url)
    {
        $partUrl = parse_url($url);
        $paths = explode('/', $partUrl['path']);
        $slug = end($paths);

        $this->config = $this->getConfig();
        $html = str_get_html($htmlStr);
        $productObj = $this->getProductData($html);
        if (!$this->getGallery) {
            $productObj['gallery'] = [];
        }
        $asin = $this->generateAsin($url);
        $productObj['gallery'] = array_slice($productObj['gallery'], 0, 2);

        $data = [
            'name' => $productObj['name'],
            'description' => '',
            'content' => '',
            'image_url' => $productObj['image'],
            'galleries' => $productObj['gallery'],
            'price' => $productObj['price'],
            'high_price' => 0,
            'note' => 'trendingcustom url: ' . $url,
            'crawl_code' => md5($asin),
            'site' => 'trendingcustom',
            'comments' => [],
            'meta_title' => $productObj['name'],
            'meta_description' => $this->getProductMeta($html),
            'meta_keywords' => '',
            'ex_tags' => ['Personalization'],
            'metas' => [
                [
                    'key' => 'is_custom_design',
                    'value' => 1
                ]
            ],
            'customily' => [
                'slug' => $slug,
                'shop' => (!empty($productObj['shop_url'])) ? $productObj['shop_url'] : 'dreamgifters.myshopify.com'
            ],
            'custom_design_type' => 'customily',
            'variants' => [],
            'product_variants' => []
        ];

        return $data;
    }

    private function getProductData ($html)
    {
        $product = [];
        $nameEle = $html->find('h1.product_name', 0);
        $product['name'] = strip_tags($nameEle->innertext);
        $priceEle = $html->find('.modal_price .sale .current_price .money', 0);
        $product['price'] = preg_replace("/[^\d\.]/", "", $priceEle->innertext);
        preg_match('/Shopify.shop = "(.*)"/', $html, $shopUrlMatches);
        if (!empty($shopUrlMatches[1])) {
            $product['shop_url'] = $shopUrlMatches[1];
        }
        $product['gallery'] = [];
        $product['variants'] = [];

        $gallery = $html->find('.product_gallery .image__container img');
        $dataSrc = 'data-src';
        $index = 0;
        foreach ($gallery as $key => $image) {
            $index++;
            $url = $image->$dataSrc;
            if(!$url && $image->src) {
                $url = $image->src;
            }
            if (strpos($url, '//') === 0) {
                $url = 'https:' . $url;
            }
            if ($url) {

                $urlParts = parse_url($url);
                if (isset($urlParts['scheme'], $urlParts['host'], $urlParts['path'])) {
                    $url = $urlParts['scheme'] . '://' . $urlParts['host'] . $urlParts['path'];
                }

                $product['gallery'][] = $url;
            }
        }
        $product['image'] = array_shift($product['gallery']);

        return $product;
    }

    public function getDataVariant ($html, $count) {
        $retVal = [];
        $items = $html->find('input[type=radio][name=option-' . $count . ']');
        foreach ($items as $item) {
            $data = [
                'name' => $item->attr['value'],
                'slug' => $this->convertToSlug($item->attr['value']),
                'type' => 'RADIOBOX'
            ];
            $retVal[] = $data;
        }
        return $retVal;
    }

    private function getProductMeta ($html) {
        $retVal = '';
        $metaTitleElements = $html->find('meta[name=description]', 0);
        if ($metaTitleElements) {
            $retVal = $metaTitleElements->attr['content'];
        }
        return $retVal;
    }

    public function getProductVariants ($product) {
        $retVal = [];
        $arr = [];
        foreach ($product['variants'] as $variant) {
            $temp = [];
            foreach ($variant['options'] as $value) {
                $temp[] = $value['slug'];
            }
            $arr[] = $temp;
        }
        $variants = $this->combinations($arr);
        foreach ($variants as $choice) {
            $newChoice = [];
            if (is_array($choice)) {
                foreach ($choice as $element) {
                    $temp = [
                        'variant_slug' => $this->getVariantSlug($product, $element),
                        'slug' => $this->convertToSlug($element)
                    ];
                    $newChoice[] = $temp;
                }
            } else {
                $temp = [
                    'variant_slug' => $this->getVariantSlug($product, $choice),
                    'slug' => $this->convertToSlug($choice)
                ];
                $newChoice[] = $temp;
            }
            $item = [
                'galleries' => [],
                'high_price' => 0,
                'price' => $product['price'],
                'image_url' => '',
                'variants' => $newChoice
            ];
            $retVal[] = $item;
        }
        return $retVal;
    }

    public function getVariantSlug($product, $slug) {
        $retVal = '';
        $variants = $product['variants'];
        foreach ($variants as $variant) {
            foreach ($variant['options'] as $option) {
                if ($option['slug'] == $slug) {
                    return $variant['slug'];
                }
            }
        }
        return $retVal;
    }

    public function convertToSlug ($str) {
        $str = str_replace(' ', '-', $str);
        $str = str_replace('---', '-', $str);
        return mb_strtolower($str);
    }
}