<?php
/**
 * Created by PhpStorm.
 * User: DiemND
 * Date: 5/26/21
 * Time: 3:11 PM
 */

namespace App\Modules\CrawlProduct\Controllers\Services;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class TtrinityService extends BaseService
{
    public $config = [];
    public $input = [];

    public function __construct($input)
    {
        $this->input = $input;
        parent::__construct($input);
    }

    public function parseHTML($htmlStr, $url) {
        $this->config = $this->getConfig();
        $html = str_get_html($htmlStr);
        $comments = [];
        $imageData = $this->getImageData($html);
        $imageUrl = isset($imageData['fronts'][0]) ? $imageData['fronts'][0] : '';
        $asin = $html->find('input[name=product_id]', 0)->value;
        $name = $html->find('h1.ttl-box__ttl', 0)->plaintext;
        $price = $this->getPrice($html);
        $data = [
            'name' => $name,
            'description' => '',
            'content' => '',
            'image_url' => $imageUrl,
            'galleries' => [],
            'price' => $price,
            'high_price' => 0,
            'note' => 'Ttrinity url: ' . $url,
            'crawl_code' => $asin,
            'site' => 'ttrinity',
            'comments' => $comments,
            'meta_title' => $name,
            'meta_description' => $this->getProductMeta($html, 'meta[name=description]'),
            'meta_keywords' => $this->getProductMeta($html, 'meta[name=keywords]'),
            'store_link' => $this->getStoreLink($html)
        ];
        $data['variants'] = $this->getDataVariants($html);
        $data['product_variants'] = $this->getProductVariants($data['variants'], $imageData, $price);
        return $data;
    }

    private function getPrice ($html) {
        $retVal = $html->find('#price', 0)->plaintext;
        $retVal = str_replace('¥', '', $retVal);
        $retVal = str_replace('税込 ', '', $retVal);
        $retVal = str_replace(',', '', $retVal);
        $retVal = trim($retVal);
        return intval($retVal);

    }
    private function getImageData ($html) {
        $retVal = [
            'fronts' => [],
            'backs' => []
        ];
        $element = $html->find('.pc-sct--right script', 0);
        $re = '/"product_img_f" :  "((http|ftp|https):\/\/([\w_-]+(?:(?:\.[\w_-]+)+))([\w.,@?^=%&:\/~+#-]*[\w@?^=%&\/~+#-]))"/m';
        preg_match_all($re, $element->innertext, $matches, PREG_SET_ORDER, 0);
        foreach ($matches as $match) {
            $retVal['fronts'][] = $match[1];
        }

        $re = '/"product_img_b" :  "((http|ftp|https):\/\/([\w_-]+(?:(?:\.[\w_-]+)+))([\w.,@?^=%&:\/~+#-]*[\w@?^=%&\/~+#-]))"/m';
        preg_match_all($re, $element->innertext, $matches, PREG_SET_ORDER, 0);
        foreach ($matches as $match) {
            $retVal['backs'][] = $match[1];
        }
        return $retVal;
    }

    private function getDataVariants ($html) {
        $retVal = [];
        $colorOptions = [
            'options' => [],
            'name' => 'Color',
            'slug' => 'color',
        ];
        $sizeOptions = [
            'options' => [],
            'name' => 'Size',
            'slug' => 'size',
        ];
        $colorElements = $html->find('#pc-color-box .color-box .color-box__item img');
        foreach ($colorElements as $element) {
            $colorOptions['options'][] = [
                'name' => $element->alt,
                'slug' => $this->toFriendlyString($element->alt),
                'type' => 'IMAGE',
                'image_url' => ''
            ];
        }
        $sizeElements = $html->find('#size-select-block #select-size select[name=size-select] option');
        foreach ($sizeElements as $element) {
            if ($element->value) {
                $sizeOptions['options'][] = [
                    'name' => $element->plaintext,
                    'slug' => $this->toFriendlyString($element->plaintext),
                    'type' => 'IMAGE',
                    'image_url' => ''
                ];
            }

        }
        if ($colorOptions['options']) {
            $retVal[] = $colorOptions;
        }
        if ($sizeOptions['options']) {
            $retVal[] = $sizeOptions;
        }
        return $retVal;
    }

    private function getProductVariants ($dataVariants, $imageData, $price) {
        $retVal = [];
        foreach ($dataVariants as $key => $variant) {
            if ($variant['slug'] == 'color') {
                foreach ($variant['options'] as $k => $v) {
                    $galleries = [];
                    if (isset($imageData['fronts'][$k])) {
                        $galleries[] = $imageData['fronts'][$k];
                    }
                    if (isset($imageData['backs'][$k])) {
                        $galleries[] = $imageData['backs'][$k];
                    }
                    $dataVariants[$key]['options'][$k]['galleries'] = $galleries;
                }
            }
        }
        $variantsKey = [];
        $variants = [];
        foreach ($dataVariants as $attribute) {
            if ($attribute['options']) {
                $variantsKey[] = array_keys($attribute['options']);
                $variants[] = $attribute;
            }
        }

        $combinations = $this->combinations($variantsKey);
        foreach ($combinations as $listKey) {
            if (!is_array($listKey)) {
                $listKey = [$listKey];
            }
            $arrVariants = [];
            $variantPrice = $price;
            $galleries = [];
            $imageUrl = '';
            foreach ($listKey as $key => $value) {
                $variant = $variants[$key]['options'][$value];
                $arrVariants[] = [
                    'variant_slug' => $variants[$key]['slug'],
                    'slug' => $variant['slug'],
                ];
                if (!empty($variant['galleries'])) {
                    $imageUrl = array_shift($variant['galleries']);
                    $galleries = $variant['galleries'];
                }
            }
            $itemVariant = [
                'image_url' => $imageUrl,
                'galleries' => $galleries,
                'price' => $variantPrice,
                'high_price' => 0,
                'variants' => $arrVariants
            ];
            if (!$this->getGallery) {
                $itemVariant['galleries'] = [];
            }
            $retVal[] = $itemVariant;
        }
        return $retVal;
    }

    private function getImageUrl ($url) {
        $re = '/\/v3\/([0-9]+x[0-9]+)\//m';

        return preg_replace($re, '/v3/1024x1024/', $url);
    }

    private function getProductMeta ($html, $element) {
        $retVal = '';
        $metaTitleElements = $html->find($element, 0);
        if ($metaTitleElements) {
            $retVal = $metaTitleElements->attr['content'];
            $retVal = $this->replaceDomain($retVal);
        }
        return $retVal;
    }

    private function replaceDomain ($content) {
        $retVal = str_ireplace('ttrinity.jp', $_SERVER['SERVER_NAME'], $content);
        $retVal = str_ireplace('ttrinity', $_SERVER['SERVER_NAME'], $retVal);
        return $retVal;
    }

    private function getStoreLink($html) {
        $retVal = '';

        $element = $html->find('.shop-prof__txt__item', 0);
        if ($element) {
            $store = $element->find('a', 0);
            if ($store) {
                $retVal = trim($store->href);
                if ($retVal && $retVal[0] == '/') {
                    $retVal = 'https://www.ttrinity.jp' . $retVal;
                }
            }
        }

        return $retVal;
    }
}

