<?php

namespace App\Modules\CrawlProduct\Controllers\Services;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class ZazzleService extends BaseService
{
    public function parseHTML($htmlStr, $url) {
        $html = str_get_html($htmlStr);
        $name = $html->find('h1', 0)->plaintext;
        $priceEle = $html->find('.Pricing_mainPrice', 0);
        if (!$priceEle) {
            $priceEle = $html->find('.PricingVariantC_mainPrice', 0);
        }
        $price = preg_replace("/[^\d\.]+/", "", $priceEle->plaintext);
        $gallery = $this->getGallery($html);
        $imageUrl = array_shift($gallery);
        preg_match("/(\d+)$/", $url, $matches);
        $crawlCode = "";
        if ($matches && count($matches) > 1) {
            $crawlCode = $matches[1];
        }
        $designCrawlCode = "";
        $design = $html->find('.AboutThisDesign img.AboutThisDesign-mainDesignView', 0);
        if ($design) {
            $src = $design->src;
            $src = str_replace("&amp;", '&', $src);
            preg_match("/design=([a-z\d\-]+)/", $src, $matches);
            if ($matches && count($matches) > 1) {
                $designCrawlCode = $matches[1];
            }
        }
        $content = '';
        $contentEle = $html->find('.ProductDescription-attributeValueDescription', 0);
        if (!empty($contentEle->innertext)) {
            $innerHtmlDom = str_get_html($contentEle->innertext);
            foreach($innerHtmlDom->find('a') as $aTag) {
                $aTag->outertext = $aTag->plaintext;
            }
            $content = $innerHtmlDom->save();
        }
        $description = '';
        $descriptionEle = $html->find('.AboutThisDesign .SeeMore_content > div', 0);
        if (!empty($descriptionEle)) {
            $description = $descriptionEle->plaintext;
        }

        if (!$this->getGallery) {
            $gallery = [];
        }

        $data = [
            'name' => $name,
            'description' => $description,
            'content' => $content,
            'image_url' => $imageUrl,
            'galleries' => $gallery,
            'price' => $price,
            'high_price' => 0,
            'note' => 'Zazzle url: ' . $url,
            'crawl_code' => $crawlCode,
            'design_crawl_code' => $designCrawlCode,
            'site' => 'zazzle',
            'comments' => '',
            'meta_title' => $name,
            'meta_description' => $this->getProductMeta($html, 'meta[name=description]'),
            'meta_keywords' => $this->getProductMeta($html, 'meta[name=keywords]'),
            'store_link' => '',
            'variants' => [],
            'product_variants' => []
        ];
        if ($designCrawlCode) {
            $data['template_design_code'] = 'zzlbase-' . $designCrawlCode;
            $designUrl = "https://www.zazzle.com/rlv/svc/view?realview=ss&design=$designCrawlCode&size=a_s&max_dim=1000&area_texture_layout=square&csa=true&image_type=png&rvtype=content&areacolor=false&content_outline=false&content_padding=0&layer=Fg";
            $data['design_url'] = $designUrl;
        }
        
        return $data;
    }

    public function getGallery($html) {
        $items = $html->find('.ProductSpace-viewSelector .ViewSelectorItem-container');
        $retVal = [];
        foreach ($items as $item) {
            $radio = $item->find('.CustomRadioButton_radio', 0);
            if ($radio && strpos(strtolower($radio->{"aria-label"}), "video") !== false) {
                continue;
            }
            $img = $item->find('.ViewSelectorItem-image', 0);
            if (!$img) {
                continue;
            }
            $src = $img->src;
            $src = str_replace("&amp;", '&', $src);
            $src = str_replace(".webp", '.jpg', $src);
            $src = str_replace("_80.", '_1000.', $src);
            $src = preg_replace("/max_dim=(\d+)/", "max_dim=1000", $src);
            $retVal[] = $src;
        }

        return $retVal;
    }

    private function getProductMeta ($html, $element) {
        $retVal = '';
        $metaTitleElements = $html->find($element, 0);
        if ($metaTitleElements) {
            $retVal = $metaTitleElements->attr['content'];
        }
        return $retVal;
    }
}