<?php

namespace Modules\CrawlProduct\Controllers;
use Illuminate\Http\Request;
use Modules\CrawlProduct\Controllers\Controller;
use Auth;
use DateTime;
use Modules\CrawlProduct\Models\ProductSkuValue;

class VariantController extends Controller {
    public function replaceVariant(Request $request) {
        set_time_limit(10 * 3600);
        $locale = env('APP_LOCALE', 'us');
        if (!$locale) {
            $locale = 'us';
        }
        \Log::info($locale . ' replaceVariantUser', [Auth::user()->email]);

        $retVal = [
            'status' => 'fail',
            'result' => []
        ];

        $query = ProductSkuValue::query();
        $query->join('product', 'product.id', 'product_sku_value.product_id');
        $query->whereNull('product.deleted_at');

        if ($request->has('minDate')) {
            $date = DateTime::createFromFormat('d/m/Y H:i:s', $request->get('minDate') . ' 00:00:00');
            $query->where('product.created_at', '>=', $date->format('Y-m-d H:i:s'));
        }
        
        if ($request->has('maxDate')) {
            $date = DateTime::createFromFormat('d/m/Y H:i:s', $request->get('maxDate') . ' 23:59:59');
            $query->where('product.created_at', '<=', $date->format('Y-m-d H:i:s'));
        }

        if ($request->has('categoryId')) {
            $query->join('product_n_category', 'product_n_category.product_id', 'product_sku_value.product_id')
                ->where('category_id', $request->get('categoryId'));
        }

        $configs = $request->get('variantConfigs');

        foreach ($configs as $key => $config) {
            $cloneQuery = clone $query;
            $cloneQuery->whereIn('product_sku_value.variant_option_id', $config['selectedOptionIds']);
            $ids = $cloneQuery->get([\DB::raw('distinct sb_product_sku_value.id')])->pluck('id')->toArray();
            $retVal['result'][$key] = 0;
            foreach (array_chunk($ids, 200) as $partIds) {
                $retVal['result'][$key] += ProductSkuValue::whereIn('id', $partIds)->update([
                    'variant_id' => $config['replaceVariantId'],
                    'variant_option_id' => $config['replaceOptionId']
                ]);
            }
            $retVal['status'] = 'successful';
        }

        return $retVal;
    }
}
