<?php

function cleanUpSpecialChars($text, $allowUnder = false) {
    $regExpression = "`\W`i";
    if ($allowUnder)
        $regExpression = "`[^a-zA-Z0-9-]`i";

    $text = preg_replace(array($regExpression, "`[-]+`",), "-", $text);
    //2 ký tự này khác nhau
    $text = str_replace("–", "-", $text);
    return trim($text, "-");
}

function sluggify($text, $allowUnder = false) {
    $text = trim($text);
    $charMap = array(
        "à" => "a", "ả" => "a", "ã" => "a", "á" => "a", "ạ" => "a", "ă" => "a", "ằ" => "a", "ẳ" => "a", "ẵ" => "a", "ắ" => "a", "ặ" => "a", "â" => "a", "ầ" => "a", "ẩ" => "a", "ẫ" => "a", "ấ" => "a", "ậ" => "a",
        "đ" => "d",
        "è" => "e", "ẻ" => "e", "ẽ" => "e", "é" => "e", "ẹ" => "e", "ê" => "e", "ề" => "e", "ể" => "e", "ễ" => "e", "ế" => "e", "ệ" => "e",
        "ì" => "i", "ỉ" => "i", "ĩ" => "i", "í" => "i", "ị" => "i",
        "ò" => "o", "ỏ" => "o", "õ" => "o", "ó" => "o", "ọ" => "o", "ô" => "o", "ồ" => "o", "ổ" => "o", "ỗ" => "o", "ố" => "o", "ộ" => "o", "ơ" => "o", "ờ" => "o", "ở" => "o", "ỡ" => "o", "ớ" => "o", "ợ" => "o",
        "ù" => "u", "ủ" => "u", "ũ" => "u", "ú" => "u", "ụ" => "u", "ư" => "u", "ừ" => "u", "ử" => "u", "ữ" => "u", "ứ" => "u", "ự" => "u",
        "ỳ" => "y", "ỷ" => "y", "ỹ" => "y", "ý" => "y", "ỵ" => "y",
        "À" => "A", "Ả" => "A", "Ã" => "A", "Á" => "A", "Ạ" => "A", "Ă" => "A", "Ằ" => "A", "Ẳ" => "A", "Ẵ" => "A", "Ắ" => "A", "Ặ" => "A", "Â" => "A", "Ầ" => "A", "Ẩ" => "A", "Ẫ" => "A", "Ấ" => "A", "Ậ" => "A",
        "Đ" => "D",
        "È" => "E", "Ẻ" => "E", "Ẽ" => "E", "É" => "E", "Ẹ" => "E", "Ê" => "E", "Ề" => "E", "Ể" => "E", "Ễ" => "E", "Ế" => "E", "Ệ" => "E",
        "Ì" => "I", "Ỉ" => "I", "Ĩ" => "I", "Í" => "I", "Ị" => "I",
        "Ò" => "O", "Ỏ" => "O", "Õ" => "O", "Ó" => "O", "Ọ" => "O", "Ô" => "O", "Ồ" => "O", "Ổ" => "O", "Ỗ" => "O", "Ố" => "O", "Ộ" => "O", "Ơ" => "O", "Ờ" => "O", "Ở" => "O", "Ỡ" => "O", "Ớ" => "O", "Ợ" => "O",
        "Ù" => "U", "Ủ" => "U", "Ũ" => "U", "Ú" => "U", "Ụ" => "U", "Ư" => "U", "Ừ" => "U", "Ử" => "U", "Ữ" => "U", "Ứ" => "U", "Ự" => "U",
        "Ỳ" => "Y", "Ỷ" => "Y", "Ỹ" => "Y", "Ý" => "Y", "Ỵ" => "Y"
    );

    $text = strtr($text, $charMap);

    $text = cleanUpSpecialChars($text, $allowUnder);
    return strtolower($text);
}

function japaneseToEnglish ($string) {
    $locale = env('APP_LOCALE');
    $localeMap = [
        'jp' => 'ja',
        'kr' => 'ko'
    ];

    if (!isset($localeMap[$locale])) {
        return $string;
    }

    $cacheKey = 'japan::translate::' . (!is_array($string) ? $string : md5(json_encode($string)));
    if ($locale == 'kr') {
        $cacheKey = 'korean::translate::' . (!is_array($string) ? $string : md5(json_encode($string)));
    }

    if (!is_array($string) && \Illuminate\Support\Facades\Cache::get($cacheKey)) {
        $retVal = \Illuminate\Support\Facades\Cache::get($cacheKey);
    } else {
        if (is_array($string)) {
            $data = [];
            foreach ($string as $item) {
                $data[] = ['text' => $item];
            }
        } else {
            $data = [['text' => $string]];
        }

        $curl = curl_init();
        $secretKeys = [
            [
                'key' => '8b000c6413754e3ba2a6f48fd981eab0',
                'region' => 'eastus'
            ],
            [
                'key' => '7e28ad0022464f0b9a9c2ce96f12b00a',
                'region' => 'southeastasia'
            ],
        ];
        $secret = $secretKeys[array_rand($secretKeys, 1)];
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.cognitive.microsofttranslator.com/translate?from=" . $localeMap[$locale] . "&to=en&api-version=3.0",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                "content-type: application/json",
                "ocp-apim-subscription-key: " . $secret['key'],
                "ocp-apim-subscription-region: " . $secret['region'],
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $retVal = !is_array($string) ? md5($string) : '';
        if ($response) {
            $response = json_decode($response, true);
            if (is_array($string)) {
                $retVal = [];
                foreach ($response as $item) {
                    if (!empty($item['translations'][0]['text'])) {
                        $retVal[] = trim($item['translations'][0]['text']);
                    } else {
                        $retVal[] = '';
                    }
                }
            } else {
                if (isset($response[0]['translations'][0]['text'])) {
                    $retVal = trim($response[0]['translations'][0]['text']);
                    if ($retVal) {
                        \Illuminate\Support\Facades\Cache::put($cacheKey, $retVal, 24 * 60);
                    }
                }
            }
        }
    }
    return $retVal;
}


function strToSlug($str) {
    $str = trim($str);
    $slug = sluggify($str);
    if (!$slug) {
        $name = japaneseToEnglish($str);
        if (!$name) {
            $slug = preg_replace("/\s+/", '-', $slug);
        } else {
            $slug = sluggify($name);
        }
    }

    return trim($slug, '-');
}