<?php

namespace Modules\CrawlProduct\Middlewares;

use App\Modules\CrawlProduct\Controllers\Services\CheckVersionService;
use Closure;

class CheckVersionMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        $checkVersionService = new CheckVersionService();
        $version = $request->header('version');

        $isValidVersion = $checkVersionService->handleCheckVersion($version);

        if ($isValidVersion) {
            return $next($request);
        } else {
            return response()->json([
                'status' => 'failed',
                'message' => 'Vui lòng cập nhật phiên bản để tiếp tục sử dụng.',
                'code' => 'LOW_VERSION'
            ]);
        }
    }   
}
