<?php

namespace Modules\CrawlProduct\Models;
use Illuminate\Database\Eloquent\Model;

class DefaultProduct extends Model
{
    protected $table = 'crawl_product_default_product';
    protected $guarded = [];

    public function category() {
        return $this->belongsTo(Category::class)->select(['id', 'name', 'slug']);
    }

    public function product() {
        return $this->belongsTo(Product::class)->select(['id', 'name', 'image_url', 'slug', 'sku']);
    }
}
