<?php

namespace Modules\CrawlProduct\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
    use SoftDeletes;
    protected $table = 'product';

    protected $fillable = [
        'sku',
        'barcode',
        'name',
        'slug',
        'image_url',
        'price',
        'high_price',
        'add_shipping_fee',
        'weight',
        'status',
        'description',
        'content',
        'note',
        'inventory',
        'brand_id',
        'status_out_stock',
        'pod_parent_id',
        "approve_advertising",
        'created_at',
        'updated_at',
        'deleted_at',
        'gtin',
        'actor_id',
        'updater_id'
    ];

    public function productSkuValue() {
        return $this->hasMany(ProductSkuValue::class);
    }
}
