<?php

namespace Modules\CrawlProduct\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ProductSkuValue extends Model
{
    protected $table = 'product_sku_value';

    protected $fillable = [
        'sku_id',
        'variant_id',
        'variant_option_id',
        'product_id',
    ];


    public function scopeForceIndex(Builder $query, $index) {
        return $query->from(DB::raw("`sb_product_sku_value` FORCE INDEX(`$index`)"));
    }
}
