system.controller("ChangePriceController", ChangePriceController);

function ChangePriceController($scope, $http, $rootScope, $interval, $window, Upload) {
    this.__proto__ = new BaseController($scope, $http, $rootScope, Upload);
    $scope.controllerName = "ChangePriceController";
    $scope.datas = [];
    $scope.dataProductSuccess = [];
    $scope.dataProductFail = [];
    this.initialize = function() {
        toastr.options = {
            "debug": false,
            "positionClass": "toast-bottom-right",
            "onclick": null,
            "fadeIn": 300,
            "fadeOut": 300,
            "timeOut": 5000,
            "extendedTimeOut": 300
        };
        buildCategories();
        buildSizes();
        var data = {};
        data.categories = [];
        data.listChangePrice = [
            {sizes: [], price: 0}
        ];
        var dataStorage = localStorage.getItem('data-update-price');
        if (dataStorage) {
            try {
                data = JSON.parse(dataStorage);
            } catch (e) {}
        }
        var datas = localStorage.getItem('datas-update-price');
        if (datas) {
            try {
                $scope.datas = JSON.parse(datas);
            } catch (e) {}
        } else {
            $scope.datas = [data]
        }
        if (typeof cacheData != 'undefined' && cacheData) {
            try {
                var cacheDataObj = JSON.parse(cacheData);
                if (cacheDataObj && cacheDataObj.length > 0) {
                    $scope.datas = cacheDataObj;
                }
            } catch (e) {}
        }
    }
    $scope.categories = [
        {id: null, name: ''}
    ];
    $scope.sizes = [
        {id: null, name: ''}
    ];

    $scope.addSize = function (index) {
        $scope.datas[index].listChangePrice.push({sizes: [], price: 0});
    }
    $scope.addList = function (index) {
        $scope.datas.push({
            categories: [],
            listChangePrice: [
                {sizes: [], price: 0}
            ]
        });
    }



    function buildSizes() {
        $http({
            method: 'GET',
            url: base_api_url + '/product_variant_option?page_size=-1&filters=variant_id=1&sorts=name'
        }).then(function success(response){
            if (response.data.status == 'successful' && response.data.result.length > 0) {
                $scope.sizes = response.data.result;
            }
        });
    }
    function buildCategories() {
        $http({
            method: 'GET',
            url: base_api_url + '/categories?page_size=1000&type=PRODUCT'
        }).then(function success(response){
            if (response.data.status == 'successful' && response.data.result.length > 0) {
                $scope.categories = response.data.result;
            }
        });
    }

    $scope.changePrice = function (index) {
        if ($scope.datas[index].categories && $scope.datas[index].categories.length == 0) {
            toastr.error('Vui lòng chọn danh mục cần thay đổi giá!');
            return;
        }
        localStorage.setItem('datas-update-price', JSON.stringify($scope.datas));
        var btnId = '#change-price-btn-' + index;
        $(btnId).attr('dt-text', $(btnId).text());
        $(btnId).text('Đang xử lý');
        $(btnId).attr("disabled", true);
        var param = $scope.datas[index];
        $http({
            method: 'POST',
            url: '/crawl-product/update-price',
            data: param
        }).then(function success(response) {
            if (response.data.status == 'successful') {
                toastr.success('Thay đổi giá thành công!');
            } else {
                toastr.fail('Có lỗi trong quá trình thay đổi giá, vui lòng thử lại hoặc liên hệ bộ phận kỹ thuật');
            }
            $(btnId).text('Thay đổi giá');
            $(btnId).attr("disabled", false);
        }, function error (response) {
            toastr.fail('Có lỗi trong quá trình thay đổi giá, vui lòng thử lại hoặc liên hệ bộ phận kỹ thuật');
            $(btnId).text('Thay đổi giá');
            $(btnId).attr("disabled", false);
        });
        $http({
            method: 'POST',
            url: '/crawl-product/save-data-update-price',
            data: $scope.datas
        }).then(function success(response) {

        });

    }

    $scope.removeSize = function (index, parentIndex) {
        if (index > -1 && parentIndex > -1) {
            $scope.datas[parentIndex].listChangePrice.splice(index, 1);
        }
    }

    this.initialize();

}
