system.controller("CrawlProductController", CrawlProductController);

function CrawlProductController($scope, $http, $rootScope, $interval, $window, Upload) {
    this.__proto__ = new BaseController($scope, $http, $rootScope, Upload);
    $scope.controllerName = "CrawlProductController";
    $scope.data = {
        generate_variant: true,
        remove_size_chart: true
    };
    $scope.dataProductSuccess = [];
    $scope.dataProductFail = [];
    $scope.dataProductDuplicate = [];
    this.initialize = function() {
        toastr.options = {
            "debug": false,
            "positionClass": "toast-bottom-right",
            "onclick": null,
            "fadeIn": 300,
            "fadeOut": 1000,
            "timeOut": 5000,
            "extendedTimeOut": 1000
        };
        buildTags();
        buildCategories();
        buildGroups();
        buildBrands();
        $scope.data.tags = [];
        $scope.data.categories = [];
        $scope.data.country = $scope.listCountryCode[0];
    }
    $scope.tags = [
        {id: null, title: ''}
    ];
    $scope.categories = [
        {id: null, name: ''}
    ];
    $scope.brands = [
        {id: null, name: ''}
    ];
    $scope.listCountryCode = listCountryCode;

    function buildTags() {
        $http({
            method: 'GET',
            url: base_api_url + '/tag?page_size=-1'
        }).then(function success(response){
            if (response.data.status == 'successful' && response.data.result.length > 0) {
                $scope.tags = response.data.result;
            }
        });
    }
    function buildCategories() {
        $http({
            method: 'GET',
            url: base_api_url + '/categories?page_size=1000&type=PRODUCT'
        }).then(function success(response){
            if (response.data.status == 'successful' && response.data.result.length > 0) {
                $scope.categories = response.data.result;
            }
        });
    }
    function buildGroups() {
        $http({
            method: 'GET',
            url: base_api_url + '/categories?page_size=1000&type=GROUP'
        }).then(function success(response){
            if (response.data.status == 'successful' && response.data.result.length > 0) {
                $scope.groups = response.data.result;
            }
        });
    }
    function buildBrands () {
        $http.get($scope.buildUrl("/brand?fields=id,name")).then(function (response) {
            $scope.brands = response.data.result;
        });
    }
    $scope.createTag = function(term) {
        var newTag = {'title': term};
        $http({
            method: 'POST',
            url: base_api_url + '/tag',
            data: newTag
        }).then(function success(response) {
            if (response.data.status == 'successful' && response.data.result.id != 'undefined') {
                var newTag = {
                    id: response.data.result.id,
                    title: response.data.result.title
                };
                $scope.tags.push(newTag);
                $scope.data.tags.push(newTag);
                toastr.success('Tạo Tag thành công');
                $scope.isDirty = true;
            } else {
                toastr.error('Tạo Tag không thành công. ' + response.data.message)
            }
        });
    };

    $scope.crawl = async function () {
        if (!$scope.data.links) {
            toastr.error('Vui lòng nhập link cần crawl!');
            return;
        }
        $('#crawl-btn').attr('dt-text', $('#crawl-btn').text());
        $('#crawl-btn').text('Đang xử lý');
        $('#crawl-btn').attr("disabled", true);
        var arrLink = $scope.data.links.split("\n");
        var param = {};
        if ($scope.data.discount) {
            param.discount = $scope.data.discount;
        }
        if ($scope.data.min_price) {
            param.min_price = $scope.data.min_price;
        }
        if ($scope.data.fast_shipment_price) {
            param.fast_shipment_price = $scope.data.fast_shipment_price;
        }
        if ($scope.data.description) {
            param.description = $scope.data.description;
        }
        if ($scope.data.tags && $scope.data.tags.length > 0) {
            var tagIds = [];
            for (var i in $scope.data.tags) {
                tagIds.push($scope.data.tags[i].id);
            }
            param.tags = tagIds.join(',');
        }
        if ($scope.data.categories && $scope.data.categories.length > 0) {
            var categoryIds = [];
            for (var i in $scope.data.categories) {
                categoryIds.push($scope.data.categories[i].id);
            }
            param.categories = categoryIds.join(',');
        }
        if ($scope.data.brand && typeof $scope.data.brand.id != 'undefined' && $scope.data.brand.id) {
            param.brand_id = $scope.data.brand.id
        }
        if ($scope.data.country && typeof $scope.data.country.code != 'undefined' && $scope.data.country.code) {
            param.country_code = $scope.data.country.code
        }
        if ($scope.data.is_crawl_comment) {
            param.is_crawl_comment = 1;
        }
        if ($scope.data.is_crawl_related) {
            param.is_crawl_related = 1;
        }
        if ($scope.data.is_overwrite_product) {
            param.is_overwrite_product = 1;
        }
        if ($scope.data.generate_variant) {
            param.generate_variant = 1;
        }
        param.remove_size_chart = $scope.data.remove_size_chart;
        if (typeof $scope.data.group != 'undefined' && $scope.data.group.id) {
            param.group_id = $scope.data.group.id;
        }

        $scope.dataProductSuccess = [];
        $scope.dataProductFail = [];
        $scope.dataProductDuplicate = [];

        var crawlItem = [];
        while (arrLink.length != 0) {
            var link = arrLink.shift();
            param.url = link;
            var result = await crawlLink(param, arrLink.length);
        }
    }

    function crawlLink(param, arrayLinkLength) {
        return new Promise(function (resolve, reject) {
            $http({
                method: 'POST',
                url: '/crawl-product',
                data: param
            }).then(function success(response) {
                if (response.data.status == 'successful') {
                    var data = response.data.result;
                    resolve(data);
                    data.crawl_link = param.url;
                    $scope.dataProductSuccess.push(data);
                    if (response.data.dataRelates && response.data.dataRelates.length > 0) {
                        for (var i in response.data.dataRelates) {
                            $scope.dataProductSuccess.push(response.data.dataRelates[i]);
                        }
                    }
                } else if (response.data.status == 'duplicate') {
                    var data = response.data.result;
                    resolve(data);
                    data.crawl_link = param.url;
                    $scope.dataProductDuplicate.push(data);
                } else {
                    resolve(response.data);
                    $scope.dataProductFail.push(param.url);
                }
                if (arrayLinkLength == 0) {
                    $('#crawl-btn').text($('#crawl-btn').attr('dt-text'));
                    $('#crawl-btn').attr("disabled", false);
                    toastr.success('Quá trình crawl hoàn tất!');
                }
            }, function error (response) {
                resolve(response);
                $scope.dataProductFail.push(param.url);
                if (arrayLinkLength == 0) {
                    $('#crawl-btn').text($('#crawl-btn').attr('dt-text'));
                    $('#crawl-btn').attr("disabled", false);
                    toastr.success('Quá trình crawl hoàn tất!');
                }
            })
        })

    }

    $scope.updateProductName = function () {
        var products = [];
        for (var i in $scope.dataProductSuccess) {
            products.push({
                id: $scope.dataProductSuccess[i].id,
                name: $scope.dataProductSuccess[i].name,
            })
        }
        if (products.length > 0) {
            $('#change-name').text('Đang xử lý');
            $('#change-name').attr("disabled", true);
            var country_code = '';
            if ($scope.data.country && typeof $scope.data.country.code != 'undefined' && $scope.data.country.code) {
                country_code = $scope.data.country.code
            }
            $http({
                method: 'POST',
                url: '/crawl-product/update-product-name',
                data: {products: products, country_code: country_code}
            }).then(function success(response) {
                if (response.data.status == 'successful') {
                    toastr.success('Thay đổi tên sản phẩm thành công thành công!');
                } else {
                    toastr.fail('Có lỗi trong quá trình thay đổi tên sản phẩm, vui lòng thử lại hoặc liên hệ bộ phận kỹ thuật');
                }
                $('#change-name').text('Thay đổi tên sản phẩm');
                $('#change-name').attr("disabled", false);
            });
        } else {
            toastr.fail('Chưa có sản phẩm nào cần thay đổi tên');
        }
    }

    $scope.buildCurrency = function () {
        var retVal = '$';
        if ($scope.data.country && typeof $scope.data.country.code != 'undefined' && $scope.data.country.code) {
            var configByCountry = listConfigByCountry[$scope.data.country.code];
            retVal = configByCountry.currency;
        }
        return retVal;
    }

    $scope.copyAll = function (type) {
        let value = '';
        if (type == 'success') {
            for (let item of $scope.dataProductSuccess) {
                value += item.crawl_link + '\n';
            }
        } else if (type == 'duplicate') {
            for (let item of $scope.dataProductDuplicate) {
                value += item.crawl_link + '\n';
            }
        } else if (type == 'fail') {
            for (let item of $scope.dataProductFail) {
                value += item + '\n';
            }
        }
        var tempInput = document.createElement("textarea");
        tempInput.value = value;
        document.body.appendChild(tempInput);
        tempInput.select();
        document.execCommand("copy");
        document.body.removeChild(tempInput);
        toastr.success('Đã copy tất cả link');
    }

    $scope.copy = function (item) {
        var tempInput = document.createElement("input");
        tempInput.value = item;
        document.body.appendChild(tempInput);
        tempInput.select();
        document.execCommand("copy");
        document.body.removeChild(tempInput);
        toastr.success('Đã copy link');
    }


    this.initialize();

}
