system.controller("DefaultProductController", DefaultProductController);

function DefaultProductController($scope, $http, $rootScope, $q) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope, $q);
    $scope.config = [];

    $scope.filter = {};

    $scope.initialize = function () {
        $scope.getConfig();
        $scope.getCategories();
    }

    $scope.getCategories = function () {
        $http.get($scope.buildUrl('/categories?get_is_hidden=1')).then(function (response) {
            $scope.categories = response.data.result;
        });
    }

    $scope.getConfig = function (reset = false) {
        if (reset) {
            $scope.meta.page_id = 0;
        }
        let url = '/crawl-product/default-product/find';
        let filters = [];
        
        for (let key of Object.keys($scope.filter)) {
            if ($scope.filter[key]) {
                filters.push(`${key}=${$scope.filter[key]}`);
            }
        }
        if (filters.length) {
            url += '?' + filters.join('&');
        }
        $http.get($scope.buildPaginationUrl(url, 20)).then(function (response) {
            $scope.config = response.data.result;
            $scope.meta = response.data.meta;
        });
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.getConfig();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.getConfig();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.getConfig();
        }
    };

    $scope.buildSiteUrl = function (url) {
        return (typeof localePrefix != 'undefined' && localePrefix && localePrefix != 'us' ? '/' + localePrefix : '') + url;
    }

    $scope.new = function () {
        $scope.config.unshift({
            category_id: null,
            product_id: null,
            sku: '',
            is_edit: true
        });
    }

    $scope.edit = function (item) {
        item.sku = item.product ? item.product.sku : '';
        item.is_edit = true;
    }

    $scope.cancel = function (index) {
        let item = $scope.config[index];
        if (!item.id) {
            $scope.config.splice(index, 1);
        } else {
            item.is_edit = false;
        }
    }

    $scope.delete = function (index) {
        let item = $scope.config[index];
        $scope.callConfirmModal({
            title: 'Xoá cấu hình crawl sp',
            text: 'xoá cấu hình crawl sp'
        }, function () {
            $http.delete('/crawl-product/default-product/delete/' + item.id)
                .then(response => {
                    if (response.data.status == 'successful') {
                        $scope.getConfig();
                    } else {
                        toastr.error('Đã có lỗi xảy ra');
                    }
                })
                .catch(error => {
                    console.log(error);
                    toastr.error('Đã có lỗi xảy ra');
                })
        });
    }

    $scope.save = function (item) {
        let data = {
            category_id: item.category_id,
            sku: item.sku
        };

        if (item.id) {
            data.id = item.id;
        }

        if (!item.category_id) {
            toastr.error('Vui lòng nhập danh mục');
            return;
        }

        if (!item.sku) {
            toastr.error('Vui lòng nhập mã sp');
            return;
        }

        $http.post('/crawl-product/default-product/save', data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    toastr.success('Lưu thành công');
                    $scope.getConfig();
                } else {
                    if (response.data.message) {
                        toastr.error(response.data.message);
                    } else {
                        toastr.error('Đã có lỗi xảy ra');
                    }
                }
            }, function () {
                toastr.error('Đã có lỗi xảy ra')
            })
    }
    
    $scope.initialize();
}
