system.controller("NewProductController", NewProductController);

function NewProductController($scope, $http, $rootScope, $interval, $window, Upload) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.controllerName = "NewProductController";
    $scope.data = {};
    $scope.products = [];
    $scope.meta = {
        page_id: 0,
        page_size: 60,
    };
    $scope.selectedProducts = [];
    this.initialize = function() {
        toastr.options = {
            "debug": false,
            "positionClass": "toast-bottom-right",
            "onclick": null,
            "fadeIn": 300,
            "fadeOut": 300,
            "timeOut": 5000,
            "extendedTimeOut": 300
        };
        $scope.data = {
            page_id: 0,
            country: $scope.listCountryCode[0]
        }
        $scope.find();
    }


    $scope.listCountryCode = listCountryCode;
    $scope.find = function () {
        $('#search-new-product').text('Đang xử lý');
        $('#search-new-product').attr("disabled", true);
        $scope.selectedProducts = [];
        var url = '/crawl-product/get-new-products?page_id=' + $scope.meta.page_id + '&country_code=' + $scope.data.country.code;
        $http({
            method: 'GET',
            url: url
        }).then(function success(response){
            if (response.data.status == 'successful') {
                $scope.products = response.data.data;
                $scope.meta = response.data.meta;
                if ($scope.products.length == 0 && $scope.meta.page_id > 0) {
                    $scope.meta.page_id = 0;
                    $scope.find();
                }
                $scope.resetSelectedProducts();
            }
            setTimeout(function () {
                $('#search-new-product').text('Tìm kiếm');
                $('#search-new-product').attr("disabled", false);
            }, 200)

        });
    }

    $scope.resetSelectedProducts = function () {
        $scope.selectedProducts = [];
        for (var i in $scope.products) {
            $scope.products[i].checked = false;
        }
        $('#js-reset-or-check-all')[0].checked = false;
    }

    $scope.buildCurrency = function (price) {
        var retVal = '';
        if (price && $scope.data.country && typeof $scope.data.country.code != 'undefined' && $scope.data.country.code) {
            var configByCountry = listConfigByCountry[$scope.data.country.code];
            retVal = configByCountry.currency + price;
        }
        return retVal;
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find(true);
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find(true);
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find(true);
        }
    };

    $scope.addSelectedProducts = function (id) {
        var index = $scope.selectedProducts.indexOf(id);
        if (index === -1) {
            $scope.selectedProducts.push(id);
            $scope.products[id].checked = true;
        } else {
            $scope.selectedProducts.splice(index, 1);
            $scope.products[id].checked = false;
        }
        var checkAll = $('#js-reset-or-check-all')[0];
        if ($scope.selectedProducts.length < $scope.products.length) {
            checkAll.checked = false;
        }
        if ($scope.selectedProducts.length === $scope.products.length) {
            checkAll.checked = true;
        }

        return false;
    };

    $scope.selectAllProducts = function () {
        $('#js-reset-or-check-all')[0].checked = true;
        var checkAll = $('#js-product-checkall')[0];
        $scope.selectedProducts.length = 0;
        for (var item in $scope.products) {
            $scope.selectedProducts.push(parseInt(item));
            $scope.products[parseInt(item)].checked = true;
        }
        var elements = $('.js-product-checkbox');
        for (var i = 0; i < elements.length; i++) {
            elements[i].checked = true;
        }
        $('#js-table-head').css('opacity', 0);
    };

    $scope.resetOrCheckAll = function () {
        var element = $('#js-reset-or-check-all')[0];
        if (element.checked) {
            $scope.selectAllProducts();
        } else {
            $scope.resetSelectedProducts();
        }
    }

    $scope.buildCopyLinks = function () {
        var retVal = [];
        for (var i in $scope.selectedProducts) {
            retVal.push($scope.products[$scope.selectedProducts[i]].url);
        }
        return retVal.join('\n');
    }

    $scope.copy = function () {
        if ($scope.selectedProducts.length > 0) {
            toastr.success('Copy thành công ' + $scope.selectedProducts.length + ' link');
        } else {
            toastr.error('Vui lòng chọn sản phẩm cần copy link');
        }

    }

    this.initialize();

}
