system.controller("ReplaceVariantController", ReplaceVariantController);

function ReplaceVariantController($scope, $http, $rootScope, $q) {
    this.__proto__ = new BaseController($scope, $http, $rootScope, $q);
    $scope.loading = false;
    $scope.configs = [];

    $scope.initialize = function () {
        $scope.loading = true;
        $q.all([
            buildAllVariant(),
            getCategories(),
            
        ]).then(function () {
            loadCache().then(function () {
                $scope.$apply(function () {
                    $scope.loading = false;
                })
            }).catch(function (error) {
                console.log('error', error);
                $scope.$apply(function () {
                    $scope.loading = false;
                })
            })
        }).catch(function (error) {
            console.log('error', error);
            $scope.$apply(function () {
                $scope.loading = false;
            })
        })
    }

    async function getCategories() {
        return $http({
            method: 'GET',
            url: base_api_url + '/categories?fields=id,slug,name&page_size=-1'
        }).then(function (response) {
            if (response.data.status == 'successful' && response.data.result.length > 0) {
                $scope.categories = response.data.result;        
            }
        }, function (error) {
            toastr.error('Đã có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật');
        })
    }

    async function buildAllVariant() {
        return $http({
            method: 'GET',
            url: base_api_url + '/product_variant?embeds=variantOptions&page_size=-1'
        }).then(function success(response) {
            $scope.allVariants = [];
            $scope.optionByVariantIds = {};
            if (response.data.status == 'successful' && response.data.result.length > 0) {
                $scope.allVariants = response.data.result;
            }
        }, function (error) {
            toastr.error('Đã có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật');
        });
    }

    async function loadCache() {
        return $http.get($scope.buildUrl('/option?filters=key=replace-variant'))
            .then(response => {
                if (response.data.status == 'successful') {
                    try {
                        let value = response.data.result[0].value;
                        let configs = JSON.parse(value);
                        for (let item of configs) {
                            let config = {
                                categoryId: item.categoryId,
                                maxDate: item.maxDate,
                                minDate: item.minDate,
                                variantConfigs: []
                            }

                            for (let variantConfig of item.variantConfigs) {
                                let variant = {
                                    selectedVariant: null,
                                    selectedOptions: null,
                                    replaceVariant: null,
                                    replaceOption: null
                                }

                                let selectedVariant = $scope.allVariants.find(item => item.id == variantConfig.selectedVariantId);
                                let replaceVariant = $scope.allVariants.find(item => item.id == variantConfig.replaceVariantId);
                                if (selectedVariant) {
                                    variant.selectedVariant = selectedVariant;
                                    variant.selectedOptions = selectedVariant.variant_options.filter(item => variantConfig.selectedOptionIds.includes(item.id))
                                }

                                if (replaceVariant) {
                                    variant.replaceVariant = replaceVariant;
                                    variant.replaceOption = replaceVariant.variant_options.find(item => item.id == variantConfig.replaceOptionId);
                                }
                    
                                config.variantConfigs.push(variant);
                            }
                            $scope.configs.push(config);
                        }

                    } catch (error) {
                        console.log(error);
                    }
                }
            });
    }

    $scope.onChangeSelectedVariant = function (config) {
        config.replaceVariant = config.selectedVariant;
    }

    $scope.removeVariant = function (config, index) {
        config.variantConfigs.splice(index, 1);
    }

    $scope.removeList = function (index){
        $scope.configs.splice(index, 1);
    }

    $scope.addVariant = function (config) {
        config.variantConfigs.push({
            selectedVariant: null,
            replaceVariant: null,
            selectedOptions: null,
            replaceOption: null
        });
    }

    $scope.addList = function () {
        let config = {
            categoryId: '',
            minDate: '',
            maxDate: '',
            variantConfigs: []
        };
        $scope.addVariant(config);
        $scope.configs.push(config);
    }

    $scope.validate = function (config) {
        let retVal = true;
        if (!config.variantConfigs || !config.variantConfigs.length) {
            toastr.error('Vui lòng chọn biến thể');
            retVal = false;
        } else {
            for (let item of config.variantConfigs) {
                if (
                    !item.selectedVariant ||
                    !item.replaceVariant ||
                    !item.selectedOptions ||
                    !item.replaceOption
                ) {
                    toastr.error('Vui lòng nhập đầy đủ thông tin biến thể');
                    retVal = false;
                    break;
                }
            }
        }

        return retVal;
    }

    $scope.saveCache = function () {
        let saveData = [];
        for (let item of $scope.configs) {
            let data = $scope.buildData(item);
            saveData.push(data);
        }

        $http.put($scope.buildUrl('/option/key/replace-variant'), {value: JSON.stringify(saveData)});
    }

    $scope.buildData = function (config) {
        let result = {
            categoryId: config.categoryId,
            maxDate: config.maxDate,
            minDate: config.minDate,
            variantConfigs: []
        }

        for (let item of config.variantConfigs) {
            let variant = {
                selectedVariantId: item.selectedVariant ? item.selectedVariant.id : null,
                selectedOptionIds: (item.selectedOptions && item.selectedOptions.length) ? item.selectedOptions.map(item => item.id) : [],
                replaceVariantId: item.replaceVariant ? item.replaceVariant.id : null,
                replaceOptionId: item.replaceOption ? item.replaceOption.id : null
            }

            result.variantConfigs.push(variant);
        }

        return result;
    }

    $scope.execute = function (config) {
        if ($scope.validate(config)) {
            $scope.callConfirmModal({
                title: 'Thay thế hàng loạt biến thể',
                text: 'thay thế hàng loạt biến thể'
            }, function () {
                $scope.saveCache();
                let data = $scope.buildData(config);
                config.loading = true;
                $http.post('/crawl-product/replace-variant', data)
                    .then(response => {
                        if (response.data.status == 'successful') {
                            config.loading = false;
                            toastr.success('Thay thế thành công');
                        } else {
                            toastr.error('Đã có lỗi xảy ra');
                        }
                    })
                    .catch(error => {
                        console.log(error);
                        config.loading = false;
                        toastr.error('Đã có lỗi xảy ra');
                    })
            });
        }
    }

    $scope.initialize();
}
