@extends('system.layout.main', [
'ngController' => 'ChangePriceController'
])
@section('title')
    <title>Thay đổi giá sản phẩm</title>
@endsection
@section('css')
    <style media="screen">
        hr {
            border-top: 1px solid #ccc;
        }
        .chosen-container-single, .chosen-container-multi {
            width: 100%!important;
        }
        .chosen-choices {
            padding: 4px !important;
            line-height: 27px !important;
        }
        .chosen-single {
            height: 34px !important;
            padding: 4px !important;
        }
        .product-success thead tr td {
            font-weight: bold;
        }
    </style>
    <link rel="stylesheet" href="/system/css/chosen.min.css">
@endsection
@section('script')
    <script>
        var cacheData = '<?= $cacheData ?>';
    </script>
    <script src="<?= Module::asset('crawl-product/js/change-price-controller.js') ?>?v={{ config('sa.version') }}" charset="utf-8"></script>
    <script src="/system/js/scripts/chosen-add-option.js?v="></script>
    <script src="/system/js/scripts/angular-chosen.min.js?v="></script>
@endsection
@section('content')
    <div class="content" ng-cloak>
        <div class="header">
            <div class="pull-left">
                <h3 class="">Thay đổi giá sản phẩm</h3>
            </div>
            <div class="clearfix">
            </div>
        </div>
        <br>
        <div class="body">
            <div class="box no-border">

                <div class="box-body" ng-repeat="data in datas track by $index">
                    <h4>Danh sách thay đổi giá #@{{ $index + 1 }}</h4>
                    <div class="box-bg-white" style="border-bottom: solid 1px">
                        <div class="col-sm-12">
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="">Ngày tạo từ: </label>
                                    <input ng-model="data.create_date_from" class="form-control" my-date-picker>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="">Ngày tạo đến: </label>
                                    <input ng-model="data.create_date_to" class="form-control" my-date-picker>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="col-sm-8">
                                <div class="form-group">
                                    <label for="">Danh mục: </label>
                                    <select class="form-control chosen-select"
                                            multiple
                                            chosen
                                            persistent-create-option="true"
                                            skip-no-results="true"
                                            ng-model="data.categories"
                                            ng-change="chooseCategories()"
                                            ng-options="category.name for category in categories track by category.id">
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-4" style="padding: 0">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="">Giá ($): </label>
                                        <input ng-model="data.price" class="form-control" type="number">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="">Giá TT ($): </label>
                                        <input ng-model="data.high_price" class="form-control" type="number">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="">Giá hiện tại ($): </label>
                                        <input ng-model="data.current_price" class="form-control" type="number">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12" ng-repeat="changePriceObj in data.listChangePrice track by $index">
                            <div class="col-sm-8">
                                <div class="form-group">
                                    <label for="">Sizes: </label>
                                    <select class="form-control chosen-select"
                                            multiple
                                            chosen
                                            persistent-create-option="true"
                                            skip-no-results="true"
                                            ng-model="changePriceObj.sizes"
                                            max-shown-results="100"
                                            ng-options="size.name for size in sizes track by size.id">
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-4" style="padding: 0">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="">Giá ($): </label>
                                        <input ng-model="changePriceObj.price" class="form-control" type="number">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="">Giá TT ($): </label>
                                        <input ng-model="changePriceObj.high_price" class="form-control" type="number">
                                    </div>
                                </div>
                                <div class="col-sm-4" style="padding: 0">
                                    <button type="button" class="btn btn-danger ml-3" ng-click="removeSize($index, $parent.$index)" style="margin-top: 24px" ng-show="data.listChangePrice.length > 1">
                                        <i class="fa fa-times"></i>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-offset-5" style="margin-bottom: 10px">
                            <button id="add-size" type="button" name="button" class="btn btn-success add" ng-click="addSize($index)">Thêm sizes</button>
                            <button id="change-price-btn-@{{ $index }}" type="button" name="button" class="btn btn-warning add" ng-click="changePrice($index)">Thay đổi giá</button>
                        </div>
                    </div>
                </div>
                <div style="padding: 10px">
                    <button id="add-list" type="button" name="button" class="btn btn-info add" ng-click="addList()">Thêm danh sách</button>
                </div>
            </div>
        </div>
    </div>
@endsection
