@extends('system.layout.main', [
'ngController' => 'DefaultProductController'
])
@section('title')
    <title>Cấu hình sản phẩm crawl mặc định</title>
@endsection
@section('css')
    <style media="screen">
        hr {
            border-top: 1px solid #ccc;
        }
        .chosen-container-single, .chosen-container-multi {
            width: 100%!important;
        }
        .chosen-choices {
            padding: 4px !important;
            line-height: 27px !important;
        }
        .chosen-single {
            height: 34px !important;
            padding: 4px !important;
        }
        .product-success thead tr td {
            font-weight: bold;
        }

        .d-flex {
            display: flex;
            justify-content: center;
            align-items: center;
        }
    </style>
    <link rel="stylesheet" href="/system/css/chosen.min.css">
@endsection
@section('script')
    <script src="/system/js/controllers/pagination/pagination-controller.js?v=<?= Config::get("sa.version") ?>" charset="utf-8"></script>
    <script src="<?= Module::asset('crawl-product/js/default-product-controller.js') ?>?v={{ config('sa.version') }}" charset="utf-8"></script>
    <script src="/system/js/scripts/chosen-add-option.js?v="></script>
    <script src="/system/js/scripts/angular-chosen.min.js?v="></script>
@endsection

@section('content')
    <div class="content" ng-cloak>
        <div class="header">
            <div class="pull-left">
                <h3 class="">Cấu hình sản phẩm crawl mặc định</h3>
            </div>
            <div class="clearfix">
            </div>
        </div>
        <br>
        <div class="body">
            <div class="box no-border p-4">
                <div class="row">
                    <div class="col-md-3"> 
                        <input type="text" class="form-control" placeholder="Mã sp, id sp" ng-model="filter.keyword" ng-change="getConfig(true)">
                    </div>
                    <div class="col-md-3">
                        <select chosen class="form-control" ng-options="item.id as item.name for item in categories" ng-model="filter.category_id" ng-change="getConfig(true)">
                            <option value="">-- Chọn danh mục --</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <button class="btn btn-primary float-right" ng-click="new()"><i class="fa fa-plus"></i> Thêm cấu hình</button>
                    </div>
                </div>
            </div>
            <div class="box no-border">
                <table class="table table-responsive">
                    <tr>
                        <th width="50px">STT</th>
                        <th width="400px">Category</th>
                        <th>Product</th>
                        <th width="100px"></th>
                    </tr>
                    <tr ng-repeat="item in config">
                        <td>@{{ $index + 1 }}</td>
                        <td>
                            <span ng-if="!item.is_edit">
                                @{{ item.category.name }}
                                <p>id: @{{ item.category_id }}</p>
                            </span>
                            <select 
                                chosen 
                                ng-if="item.is_edit" 
                                class="form-control" 
                                ng-options="item.id as item.name for item in categories" 
                                ng-model="item.category_id" 
                                ng-change="save(item)"
                            ></select>
                        </td>
                        <td>
                            <div ng-if="!item.is_edit">
                                <a target="_blank" href="@{{ buildSiteUrl('/' + item.product.slug + '-p' + item.product_id) }}">@{{ item.product.name }}</a>
                                <p>Sku: @{{ item.product.sku }}</p>
                                <p>ID: @{{ item.product_id }}</p>
                            </div>
                            <div class="d-flex" ng-if="item.is_edit">
                                <label for="" class="p-3">Sku/Id sp</label>
                                <input type="text" class="form-control" ng-model="item.sku" placeholder="Sku/Id sp"/>
                            </div>
                        </td>
                        <td ng-if="!item.is_edit">
                            <button class="btn btn-primary" ng-click="edit(item)"><i class="fa fa-pencil"></i></button>
                            <button class="btn btn-danger" ng-click="delete($index)"><i class="fa fa-trash"></i></button>
                        </td>
                        <td ng-if="item.is_edit">
                            <button class="btn btn-success" ng-click="save(item)"><i class="fa fa-save"></i></button>
                            <button class="btn btn-danger" ng-click="cancel($index)"><i class="fa fa-close"></i></button>
                        </td>
                    </tr>
                </table>
                @include('system.pagination')
            </div>
        </div>

    </div>
@endsection