@extends('system.layout.main', [
'ngController' => 'CrawlProductController'
])
@section('title')
    <title>Crawl Sản Phẩm</title>
@endsection
@section('css')
    <style media="screen">
        hr {
            border-top: 1px solid #ccc;
        }
        .chosen-container-single, .chosen-container-multi {
            width: 100%!important;
        }
        .chosen-choices {
            padding: 4px !important;
            line-height: 27px !important;
        }
        .chosen-single {
            height: 34px !important;
            padding: 4px !important;
        }
        .product-success thead tr td {
            font-weight: bold;
        }

        img.product-image {
            width: 100px;
            height: 100px;
        }
        .table-filter tr td {
            padding: 4px;
        }
    </style>
    <link rel="stylesheet" href="/system/css/chosen.min.css">
@endsection
@section('script')
    <script>
        var listCountryCode = <?= $listCountryCode ?>;
        var listConfigByCountry = <?= json_encode(config('crawl-product::sa.config_by_country')) ?>;
    </script>
    <script src="<?= Module::asset('crawl-product/js/crawl-product-controller.js') ?>?v={{ config('sa.version') }}" charset="utf-8"></script>
    <script src="/system/js/scripts/chosen-add-option.js?v="></script>
    <script src="/system/js/scripts/angular-chosen.min.js?v="></script>
@endsection
@section('content')
    <div class="content" ng-cloak>
        <div class="header">
            <div class="pull-left">
                <h3 class="">Crawl sản phẩm</h3>
            </div>
            <div class="clearfix">
            </div>
        </div>
        <br>
        <div class="body">
            <div class="box no-border">

                <div class="box-body">
                    <div class="box-bg-white">
                        <div class="col-sm-3" style="padding-left: 0">
                            <div class="form-group">
                                <label for="">Tags: </label>
                                <select class="form-control chosen-select"
                                        multiple
                                        chosen
                                        create-option-text="'Tạo thêm tag'"
                                        persistent-create-option="true"
                                        create-option="createTag"
                                        ng-model="data.tags"
                                        max-shown-results="100"
                                        ng-options="tag.title for tag in tags track by tag.id">
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group">
                                <label for="">Danh mục: </label>
                                <select class="form-control chosen-select"
                                        multiple
                                        chosen
                                        persistent-create-option="true"
                                        skip-no-results="true"
                                        ng-model="data.categories"
                                        ng-change="chooseCategories()"
                                        ng-options="category.name for category in categories track by category.id">
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group">
                                <label for="">Nhóm: </label>
                                <select class="form-control chosen-select"
                                        chosen
                                        persistent-create-option="true"
                                        skip-no-results="true"
                                        ng-model="data.group"
                                        ng-change="chooseGroup()"
                                        ng-options="group.name for group in groups track by group.id">
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-3" style="padding-right: 0">
                            <div class="form-group">
                                <label for="">Thương hiệu: </label>
                                <select class="form-control"
                                        chosen
                                        persistent-create-option="true"
                                        skip-no-results="true"
                                        ng-model="data.brand"
                                        ng-options="brand.name for brand in brands track by brand.id">
                                </select>
                            </div>
                        </div>
                        <div class="clear clearfix"></div>
                        <div class="col-sm-6" style="padding: 0">
                            <div class="col-sm-6" style="padding-left: 0">
                                <div class="form-group">
                                    <label for="">Số tiền giảm giá (@{{ buildCurrency() }}): </label>
                                    <input ng-model="data.discount" class="form-control" type="number">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="">Số tiền thấp nhất (@{{ buildCurrency() }}): </label>
                                    <input ng-model="data.min_price" class="form-control" type="number">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group">
                                <label for="">Thị trường: </label>
                                <select class="form-control"
                                        ng-model="data.country"
                                        ng-options="item.name for item in listCountryCode track by item.code">
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-3" style="padding-right: 0">
                            <table class="table-filter">
                                <tr>
                                    <td>
                                        <div class="form-group" style="margin-bottom: 3px">
                                            <input id="is_crawl_comment" type="checkbox" ng-model="data.is_crawl_comment">
                                            <label for="is_crawl_comment">Đánh giá </label>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group" style="margin-bottom: 3px">
                                            <input id="is_overwrite_product" type="checkbox" ng-model="data.is_overwrite_product">
                                            <label for="is_overwrite_product">Lưu đè sản phẩm </label>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="form-group" style="margin-bottom: 3px">
                                            <input id="is_auto_generate_variant" type="checkbox" ng-model="data.generate_variant">
                                            <label for="is_auto_generate_variant">Tự sinh biến thể </label>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group" style="margin-bottom: 3px">
                                            <input id="is_crawl_related" type="checkbox" ng-model="data.is_crawl_related">
                                            <label for="is_crawl_related">Sản phẩm liên quan</label>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="form-group" style="margin-bottom: 3px">
                                            <input id="is_auto_remove_size_chart" type="checkbox" ng-model="data.remove_size_chart">
                                            <label for="is_auto_remove_size_chart">Tự xóa ảnh size</label>
                                        </div>
                                    </td>
                                </tr>
                            </table>




                        </div>
                        <div class="clear clearfix"></div>
                        <div class="form-group">
                            <label for="">Mô tả: </label>
                            <textarea ng-model="data.description" class="form-control" rows="3"></textarea>
                        </div>

                        <div class="form-group">
                            <label for="">Danh sách link: </label>
                            <textarea ng-model="data.links" class="form-control" rows="5"></textarea>
                        </div>
                        <div class="col-sm-offset-5">
                            <button id="crawl-btn" type="button" class="btn btn-primary add" ng-click="crawl()">
                                <i class="fa fa-anchor"></i> Crawl sản phẩm
                            </button>
                        </div>
                    </div>
                    <div class="box-bg-white" ng-if="dataProductSuccess.length > 0">
                        <h3>Danh sách sản phẩm crawl thành công:</h3>
                        <table class="table table-bordered product-success">
                            <thead>
                                <tr>
                                    <td style="width: 4%;">#</td>
                                    <td></td>
                                    <td style="width: 25%">Crawl link</td>
                                    <td style="width: 25%">Sản phẩm</td>
                                    <td style="width: 48%">Sửa tên sản phẩm</td>
                                    <td>
                                        <a href="javascript:void(0)" title="copy tất cả link" ng-click="copyAll('success')"><i class="fa fa-copy"></i></a>
                                    </td>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="product in dataProductSuccess" style="background-color: @{{ product.is_related ? 'white' : 'cornsilk' }}">
                                    <td style="width: 30px;">@{{ $index + 1 }}</td>
                                    <td>
                                        <img class="product-image" src="@{{ getImageCdn(product.image_url, 200, 200) }}" alt="">
                                    </td>
                                    <td style="width: 600px; word-break: break-all;"><a href="@{{ product.crawl_link }}" target="_blank">@{{ product.crawl_link }}</a></td>
                                    <td style="word-break: break-all;">
                                        <a href="<?= route('home') ?>/@{{ product.slug }}-p@{{ product.id }}.html" target="_blank">@{{ product.name }}</a>
                                    </td>
                                    <td>
                                        <div class="form-group">
                                            <input ng-model="product.name" class="form-control">
                                        </div>
                                    </td>
                                    <td>
                                        <a href="javascript:void(0)" ng-click="copy(product.crawl_link)" title="copy link"><i class="fa fa-copy"></i></a>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <div class="col-sm-offset-5">
                            <button id="change-name" type="button" name="button" class="btn btn-success add" ng-click="updateProductName()">Thay đổi tên sản phẩm</button>
                        </div>
                    </div>
                    <div class="box-bg-white" ng-if="dataProductDuplicate.length > 0">
                        <h3>Danh sách link đã crawl từ trước:</h3>
                        <table class="table table-bordered product-success">
                            <thead>
                            <tr>
                                <td style="width: 2%"></td>
                                <td></td>
                                <td style="width: 49%">Crawl link</td>
                                <td style="width: 49%">Sản phẩm</td>
                                <td>
                                    <a href="javascript:void(0)" title="copy tất cả link" ng-click="copyAll('duplicate')"><i class="fa fa-copy"></i></a>
                                </td>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="product in dataProductDuplicate">
                                <td>@{{ $index + 1 }}</td>
                                <td>
                                    <img class="product-image" src="@{{ getImageCdn(product.image_url, 200, 200) }}" alt="">
                                </td>
                                <td style="width: 600px; word-break: break-all;">
                                    <a href="@{{ product.crawl_link }}" target="_blank">@{{ product.crawl_link }}</a>
                                </td>
                                <td style="word-break: break-all;">
                                    <a href="<?= route('home') ?>/@{{ product.slug }}-p@{{ product.id }}.html" target="_blank">@{{ product.name }}</a>
                                </td>
                                <td>
                                    <a href="javascript:void(0)" ng-click="copy(product.crawl_link)" title="copy link"><i class="fa fa-copy"></i></a>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="box-bg-white" ng-if="dataProductFail.length > 0">
                        <h3>Danh sách link crawl lỗi:</h3>
                        <table class="table table-bordered product-success">
                            <thead>
                            <tr>
                                <td style="width: 30px">#</td>
                                <td>Crawl link</td>
                                <td>
                                    <a href="javascript:void(0)" title="copy tất cả link" ng-click="copyAll('fail')"><i class="fa fa-copy"></i></a>
                                </td>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="link in dataProductFail">
                                <td style="width: 30px;">
                                    @{{ $index + 1 }}
                                </td>
                                <td style="word-break: break-all;"><a href="@{{ link }}" target="_blank">@{{ link }}</a></td>
                                <td>
                                    <a href="javascript:void(0)" ng-click="copy(link)" title="copy link"><i class="fa fa-copy"></i></a>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
