@extends('system.layout.main', [
'ngController' => 'NewProductController'
])
@section('title')
    <title>Sản phẩm mới</title>
@endsection
@section('css')
    <style media="screen">
        hr {
            border-top: 1px solid #ccc;
        }
        .chosen-container-single, .chosen-container-multi {
            width: 100%!important;
        }
        .chosen-choices {
            padding: 4px !important;
            line-height: 27px !important;
        }
        .chosen-single {
            height: 34px !important;
            padding: 4px !important;
        }
        .product-success thead tr td {
            font-weight: bold;
        }
        .product-wrapper {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(230px, 1fr));
            grid-gap: 10px;
        }
        .product-link {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 290px;
            overflow: hidden;
        }
        .product-item {
            border: 2px solid #fff;
            padding: 8px;
            border-radius: 3px;
        }
        .product-selected {
            background: #ffffff;
            border-color: #217fb7;
        }

    </style>
    <link rel="stylesheet" href="/system/css/chosen.min.css">
@endsection
@section('script')
    <script>
        var listCountryCode = <?= $listCountryCode ?>;
        var listConfigByCountry = <?= json_encode(config('crawl-product::sa.config_by_country')) ?>;
    </script>
    <script src="/system/js/controllers/pagination/pagination-controller.js" charset="utf-8"></script>
    <script src="<?= Module::asset('crawl-product/js/new-product-controller.js') ?>" charset="utf-8"></script>
    <script src="/system/js/scripts/chosen-add-option.js?v="></script>
    <script src="/system/js/scripts/angular-chosen.min.js?v="></script>
@endsection
@section('content')
    <div class="content" ng-cloak>
        <div class="header">
            <div class="pull-left">
                <h3 class="">Sản phẩm mới</h3>
            </div>
            <div class="clearfix">
            </div>
        </div>
        <br>
        <div class="body">
            <div class="box no-border">
                <div class="box-body">
                    <div class="box-bg-white">
                        <div class="col-sm-3">
                            <div class="form-group">
                                <label for="">Thị trường: </label>
                                <select class="form-control"
                                        ng-model="data.country"
                                        ng-change="find()"
                                        ng-options="item.name for item in listCountryCode track by item.code">
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <button type="button" class="btn btn-primary " id="search-new-product" ng-click="find()" style="margin-top: 23px">
                                <i class="fa fa-search"></i>
                                Tìm kiếm
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="body">
            <div class="box no-border">
                <div class="box-body">
                    <div class="box-bg-white">
                        <h4>Danh sách sản phẩm mới:</h4>
                        <div>
                            <div class="bulk-actions" style="top: 0px; position: relative; margin-bottom: 15px">
                                <div class="bulk-actions-inner">
                                    <ul class="bulk-actions-inner-bar">
                                        <li class="segments" style="background: #dfe3e8;font-weight: bold;padding: 8px 5px;">
                                            <input style="margin-left: 3px" id="js-reset-or-check-all" type="checkbox" ng-click="resetOrCheckAll()">
                                            <span>@{{ selectedProducts.length }} sản phẩm được chọn</span>
                                        </li>
                                        <li class="segments dropdown" style="cursor: pointer; display: inline-block; width: auto" ngclipboard data-clipboard-text="@{{ buildCopyLinks() }}" ng-click="copy()">
                                            <span>Copy tất cả link</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="product-wrapper" ng-if="products.length > 0">
                                <div class="product-item @{{ product.checked ? 'product-selected' : '' }}" ng-repeat="product in products">
                                    <input type="checkbox" class="js-product-checkbox" ng-checked="product.checked" ng-click="addSelectedProducts($index); $event.stopPropagation();">
                                    <a class="product-link"  ng-click="addSelectedProducts($index)">
                                        <img src="@{{ product.image_url }}" width="100%">
                                    </a>
                                    <div class="product-title-box flex-b align-c">
                                        <a class="product-title" href="@{{ product.url }}" ng-bind-html="product.name" target="_blank">
                                        </a>
                                    </div>
                                    <div style="display: flex;">
                                        <div class="product-price">
                                            <span class="product-count" style="color: red; font-weight: bold">@{{ buildCurrency(product.price)}}</span>
                                        </div>
                                    </div>
                                </div>
                        </div>
                        <!--<table class="table table-bordered product-success" ng-if="products.length > 0">
                            <thead>
                            <tr>
                                <th style="width: 10px">
                                    <input type="checkbox" id="js-product-checkall" ng-click="selectAllProducts()">
                                </th>
                                <td style="width: 30px">#</td>
                                <td style="width: 100px;">Ảnh</td>
                                <td>Tên sản phẩm</td>
                                <td style="width: 80px;">Giá</td>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="product in products">
                                <td style="vertical-align: middle;">
                                    <input type="checkbox" class="js-product-checkbox" ng-checked="false" ng-click="addSelectedProducts($index); $event.stopPropagation();">
                                </td>
                                <td style="width: 30px; vertical-align: middle;">@{{ $index + 1 }}</td>
                                <td><img src="@{{ product.image_url }}" width="100px"></td>
                                <td style="word-break: break-all; vertical-align: middle;">
                                    <a href="@{{ product.url }}" target="_blank" ng-bind-html="product.name"></a>
                                </td>
                                <td style="text-align: right; vertical-align: middle;">@{{ buildCurrency(product.price)}}</td>
                            </tr>
                            </tbody>
                        </table>-->
                        <p ng-if="products.length == 0">Không tìm được sản phẩm phù hợp!</p>
                    </div>
                </div>
                <div class="box-footer clearfix">
                    @include('system.pagination')
                </div>
            </div>
        </div>
    </div>
@endsection
