@extends('system.layout.main', [
    'ngController' => 'ReplaceVariantController'
])
@section('title')
    <title>Thay thế biến thể</title>
@endsection
@section('css')
    <style media="screen">
        hr {
            border-top: 1px solid #ccc;
        }
        .chosen-container-single, .chosen-container-multi {
            width: 100%!important;
        }
        .chosen-choices {
            padding: 4px !important;
            line-height: 27px !important;
        }
        .chosen-single {
            height: 34px !important;
            padding: 4px !important;
        }
        .product-success thead tr td {
            font-weight: bold;
        }

        .control-btn {
            margin-top: 20px;
            padding: 10px;
            text-align: center;
        }

        .float-left {
            float: left;
        }

        .flex-center {
            display: flex;
            justify-content: center;
            align-items: center
        }
    </style>
    <link rel="stylesheet" href="/system/css/chosen.min.css">
@endsection
@section('script')
    <script src="<?= Module::asset('crawl-product/js/replace-variant-controller.js') ?>?v={{ config('sa.version') }}" charset="utf-8"></script>
    <script src="/system/js/scripts/chosen-add-option.js?v="></script>
    <script src="/system/js/scripts/angular-chosen.min.js?v="></script>
@endsection
@section('content')
    <div class="content" ng-cloak>
        <div class="header">
            <div class="pull-left">
                <h3 class="">Thay thế biến thể</h3>
            </div>
            <div class="clearfix">
            </div>
        </div>
        <br>
        <div class="body">
            <div class="box no-border">
                <div class="box-body">
                    <div ng-repeat="config in configs">
                        <table class="table table-responsive">
                            <tr>
                                <td class="text-center" width="5%">
                                    <button class="btn btn-danger" ng-click="removeList($index)">
                                        <i class="fa fa-close"></i>
                                    </button>
                                </td>
                                <td>
                                    <table class="table table-responsive mt-5">
                                        <tr>
                                            <th colspan="2">Chọn danh mục</th>
                                            <th>Ngày tạo từ</th>
                                            <th colspan="2">Ngày tạo đến</th>
                                        </tr>
                                        <tr>
                                            <td colspan="2">
                                                <select class="form-control"
                                                    chosen
                                                    ng-model="config.categoryId"
                                                    ng-options="cate.id as cate.name for cate in categories"
                                                >
                                                    <option value=""></option>
                                                </select>
                                            </td>
                                            <td>
                                                <input
                                                    type="text"
                                                    class="form-control"
                                                    ng-model="config.minDate"
                                                    my-date-picker
                                                    placeholder="Ngày tạo từ"
                                                />
                                            </td>
                                            <td colspan="2">
                                                <input
                                                    type="text"
                                                    class="form-control"
                                                    ng-model="config.maxDate"
                                                    my-date-picker
                                                    placeholder="Ngày tạo đến"
                                                />
                                            </td>
                                        </tr>
                                        <tr ng-if="configs.length">
                                            <th>
                                                Loại biến thể cần thay thế
                                            </th>
                                            <th>
                                                Biến thể cần thay thế
                                            </th>
                                            <th>
                                                Loại biến thể thay thế
                                            </th>
                                            <th colspan="2">
                                                Biến thể thay thế
                                            </th>
                                        </tr>
                                        <tr ng-repeat="item in config.variantConfigs">
                                            <td width="20%">
                                                <select chosen class="form-control" ng-model="item.selectedVariant" ng-options="variant as variant.name for variant in allVariants" ng-change="onChangeSelectedVariant(item)" max-shown-results="100">
                                                    <option value=""></option>
                                                </select>
                                            </td>
                                            <td width="40%">
                                                <select chosen multiple class="form-control" ng-model="item.selectedOptions" ng-options="option as option.name for option in item.selectedVariant.variant_options" max-shown-results="100">
                                                    <option value=""></option>
                                                </select>
                                            </td>
                                            <td width="20%">
                                                <select chosen class="form-control" ng-model="item.replaceVariant" ng-options="variant as variant.name for variant in allVariants" max-shown-results="100">
                                                    <option value=""></option>
                                                </select>
                                            </td>
                                            <td width="15%">
                                                <select chosen class="form-control" ng-model="item.replaceOption" ng-options="option as option.name for option in item.replaceVariant.variant_options" max-shown-results="100">
                                                    <option value=""></option>
                                                </select>
                                            </td>
                                            <th width="5%">
                                                <button class="btn btn-default" ng-click="removeVariant(config, $index)"><i class="fa fa-trash"></i></button>
                                            </th>
                                        </tr>
                                        <tr>
                                            <td>
                                                <button class="btn btn-default" ng-click="addVariant(config)"><i class="fa fa-plus"></i> Thêm biến thể</button>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                        <div class="control-btn">
                            <button class="btn btn-success" ng-if="configs.length" ng-disabled="loading" ng-click="execute(config)">Thực hiện</button>
                        </div>
                    </div>
                    <div class="control-btn">
                        <button id="add-list" type="button" name="button" class="btn btn-info add float-left" ng-click="addList()" ng-disabled="loading"><i class="fa fa-plus"></i> Thêm danh sách</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
