<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
$systemAuth = config('app.system_auth_middleware');
Route::group(['prefix' => 'crawl-product'], function () use ($systemAuth) {
    Route::get('/management', [
        'as' => 'crawl-product::management',
        'uses' => 'HomeController@management'
    ])->middleware($systemAuth);

    Route::get('/change-price', [
        'as' => 'crawl-product::change-price',
        'uses' => 'HomeController@changePrice'
    ])->middleware($systemAuth);

    Route::get('/replace-variant', [
        'as' => 'crawl-product::replace-variant',
        'uses' => 'HomeController@replaceVariant'
    ])->middleware($systemAuth);

    Route::get('/new-product', [
        'as' => 'crawl-product::new-product',
        'uses' => 'NewProductController@index'
    ])->middleware($systemAuth);

    Route::any('/', [
        'as' => 'crawl-product::home',
        'uses' => 'HomeController@index',
    ]);

    Route::post('/update-price', [
        'as' => 'crawl-product::update-price',
        'uses' => 'HomeController@updatePrice',
    ]);
    Route::post('/save-data-update-price', [
        'as' => 'crawl-product::save-data-update-price',
        'uses' => 'HomeController@saveDataUpdatePrice',
    ]);

    Route::post('/update-product-name', [
        'as' => 'crawl-product::update-product-name',
        'uses' => 'HomeController@updateProductName',
    ]);

    Route::post('/store', [
        'as' => 'crawl-product::store',
        'uses' => 'HomeController@store',
    ]);
    Route::get('/rebuild-amazon-asin', [
        'as' => 'crawl-product::rebuildAmazonAsin',
        'uses' => 'HomeController@rebuildAmazonAsin',
    ]); 
    Route::get('/rebuild-amazon-description', [
        'as' => 'crawl-product::rebuildAmazonDescription',
        'uses' => 'HomeController@rebuildAmazonDescription',
    ]);
    Route::get('/rebuild-amazon-product-meta', [
        'as' => 'crawl-product::rebuildAmazonProductMeta',
        'uses' => 'HomeController@rebuildAmazonProductMeta',
    ]);
    Route::get('/rebuild-amazon-variant-color', [
        'as' => 'crawl-product::rebuildAmazonVariantColor',
        'uses' => 'HomeController@rebuildAmazonVariantColor',
    ]);
    Route::get('/rebuild-variant-option', [
        'as' => 'crawl-product::rebuildVariantOption',
        'uses' => 'HomeController@rebuildVariantOption',
    ]);
    Route::get('/rebuild-slug', [
        'as' => 'crawl-product::rebuildSlug',
        'uses' => 'HomeController@rebuildSlug',
    ]);
    Route::get('/re-crawl-amazon-color', [
        'as' => 'crawl-product::reCrawlColor',
        'uses' => 'HomeController@reCrawlColor',
    ]);
    Route::get('/crawl-category', [
        'as' => 'crawl-product::crawlCategory',
        'uses' => 'NewProductController@crawlCategory',
    ]);
    Route::get('/get-new-products', [
        'as' => 'crawl-product::getNewProducts',
        'uses' => 'NewProductController@getNewProducts',    
    ]);

    Route::get('/generate-variant-by-category', [
        'as' => 'crawl-product::generateVariantByCategory',
        'uses' => 'VariantGeneratorController@generateVariantByCategory',
    ]);

    Route::post('/generate-product-variant', [
        'as' => 'crawl-product::generateProductVariant',
        'uses' => 'VariantGeneratorController@generateProductVariant',
    ]);

    Route::middleware(['check-version'])->group(function () {
        Route::prefix('extension')->group(function () {
            Route::post('/product', ['uses' => 'ExtensionController@updateProductCategory']);
        });
        
        Route::post('/create-from-html', ['uses' => 'ExtensionController@createFromHTML']);
        Route::get('/list-country-code', ['uses' => 'ExtensionController@getListCountryCode']);
        Route::post('/extension-login', 'ExtensionController@extensionLogin');
    });

    Route::get('/remove-size-image-product', 'RemoveSizeImageController@getRemoveSizeImageProduct');

    Route::get('/crawl-teepublic', 'AutoCrawl\CrawlTeepublicController@crawl');
    Route::post('/async-crawl-teepublic', 'AutoCrawl\CrawlTeepublicController@asyncCrawl');
    Route::get('/async-crawl-teepublic', 'AutoCrawl\CrawlTeepublicController@asyncCrawl');

    Route::post('/simple-crawl', 'AutoCrawl\CrawlController@simpleCrawl');

    Route::get('/crawl-redbubble', 'AutoCrawl\CrawlRedbubbleController@crawl');


    Route::post('/replace-variant', 'VariantController@replaceVariant');
    Route::post('/rebuild-teepublic-seller', 'AutoCrawl\CrawlTeepublicController@rebuildSeller');
    Route::get('/rebuild-teepublic-category', 'AutoCrawl\CrawlTeepublicController@rebuildCategory');
    Route::group(['prefix' => 'auto-crawl', 'namespace' => 'AutoCrawl'], function () {
        Route::get('/crawl-etsy', 'CrawlEtsyController@crawl');
    });

    Route::group(['prefix' => 'async-auto-crawl', 'namespace' => 'AutoCrawl'], function () {
        Route::post('/crawl-etsy', 'CrawlEtsyController@asyncCrawl');
        Route::get('/crawl-etsy', 'CrawlEtsyController@asyncCrawl');
        Route::post('/crawl-redbubble', 'CrawlRedbubbleController@asyncCrawl');
        Route::get('/crawl-redbubble', 'CrawlRedbubbleController@asyncCrawl');
        Route::get('/crawl-related-products', 'CrawlRelatedProductController@crawlRelatedProduct');
        Route::post('/crawl-related-products', 'CrawlRelatedProductController@crawlRelatedProduct');
    });

    Route::group(['prefix' => 'cron'], function () {
        Route::get('/build-same-design-product', 'MatchDesignController@matchDesign');
        Route::get('/product-gallery', 'HomeController@crawlImage');
    });
    Route::post('/delete-product', 'DeleteProductController@deleteProduct');
    Route::post('/hide-by-keyword', 'DeleteProductController@hideByKeyword');
    Route::post('/show-by-keyword', 'DeleteProductController@showByKeyword');
    Route::post('/delete-duplicate-tag-refer', 'RemoveDuplicateTagRefer@deleteDuplicate');
    Route::post('/delete-unused-tag', 'RemoveDuplicateTagRefer@deleteUnusedTag');
    Route::post('/delete-duplicate-tag', 'RemoveDuplicateTagRefer@deleteDuplicateTag');
    Route::post('/delete-unused-option', 'RemoveDuplicateOptionController@removeUnusedOption');
    Route::post('/delete-duplicate-option', 'RemoveDuplicateOptionController@removeDuplicateOption');

    Route::group(['prefix' => 'default-product'], function () use ($systemAuth) {
        Route::get('/', [
            'as' => 'crawl-product::default-product',
            'uses' => 'DefaultProductController@index'
        ])->middleware($systemAuth); 

        Route::get('/find', 'DefaultProductController@find'); 
        Route::post('/save', 'DefaultProductController@save'); 
        Route::delete('/delete/{id}', 'DefaultProductController@delete'); 

        Route::any('/sync-config', [
            'as' => 'crawl-product::sync-config',
            'uses' => 'DefaultProductController@syncConfig'
        ]); 
    });

    Route::get('/get-products-etsy', 'NewProductController@getProductSearchedEtsy');
    Route::post('/save-product-etsy', 'NewProductController@saveProductSearchedEtsy');
});
