const request = require('request-promise');
const puppeteer = require('puppeteer');
const Proxy = require(__dir + '/src/config/proxy');
const Config = require(__dir + '/src/config/app');
const emojiStrip = require('emoji-strip');
const childProcess = require('child_process');
const fs = require('fs');
module.exports.sendRequest = async function (url, options = {}) {
    var headers = {
        'user-agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36',
    };
    if (options.headers) {
        headers = {...headers, ...options.headers};
    }
    let response = null;
    let params = {
        timeout: 20000,
        uri: url,
        headers: headers,
        followRedirect: false,
        maxRedirects: 0,
        rejectUnauthorized: false,
        gzip: true,
    };

    if (Config.useProxy) {
        params.proxy = "http://" + Proxy.username + ":" + Proxy.password + "@" + Proxy.url;
    }

    if (options.params) {
        params = {...params, ...options.params};
    }

    try {
        response = await request(params);
        if (!params.method || params.method.toLowerCase() == 'get') {
            response = emojiStrip(response);
        }
    } catch (e) {
        console.log('error on request ', url);
    }
    return response;

}

module.exports.sendRequestEtsy = async function (url, options = {}) {
    var headers = {
        'authority': 'www.etsy.com',
        'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
        'accept-language': 'en-US,en;q=0.9,vi;q=0.8',
        'cache-control': 'max-age=0',
        'cookie': 'uaid=Vq7iFfXqmSjcKYyPYYJRHMU-ak9jZACClK3fP4Ppjxfbq5VKEzNTlKyUDLNyirLMU3xK0jPSXEqqnNwsXSuKjbJ1C4393JVqGQA.; user_prefs=jfs4mtnKDMbFO966qBrod6n6hEpjZACClG8z62B0tFKYn4uSTl5pTo6OUmqebmiwkg5QCCpiBKFwEbEMAA..; fve=1693882750.0; _fbp=fb.1.1693882750894.8090464303402889; ua=531227642bc86f3b5fd7103a0c0b4fd6; _gcl_au=1.1.866178483.1693882755; _pin_unauth=dWlkPU0yTTFPV1psWWpFdE5URmxNaTAwTmpabUxUaG1ZV0V0TlRoa09HSTJORGN5TURsaA; _gid=GA1.2.369762999.1693970861; last_browse_page=https%3A%2F%2Fwww.etsy.com%2Fshop%2FTeePartea; search_options={"prev_search_term":"halloween%201978%20shirt","item_language":null,"language_carousel":null}; _ga_18FBCTGXSX=GS1.1.1693989933.2.0.1693989933.0.0.0; gift_session_v2=NV_Jnd20TgY0Dcl8c6kK95cqGAJjZACClO9fXoHpHwX6hgwA; _dc_gtm_UA-2409779-1=1; _ga=GA1.1.76404655.1693882755; _ga_KR3J610VYM=GS1.1.1694002961.6.1.1694003248.60.0.0; _uetsid=55e2ad204c6511ee9f1339e2e2c9ea2f; _uetvid=b35583b0dbd811ec8d85bf18bcbffe07; _derived_epik=dj0yJnU9ZFYwaDRhZVU2VWwtbVU0dG92QnhjMURuNU92cDJDMzgmbj1ZQ2dTUWU4ZFJVMkFQMVhHMFJwbU93Jm09MSZ0PUFBQUFBR1Q0Y0RBJnJtPTEmcnQ9QUFBQUFHVDRjREEmc3A9NQ; datadome=0UCrBoDLKuZkRlfCN91X3pHbfSpqIGFwk65q3KWyeqyNdOyqLBplx7QWY7KE3xX9~HrvgkOT~sZKzyPqjBbLsw6RBua-~zvBTUI-5_RuV4JdS17p9dMgr6NSxJ20lAhY',
        'sec-ch-ua': '"Chromium";v="116", "Not)A;Brand";v="24", "Google Chrome";v="116"',
        'sec-ch-ua-mobile': '?0',
        'sec-ch-ua-platform': '"macOS"',
        'sec-fetch-dest': 'document',
        'sec-fetch-mode': 'navigate',
        'sec-fetch-site': 'same-origin',
        'sec-fetch-user': '?1',
        'upgrade-insecure-requests': '1',
        'user-agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36'
    };
    if (options.headers) {
        headers = {...headers, ...options.headers};
    }
    let response = null;
    let params = {
        timeout: 20000,
        uri: url,
        headers: headers,
        followRedirect: false,
        maxRedirects: 0,
        rejectUnauthorized: false,
        gzip: true,
    };

    if (Config.useProxy) {
        params.proxy = "http://" + Proxy.username + ":" + Proxy.password + "@" + Proxy.url;
    }

    if (options.params) {
        params = {...params, ...options.params};
    }

    try {
        response = await request(params);
        if (!params.method || params.method.toLowerCase() == 'get') {
            //response = emojiStrip(response);
        }
        //writeResponse(response);
    } catch (e) {
        //console.log(e.toString());
        writeResponse(url);
        console.log('error on request ', url);
    }
    return response;

}
function writeResponse(response) {
    fs.appendFile( __dir + '/url-error.txt', response+ "\n", (err) => {
        if (err) {
            console.error('Lỗi khi ghi tệp:', err);
            return;
        }
    });

}

module.exports.callCurlWithPromise = async function (url) {
    let response = null;
    try {
        response = await curl(url);
    } catch (e) {
        console.log(e.toString());
        console.log('error on request ', url);
    }
    return response;
}

function curl(url) {
    return new Promise((resolve, reject) => {
        const curlCommand = `curl ${url}`;
        childProcess.exec(curlCommand, (error, stdout, stderr) => {
            if (error) {
                reject(error);
                return;
            }
            // const responseData = JSON.parse(stdout);
            resolve(stdout);
        });
    });
}


module.exports.sendRequestViaPuppeteer = async function (url, params) {
    const browser = await puppeteer.launch({
        // executablePath: '/usr/lib64/chromium-browser/headless_shell',
        args: ['--no-sandbox'],
        headless: 'new',
    });
    const page = await browser.newPage();
    
    const result = await page.evaluate(async ({ url, params }) => {
        let res = await fetch(url, { 
            headers: {'Content-Type': 'application/json'}, 
            method: 'POST', 
            body: JSON.stringify(params)
        }).then(res => res.json())
        .catch(err => {
            console.log('error');
        }) 

        return res;
    }, { url, params });
    await browser.close();
    return result;
}


module.exports.sendRequestRedbubble = async function (url, params) {
    return await fetch(url, {
        headers: {'Content-Type': 'application/json'},
        method: 'POST',
        body: JSON.stringify(params)
    }).then(res => res.json())
        .catch(err => {
            console.log('error');
        })
}

module.exports.sendRequestRedbubble2 = async function (url, params) {
    var options = {
        'method': 'POST',
        'url': url,
        'gzip': true,
        'headers': {
             Accept: '*/*',
            'Accept-Encoding': 'gzip, deflate',
            'Accept-Language': '*',
            'Content-Type': 'application/json',
            'Sec-Fetch-Mode': 'cors',
            'User-Agent': 'undici',
        },
        body: JSON.stringify(params)

    };

    let response = null;
    try {
        response = await request(options);
        response = JSON.parse(response);
    } catch (e) {
        console.log('error on request ', url);
    }
    return response;
}