const path = require('path');
const crypto = require('crypto');
const URLModule = require('url');
const regexCheckProduct = new RegExp('.*\\/.*\\/([\\d]+)-.*');
const emojiHandle = require('emoji-strip');
module.exports.random = function(min = 0, max = 10) {
    return random(min, max)
}

module.exports.ext = function(url) {
    const urlObj = new URL(url);
    return path.extname(urlObj.pathname);
}
function random(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}


module.exports.md5 = function(str) {
    return crypto.createHash('md5').update(str).digest("hex");
}
module.exports.dateFormat = function(date) {
    return date.getFullYear()
        + '-' + parseInt(date.getMonth() + 1)
        + '-' + date.getDay()
        + ' ' + date.getHours() + ':' + date.getMinutes() + ':00';
}

module.exports.getHostnameFromUrl = function (url) {
    if(!url) {
        return '';
    }
    let urlObj = URLModule.parse(url);
    return urlObj && urlObj.hostname ? urlObj.hostname : '';
}


module.exports.buildUrl  = function(url){
    if (!url) {
        return null;
    }
    let urlObj = new URL(url);
    url = urlObj.protocol + '//' + urlObj.hostname + urlObj.pathname;
    if(url.substr(-1) === '/') {
        url = url.substr(0, url.length - 1);
    }
    if (urlObj.searchParams.has('page')) {
        url += '?page=' +  urlObj.searchParams.get('page');
    }
    return url;
}

module.exports.sleep = async function(ms) {
    await new Promise((res) => {
        setTimeout(res, ms)
    });
}
module.exports.isProductUrl = function(url) {
    return regexCheckProduct.test(url);
}

module.exports.isTshirtUrl =  function(url) {
    return url.includes('/t-shirt/');
}

module.exports.emoji =  function(text) {
    if (text) {
        return emojiHandle(text);
    }
    return null;
}

module.exports.log = function() {
    //console.log(...arguments);
}



