const Utils = require(__dir + '/src/helper/utils');
class CrawlProductData {
    constructor() {
    }


    async InsertOrUpdate(data) {
        if(!this.validate(data)) {
            return;
        }
        data = this.buildData(data);
        const item = await this.getFirst(data);
        if(!item) {
            data.created_at = new Date();
            await global.knexConnection.table('sb_crawl_product_data').insert(data);
        } else {
            console.log(data.url, ' exists');
        }
    }


    async getFirst(data) {
        data = this.buildData(data);
        const row = await global.knexConnection.table('sb_crawl_product_data')
            .where('url', data.url)
            .where('md5_url', data.md5_url)
            .first('id');
        return typeof row === 'undefined' || !row ? false : row;
    }

    async Update(data) {
        const id = data.id;
        return  global.knexConnection.table('sb_crawl_product_data').where('id', '=', id).update(data);
    }

    async getAllUrl() {
        return  global.knexConnection.table('sb_crawl_product_data').pluck('url');
    }

    async getPending() {
        return global.knexConnection.table('sb_crawl_product_data')
            .where('url', 'like', '%/t-shirt/%')
            .whereNotNull('data')
            .where('status', 'PENDING')
            .pluck('id');
    }

    buildData(data) {
        data.md5_url = Utils.md5(data.url);
        return data;
    }

    validate(data) {
        let result = true;
        if (!data.url) {
            result = false;
        }
        return result;
    }
}
module.exports = CrawlProductData;