const Utils = require(__dir + '/src/helper/utils');
const table = 'sb_crawl_product_etsy_url';
class CrawlProductEtsyUrl {
    constructor() {
    }

    async InsertOrUpdate(data) {
        if (!this.validate(data)) {
            return;
        }

        data = this.buildData(data);
        if (data && data.id) {
            await global.knexConnection.table(table).where('id', data.id).update(data);
        } else {
            data.created_at = new Date();

            const item = await this.getFirst(data);
            if (!item) {
                data.created_at = new Date();
                await global.knexConnection.table(table).insert(data);
            } else {
                //console.log('exists ', item.id);
                //await global.knexConnection.table(table).where('id', item.id).update(data);
            }
        }
    }

    async updateById(data) {
        await global.knexConnection.table(table).where('id', data.id).update(data);
    }

    async MultiInsert(items) {
        await global.knexConnection.table(table).insert(items);
    }


    async getFirst(data) {
        data = this.buildData(data);
        const row = await global.knexConnection.table(table)
            .where('md5_url', data.md5_url)
            .first('id');
        return typeof row === 'undefined' || !row ? false : row;
    }

    async getByCat(cat) {
        return await global.knexConnection.table(table)
            .where('type', cat)
            .where('is_crawl', 0)
            .pluck('url');
    }

    async getTag(cat) {
        return await global.knexConnection.table(table)
            .where('type', 'tag')
            .where('is_crawl', 0)
            .where('url', 'like', '%' + cat + '%')
            .orderBy('id', 'desc')
            .pluck('url');
    }

    async getById(from, to) {
        return global.knexConnection.table(table)
            .select('id', 'url')
            .whereNull('type')
            .where('is_crawl', 0)
            .where('url',  'like','%/listing/%')
            .where('id', '>=', from)
            .where('id', '<', to);
    }

    buildData(data) {
        data.md5_url = Utils.md5(data.url);
        return data;
    }

    async listFromUrl() {
        return await global.knexConnection.table(table).pluck('from_url');
    }

    validate(data) {
        let result = true;
        if (!data.url) {
            result = false;
        }
        return result;
    }
}
module.exports = CrawlProductEtsyUrl;