const Utils = require(__dir + '/src/helper/utils');
const table = 'sb_crawl_product_spreadshirt';
class CrawlProductSpreadShirt {
    constructor() {
    }

    async InsertOrUpdate(data) {
        if(!this.validate(data)) {
            return;
        }
        data = this.buildData(data);
        await global.knexConnection.table(table).insert(data);
    }

    buildData(data) {
        data.created_at = new Date();
        return data;
    }

    validate(data) {
        let result = true;
        if (!data.url) {
            result = false;
        }
        return result;
    }

    async getAllKeywords() {
        let items = await global.knexConnection.table(table).pluck('keyword');
        let result = new Set();
        for (let slug of items) {
            result.add(slug);
        }
        return result;
    }

    async getProductId(fromId, toId) {
        return await global.knexConnection.table(table)
            .select('design_id', 'id')
            .where('id','>=', fromId)
            .where('id','<', toId);
    }

    async TickDuplicate(ids) {
        await global.knexConnection.table(table).whereIn('id', ids)
            .update({
            'clone_url': 'duplicate'
        });
    }
}
module.exports = CrawlProductSpreadShirt;