const Utils = require(__dir + '/src/helper/utils');

class CrawlProductUrl {
    constructor() {
    }

    async InsertOrUpdate(data) {
        if (!this.validate(data)) {
            return;
        }

        data = this.buildData(data);
        if (data && data.id) {
            await global.knexConnection.table('sb_crawl_product_url').where('id', data.id).update(data);
        } else {
            data.created_at = new Date();

            const item = await this.getFirst(data);
            if (!item) {
                data.created_at = new Date();
                await global.knexConnection.table('sb_crawl_product_url').insert(data);
            } else {
                await global.knexConnection.table('sb_crawl_product_url').where('id', item.id).update(data);
            }
        }
    }

    async MultiInsert(items) {
        await global.knexConnection.table('sb_crawl_product_url').insert(items);
    }


    async getFirst(data) {
        data = this.buildData(data);
        const row = await global.knexConnection.table('sb_crawl_product_url')
            .where('url', data.url)
            .where('md5_url', data.md5_url)
            .first('id');
        return typeof row === 'undefined' || !row ? false : row;
    }

    async getByCat(cat) {
        return await global.knexConnection.table('sb_crawl_product_url')
            .where('type', cat)
            .where('is_crawl', 0)
            .pluck('url');
    }

    async getTag(cat) {
        return await global.knexConnection.table('sb_crawl_product_url')
            .where('type', 'tag')
            .where('is_crawl', 0)
            .where('url', 'like', '%' + cat + '%')
            .orderBy('id', 'desc')
            .pluck('url');
    }

    async getById(from, to) {
        return global.knexConnection.table('sb_crawl_product_url')
            .select('id', 'url', 'category')
            .whereNull('type')
            .where('id', '>=', from)
            .where('id', '<', to);
    }

    buildData(data) {
        data.md5_url = Utils.md5(data.url);
        if (Utils.isTshirtUrl(data.url)) {
            data.type = 't-shirt';
        }
        return data;
    }

    validate(data) {
        let result = true;
        if (!data.url) {
            result = false;
        }
        return result;
    }
}
module.exports = CrawlProductUrl;