const table = 'sb_crawl_zazzle';
class CrawlZazzle {
    constructor() {
    }

    async InsertOrUpdate(data) {
        if(!this.validate(data)) {
            return;
        }
        //data = this.buildData(data);
        await global.knexConnection.table(table).insert(data);
    }

    async MultiInsert(data) {
        await global.knexConnection.table(table).insert(data);
    }

    async TickDelete(ids) {
        await global.knexConnection.table(table).whereIn('id', ids).update({
            'image_url': 1
        });
    }

    buildData(data) {
        return data;
    }

    validate(data) {
        let result = true;
        if (!data.design_id) {
            result = false;
        }
        return result;
    }

    async getAllSlug() {
        //fr to 65514916
        //uk to 52853291
        //de to 40196904
        //us to 27501027
        //16143437
        //4852694
        let items = await global.knexConnection.table(table).where('id','>', 1).pluck('store_slug');
        let result = new Set();
        for (let slug of items) {
            result.add(slug);
        }
        return result;
    }

    async getProductId(fromId, toId) {
        return await global.knexConnection.table(table)
            .select('product_id', 'id')
            .where('id','>=', fromId)
            .where('id','<', toId);
    }
}
module.exports = CrawlZazzle;