const table = 'sb_crawl_keyword_history';


module.exports.get =  async function(filter = {}) {
    return await global.knexConnection.table(table).pluck('url');
}

module.exports.history =  async function(filter = {}) {
    let urls =  await global.knexConnection.table(table).pluck('url');
    let result = new Set();
    if (urls) {
        for (let url of urls) {
            result.add(url)
        }
    }
    return result;

}

module.exports.insert =  async function(data) {
    data.created_at = new Date();
    await global.knexConnection.table(table).insert(data);
}

module.exports.insertRedbubbleHistory =  async function(data) {
    data.created_at = new Date();
    await global.knexConnection.table('sb_crawl_redbubble_history').insert(data);
}