const cheerio = require('cheerio');
const table = 'sb_crawl_product_etsy';
class EtsyByCategory {
    async getAllIdToUpdateCategory() {
        let ids = [];
        let data = await global.knexConnection.table(table).whereNull('category').select('id');
        for (let ele of data) {
            ids.push(ele.id)
        }

        return ids;
    }

    async getById(id) {
        return global.knexConnection.table(table).where('id', '=', id).whereNull('category').first('id', 'data')
    }

    async Update(data) {
        const id = data.id;
        return global.knexConnection.table(table).where('id', '=', id).update(data);
    }

    async updateCategory() {
        let ids = await this.getAllIdToUpdateCategory()
        for (let id of ids) {
            await this.parseAndUpdateCategory(id)
        }
        console.log('Update successfully')
    }

    async parseAndUpdateCategory(id) {
        let data =  await this.getById(id);
        let htmlString = data.data;
        const $ = cheerio.load(htmlString);
        let eleCategory = $('#content > div.content-wrap.listing-page-content > div.wt-body-max-width.wt-mb-xs-6.wt-pl-md-4.wt-pr-md-4.wt-pl-lg-5.wt-pr-lg-5 > div.wt-text-caption.wt-text-center-xs.wt-text-left-lg > :last-child');
        let textCategory = eleCategory.text();
        let dataUpdate = {
            'id': data.id,
            'category': textCategory,
        }
        await this.Update(dataUpdate)
        console.log('success with id ' + data.id)
    }
}

module.exports = EtsyByCategory;