const Utils = require(__dir + '/src/helper/utils');
const KeywordsUtil = require(__dir + '/src/helper/keywords');
const TaskQueue = require(__dir + '/src/helper/queue');
const Service = require(__dir + '/src/helper/service');
const etsyParser = require(__dir + '/src/parser/etsy');
const EtsyCrawler = require(__dir + '/src/spider/etsy')
const CrawlEtsyData = require(__dir + '/src/models/crawl_product_etsy');
const CrawlEtsyUrl = require(__dir + '/src/models/crawl_product_etsy_url');
const Keywords = require(__dir + '/src/models/keywords');
const CrawlEtsyUrlObj = new CrawlEtsyUrl();
const CrawlEtsyDataObj = new CrawlEtsyData();
const EtsyParser = new etsyParser();
const readline = require('readline');
const fs = require('fs');

const maxDepth = 15;
const enableHostName = [
    'www.etsy.com',
    'etsy.com',
];
const UrlLog = new Set();
class EtsyByKeywords extends EtsyCrawler{

    async crawlPage(url, category = null) {
        let response = await Service.sendRequestEtsy(url);
        if (response) {
            let parseData = EtsyParser.parse(url, response);
            if (parseData && parseData.links) {
                for (let itemUrl of parseData.links) {
                    if (this.hasProduct(itemUrl)) {
                        itemUrl = Utils.buildUrl(itemUrl);
                        this.pushInsertUrl(itemUrl, category, url);
                    }
                }
            }
        } else {
            this.log('response is empty ', url);
        }
    }

    pushCrawlPage(url, category = '') {
        let self = this;
        let task = () => {
            return self.crawlPage(url, category).catch(function (e) {
                console.log('err request:' + url, e);
                return Promise.resolve();
            });
        };
        self.spiderQueue.pushTask(task);
    }



    async crawlKeywords() {
         let keywords = await Keywords.get();
         let categories = [
             't-shirt',
             'hoodies',
            'sweatshirts',
            'mugs',
            'posters',
            // 'mugs',
            // 'stickers',
         ]
        for (let category of categories) {
            let templateUrls = this.getTemplateUrls(category);
            const urlByKeywords = KeywordsUtil.buildUrlKeywords(keywords, templateUrls, 1, 1);
            const urls = KeywordsUtil.filterHistory(urlByKeywords, await this.history());
            console.log('url', urls.length)
            if (urls) {
                for (let url of urls) {
                    this.pushCrawlPage(url, category);
                }
            }
        }

    }

    async history() {
        let result = new Set();
        const fileStream = fs.createReadStream(__dir + '/url-error.txt');
        const rl = readline.createInterface({
            input: fileStream,
            crlfDelay: Infinity // To recognize all line endings, including Windows \r\n
        });
        rl.on('line', (line) => {
            // Process each line here
            //result.add(line)
        });

        rl.on('close', () => {
            //console.log('Reading finished.');
        });
        let urls = await CrawlEtsyUrlObj.listFromUrl();
        if (urls) {
            for (let url of urls) {
                result.add(url);
            }
        }
        return result;
    }



    getTemplateUrls(category) {
        let config = {
            't-shirt': [
                'https://www.etsy.com/search/clothing/mens-clothing/shirts-and-tees/tshirts?q={keyword}&attr_4=39&ship_to=US&page={page}&ref=pagination',
                'https://www.etsy.com/search/clothing/mens-clothing/shirts-and-tees/tshirts?q={keyword}&order=highest_reviews&attr_4=39&ship_to=US&page={page}&ref=pagination',
                'https://www.etsy.com/search/clothing/mens-clothing/shirts-and-tees/tshirts?q={keyword}&page={page}&ref=pagination',
                'https://www.etsy.com/search/clothing/womens-clothing/tops-and-tees/tshirts?q={keyword}&attr_4=39&ship_to=US&page={page}&ref=pagination',
                'https://www.etsy.com/search/clothing/womens-clothing/tops-and-tees/tshirts?q={keyword}&page={page}&ref=pagination',
                'https://www.etsy.com/search/clothing/womens-clothing/tops-and-tees/tshirts?q={keyword}&order=highest_reviews&attr_4=39&ship_to=US&page={page}&ref=pagination',
            ],
            'hoodies': [
                'https://www.etsy.com/search/clothing/gender-neutral-adult-clothing/hoodies-and-sweatshirts/hoodies?q={keyword}&page={page}&explicit=1&ship_to=US',
                'https://www.etsy.com/search/clothing/gender-neutral-adult-clothing/hoodies-and-sweatshirts/hoodies?q={keyword}&order=highest_reviews&page={page}&explicit=1&ship_to=US',
            ],
            'sweatshirts': [
                'https://www.etsy.com/search/clothing/mens-clothing/hoodies-and-sweatshirts/sweatshirts?q={keyword}&page={page}&explicit=1',
                'https://www.etsy.com/search/clothing/womens-clothing/hoodies-and-sweatshirts/sweatshirts?q={keyword}&page={page}&explicit=1',
                'https://www.etsy.com/search/clothing/mens-clothing/hoodies-and-sweatshirts/sweatshirts?q={keyword}&order=highest_reviews&page={page}&explicit=1',
                'https://www.etsy.com/search/clothing/womens-clothing/hoodies-and-sweatshirts/sweatshirts?q={keyword}&order=highest_reviews&page={page}&explicit=1',
            ],
            'mugs': [
                'https://www.etsy.com/search/home-and-living/kitchen-and-dining/drink-and-barware/drinkware/mugs?q={keyword}&page={page}&explicit=1',
                'https://www.etsy.com/search/home-and-living/kitchen-and-dining/drink-and-barware/drinkware/mugs?q={keyword}&order=highest_reviews&page={page}&explicit=1',
            ],
            // 'posters': [
            //     'https://www.etsy.com/search/home-and-living/kitchen-and-dining/drink-and-barware/drinkware/mugs?q={keyword}&page={page}&explicit=1',
            //     'https://www.etsy.com/search/home-and-living/kitchen-and-dining/drink-and-barware/drinkware/mugs?q={keyword}&order=highest_reviews&page={page}&explicit=1',
            // ],
            // 'stickers': [
            //     'https://www.etsy.com/search/home-and-living/kitchen-and-dining/drink-and-barware/drinkware/mugs?q={keyword}&page={page}&explicit=1',
            //     'https://www.etsy.com/search/home-and-living/kitchen-and-dining/drink-and-barware/drinkware/mugs?q={keyword}&order=highest_reviews&page={page}&explicit=1',
            // ],
        }
        return config[category];
        // return [
        //     'https://www.etsy.com/search/clothing/mens-clothing/shirts-and-tees/tshirts?q=father+day&explicit=1&attr_4=39&ship_to=US&page=3&ref=pagination'
        //     // 'https://www.etsy.com/search?q={keyword}&order=highest_reviews&page={page}&ref=pagination',
        //     // 'https://www.etsy.com/search?q={keyword}&page={page}&ref=pagination',
        // ]
    }





}


module.exports = EtsyByKeywords;