
const Utils = require(__dir + '/src/helper/utils');
const TaskQueue = require(__dir + '/src/helper/queue');
const Service = require(__dir + '/src/helper/service');
const Config = require(__dir + '/src/config/crawl')
const fs = require('fs');
const Keywords = require(__dir + '/src/models/keywords');
const History = require(__dir + '/src/models/history');
const Redbubble= require(__dir + '/src/spider/redbubble');
const handleSearchQueue = new TaskQueue(5, 'handleSearchQueue', true);
class RedbubbleByKeywords extends Redbubble {
    async crawlByKeywords() {
        let keywords = await Keywords.get();
        let categories = this.getTagCategoryFilter();
        let history = await History.history()
        for (let keywordItem of keywords) {
            for (let category in categories) {
                for (let page = 1;page <= 2; page++) {
                    if (history.has(this.buildLogUrl(keywordItem.keyword, category, categories[category], page))) {
                        console.log('exists ', keywordItem.keyword);
                        continue;
                    }
                    this.pushToSearchQueue(keywordItem.keyword, category, categories[category], page)
                }
            }
        }
    }


    pushToSearchQueue(keyword, category, ioCode, page) {
        let self = this;
        let task = () => {
            return self.search(keyword, category, ioCode, page).catch(function (e) {
                console.log('err pushToSearchQueue:', e.toString());
                return Promise.resolve();
            });
        };
        handleSearchQueue.pushTask(task);
    }

    async search(keyword, category, ioCode, page) {
        console.log('search ...', keyword ,category, page);
        let  params = this.buildSearchParams(keyword, ioCode, page);
        let res = await this.getDataCurl(params);
        History.insert({
            url: this.buildLogUrl(keyword, category, ioCode, page)
        });
        if (res && res.data && res.data.searchResults) {
            let items = res.data.searchResults.results;
            console.log('items', items.length);
            let result = [];
            for (let item of items) {
                if (item.inventoryItem) {
                    //@todo validate
                    // if (!this.validateItem(item, category)) {
                    //     continue;
                    // }
                    result.push(this.buildItem(item, category))
                }
            }
            await this.storeData(result, category);
        }
    }

    buildLogUrl(keyword, category, ioCode, page) {
        return 'https://www.redbubble.com/' + keyword + category + ioCode + page;
    }

    buildSearchParams(keyword, iaCode, page = 1) {
        return {
            "operationName": "withSearchResults",
            "variables": {
                "query": keyword,
                "queryParams": {
                    "page": page,
                    "iaCode": iaCode,
                    "queryParamItems": [
                        {
                            "name": "query",
                            "values": keyword
                        }
                    ],
                    "searchType": "find"
                },
                "locale": "en",
                "country": "US",
                "currency": "USD",
                "previewTypeIds": [
                    "product_close",
                    "alternate_product_close",
                    "artwork"
                ],
                "experience": "srp"
            },
            "query": "query withSearchResults($query: String!, $queryParams: QueryParams, $locale: String!, $country: String!, $currency: String!, $previewTypeIds: [String!], $experience: String) {\n  searchResults(query: $query, queryParams: $queryParams, locale: $locale, country: $country, currency: $currency, previewTypeIds: $previewTypeIds, experience: $experience) {\n    ...Results\n    ...TrendingResults\n    ...Metadata\n    ...Filters\n    ...Pagination\n    ...LandingPage\n    __typename\n  }\n}\n\nfragment Results on SearchResults {\n  results {\n    inventoryItem(locale: $locale, country: $country, currency: $currency, previewTypeIds: $previewTypeIds) {\n      id\n      marketingProductTypeId\n      description\n      productTypeId\n      productPageUrl\n      blankItemId\n      prominentMessage\n      price {\n        id\n        amount\n        currency\n        discount {\n          amount\n          percent\n          __typename\n        }\n        __typename\n      }\n      previewSet {\n        id\n        previews {\n          previewTypeId\n          url\n          __typename\n        }\n        __typename\n      }\n      gaCode\n      gaCategory\n      attributes {\n        name\n        value\n        attributes {\n          name\n          value\n          __typename\n        }\n        __typename\n      }\n      volumeDiscount {\n        id\n        thresholds {\n          percentOff\n          quantity\n          __typename\n        }\n        __typename\n      }\n      experiencesProductCard {\n        name\n        value\n        __typename\n      }\n      __typename\n    }\n    work(locale: $locale) {\n      id\n      title\n      artistName\n      isMatureContent\n      tags\n      __typename\n    }\n    defaultPreviewTypeId\n    groupId\n    rank\n    __typename\n  }\n  __typename\n}\n\nfragment TrendingResults on SearchResults {\n  trendingResults {\n    inventoryItem(locale: $locale, country: $country, currency: $currency, previewTypeIds: $previewTypeIds) {\n      id\n      marketingProductTypeId\n      description\n      productPageUrl\n      productTypeId\n      price {\n        id\n        amount\n        currency\n        __typename\n      }\n      previewSet {\n        id\n        previews {\n          previewTypeId\n          url\n          __typename\n        }\n        __typename\n      }\n      volumeDiscount {\n        id\n        thresholds {\n          percentOff\n          quantity\n          __typename\n        }\n        __typename\n      }\n      gaCode\n      gaCategory\n      attributes {\n        name\n        value\n        attributes {\n          name\n          value\n          __typename\n        }\n        __typename\n      }\n      experiencesProductCard {\n        name\n        value\n        __typename\n      }\n      __typename\n    }\n    work(locale: $locale) {\n      id\n      title\n      artistName\n      isMatureContent\n      tags\n      __typename\n    }\n    defaultPreviewTypeId\n    groupId\n    rank\n    __typename\n  }\n  __typename\n}\n\nfragment Metadata on SearchResults {\n  metadata {\n    title\n    searchContext {\n      category\n      __typename\n    }\n    resultCount\n    topic\n    searchBar {\n      iaCode\n      pillLabel\n      keywords\n      __typename\n    }\n    __typename\n  }\n  __typename\n}\n\nfragment Filters on SearchResults {\n  filters {\n    resetUrl\n    staticFilters {\n      type\n      label\n      options {\n        name\n        label\n        applied\n        url\n        options {\n          name\n          label\n          applied\n          url\n          __typename\n        }\n        __typename\n      }\n      __typename\n    }\n    filters {\n      type\n      label\n      experiences {\n        name\n        value\n        __typename\n      }\n      options {\n        name\n        label\n        applied\n        disabled\n        url\n        hexColor\n        imageUrl\n        __typename\n      }\n      __typename\n    }\n    appliedCount\n    appliedPath\n    resets {\n      label\n      url\n      __typename\n    }\n    __typename\n  }\n  __typename\n}\n\nfragment Pagination on SearchResults {\n  pagination {\n    currentPage\n    perPage\n    showPreviousPageLink\n    showNextPageLink\n    paginationLinks {\n      namedLinks {\n        previousPage {\n          rel\n          url\n          __typename\n        }\n        nextPage {\n          rel\n          url\n          __typename\n        }\n        __typename\n      }\n      __typename\n    }\n    fromNumber\n    toNumber\n    total\n    __typename\n  }\n  __typename\n}\n\nfragment LandingPage on SearchResults {\n  metadata {\n    formattedQuery\n    landingPage {\n      hero {\n        pitch\n        title\n        image\n        color\n        __typename\n      }\n      bubbles {\n        title\n        items {\n          title\n          image\n          realisticImage\n          url\n          isExternal\n          __typename\n        }\n        hasImages\n        __typename\n      }\n      seoMetadata {\n        pageDescription\n        robots\n        canonicalURL\n        searchTitle\n        seoImage\n        alternatePageVersions {\n          href\n          locale\n          __typename\n        }\n        relatedTagLinks {\n          title\n          href\n          text\n          __typename\n        }\n        faq {\n          title\n          items {\n            question\n            answer\n            __typename\n          }\n          __typename\n        }\n        __typename\n      }\n      footer {\n        text\n        readMoreText\n        breadcrumbs {\n          name\n          url\n          __typename\n        }\n        __typename\n      }\n      __typename\n    }\n    relatedTopics {\n      title\n      url\n      __typename\n    }\n    relatedProducts {\n      id\n      url\n      productTitle\n      fullTitle\n      __typename\n    }\n    searchPageType\n    resultCount\n    searchUUID\n    __typename\n  }\n  __typename\n}\n"
        }
    }
}
module.exports = RedbubbleByKeywords;
