const Utils = require(__dir + '/src/helper/utils');
const Sitemap = require(__dir + '/src/parser/sitemap');
const TaskQueue = require(__dir + '/src/helper/queue');
const Service = require(__dir + '/src/helper/service');
const CrawlRedbubble = require(__dir + '/src/models/crawl_redbubble');
const crawlRedbubbleObj = new CrawlRedbubble();
const CrawlRedbubbleAttribute = require(__dir + '/src/models/crawl_redbubble_attribute');
const crawlRedbubbleAttributeObj = new CrawlRedbubbleAttribute();
const Config = require(__dir + '/src/config/crawl')
const fs = require('fs');
const Keywords = require(__dir + '/src/models/keywords');
const History = require(__dir + '/src/models/history');
class Redbubble {

    constructor() {
        this.handleCategoryQueue = new TaskQueue(1, 'spider category');
        // this.insertProductUrlQueue = new TaskQueue(10, 'queue redbubble insert');
        this.category = null;
        this.slugs = {};
        this.siteUrl = Config.siteUrl;
        this.maxDepth = Config.maxDepth;
    }

    getCategorySlugs() {
        return {
            "t-shirt": "u-tees",
            "hoodies": "u-sweatshirt-hooded",
            "tank-tops": "u-tanks",
            "posters": "u-print-poster",
            // "tank-tops": "tall-larrikin",
            // "kids-pullover-hoodies": "big-wheelie",
            // "travel-mugs": "chewy-runners",
            // "baby-onepieces": "baby-one-pieces",
            // "drawstring-bags": "aggro-clanger",
            // "aprons": "gnarly-seesaw",


            "tote-bags": "all-totes",
            "canvas-prints": "u-print-canvas",   
            "leggings": "w-leggings",   
            "pin-buttons": "u-pin-button",   
            "tapestry": "u-print-tapestry",   
            "bath-mats": "u-bath-mat",   
            "shower-curtains": "u-shower-curtain",   
            "iphone-cases": "u-case-iphone",   
            "lightweight-hoodies": "u-sweatshirt-lightweight-hooded",
            "sweatshirts": "u-sweatshirt-pullover",
            "lightweight-sweatshirts": "u-sweatshirt-lightweight-raglan",
            "travel-mugs": "u-mugs",
            "stickers": "all-stickers",
            "baby-onepieces": "b-onesie-short",
            "longsleeve-onesies": "b-onesie-long",
            "backpacks": "u-backpack",
            "baseball-caps": "all-caps",
            "socks": "u-socks",
            "scarves": "w-scarf",
        };
    }

    getTagCategoryFilter() {
        return {
            // "tank-tops": "u-tanks",
            // "kids-pullover-hoodies": "k-pullover-hoodie",
            // "travel-mugs": "u-mugs",
            // "canvas-prints": "u-print-canvas",
            // "leggings": "w-leggings",
            // "baby-onepieces": "b-onesie-short",
            // "backpacks": "u-backpack",
            // "pin-buttons": "u-pin-button",
            // "drawstring-bags": "u-bag-drawstring",
            // "socks": "u-socks",
            // "tote-bags": "all-totes",
            // "aprons": "u-apron",
            // "tapestry": "u-print-tapestry",
            // "bath-mats": "u-bath-mat",
            // "shower-curtains": "u-shower-curtain",
            // "posters": "u-print-poster",
            // "iphone-cases": "u-case-iphone",
            "t-shirt": "u-tees",
            "hoodies": "u-sweatshirt-hooded",
            // "lightweight-hoodies": "u-sweatshirt-lightweight-hooded",
            // "sweatshirts": "u-sweatshirt-pullover",
            // "lightweight-sweatshirts": "u-sweatshirt-lightweight-raglan",
            // "stickers": "all-stickers",
            // "longsleeve-onesies": "b-onesie-long",
            // "baseball-caps": "all-caps",
            // "scarves": "w-scarf",
            // "travel-mugs": "u-mugs",
        }
    }

    gaCodeToCategorySlug(gaCode) {
        const categoryMapByCode =  {
            "classic-tshirt": "t-shirts",
            "unisex-tshirt": "t-shirts",
            "womens-tshirt": "t-shirts",
            "unisex-vneck-tshirt": "t-shirts",
            "heather-tshirt": "t-shirts",
            "womens-relaxed-fit-tshirt": "t-shirts",
            "womens-premium-t-shirt": "t-shirts",
            "mens-premium-t-shirt": "t-shirts",
            "long-t-shirt": "t-shirts",
            "mens-graphic-t-shirt": "t-shirts",
            "womens-fitted-vneck-tshirt": "t-shirts",
            "womens-fitted-scoop-tshirt": "t-shirts",
            "chiffon-top": "t-shirts",
            "active-tshirt": "t-shirts",

            "unisex-baseball-sleeve-tshirt": "baseball-tees",

            "contrast-tank": "tank-tops",
            "womens-racerback": "tank-tops",
            "unisex-tank-top": "tank-tops",

            "unisex-hoodie": "hoodies",
            "lightweight-hoodie": "hoodies",
            "unisex-hoodie": "hoodies",


            "lightweight-raglan-sweatshirt": "sweatshirts",
            "unisex-sweatshirt": "sweatshirts",

            "unisex-zipper-hoodie": "zip-hoodies",
            
            "unisex-longsleeve-tshirt": "longsleeves",

            "pencil-skirt": "womens-mini-skirt",
            "leggings": "leggings",

            "a-line-dress": "racerback-dresses",
            "graphic-t-shirt-dress": "womens-tshirt-dress",
            "sticker": "stickers",
            "glossy-sticker": "stickers",
            "transparent-sticker": "stickers",

            "samsung-galaxy-soft-case": "samsung-galaxy-cases",
            "samsung-galaxy-snap-case": "samsung-galaxy-cases",
            "samsung-galaxy-tough-case": "samsung-galaxy-cases",

            "iphone-tough-case": "iphone-cases",
            "iphone-soft-case": "iphone-cases",
            "iphone-snap-case": "iphone-cases",

            "poster": "premium-matte-vertical-posters",
            "canvas-print": "canvas",

            "standard-mug": "mugs",
            "tall-mug": "mugs",
            "wall-tapestry": "tapestries",
            "bath-mat": "bath-mat",
            "shower-curtain": "shower-curtains",
            "leggings": "leggings",
            "baby-one-piece-short-sleeve": "onesies",
            "baby-one-piece-long-sleeve": "onesies",
            "kids-tshirt": "baby-t-shirts",
            "baby-tshirt": "baby-t-shirts",
            "kids-hoodie": "kids-pullover-hoodies",
            "toddler-hoodie": "kids-pullover-hoodies",
            "cotton-tote": "tote-bags",
            "tote-bag": "tote-bags-aop",
            "socks": "socks",
            "scarf": "scarves",
            "backpack": "backpacks"
        }

        return categoryMapByCode[gaCode];
    }

    buildCategoryParams(queueData, page) {
        return {
            "operationName": "withSearchResults",
            "variables": {
                "query": queueData.slug,
                "queryParams": {
                    "page": page,
                    "queryParamItems": [],
                    "searchType": "browse"
                },
                "locale": "en",
                "country": "US",
                "currency": "USD",
                "previewTypeIds": [
                    "product_close",
                    "alternate_product_close",
                    "artwork"
                ],
                "experience": "srp"
            },
            "query": "query withSearchResults($query: String!, $queryParams: QueryParams, $locale: String!, $country: String!, $currency: String!, $previewTypeIds: [String!], $experience: String) {\n  searchResults(query: $query, queryParams: $queryParams, locale: $locale, country: $country, currency: $currency, previewTypeIds: $previewTypeIds, experience: $experience) {\n    ...Results\n    ...TrendingResults\n    ...Metadata\n    ...Filters\n    ...Pagination\n    ...LandingPage\n    __typename\n  }\n}\n\nfragment Results on SearchResults {\n  results {\n    inventoryItem(locale: $locale, country: $country, currency: $currency, previewTypeIds: $previewTypeIds) {\n      id\n      marketingProductTypeId\n      description\n      productTypeId\n      productPageUrl\n      blankItemId\n      prominentMessage\n      price {\n        id\n        amount\n        currency\n        discount {\n          amount\n          percent\n          __typename\n        }\n        __typename\n      }\n      previewSet {\n        id\n        previews {\n          previewTypeId\n          url\n          __typename\n        }\n        __typename\n      }\n      gaCode\n      gaCategory\n      attributes {\n        name\n        value\n        attributes {\n          name\n          value\n          __typename\n        }\n        __typename\n      }\n      volumeDiscount {\n        id\n        thresholds {\n          percentOff\n          quantity\n          __typename\n        }\n        __typename\n      }\n      experiencesProductCard {\n        name\n        value\n        __typename\n      }\n      __typename\n    }\n    work(locale: $locale) {\n      id\n      title\n      artistName\n      isMatureContent\n      tags\n      __typename\n    }\n    defaultPreviewTypeId\n    groupId\n    rank\n    __typename\n  }\n  __typename\n}\n\nfragment TrendingResults on SearchResults {\n  trendingResults {\n    inventoryItem(locale: $locale, country: $country, currency: $currency, previewTypeIds: $previewTypeIds) {\n      id\n      marketingProductTypeId\n      description\n      productPageUrl\n      productTypeId\n      price {\n        id\n        amount\n        currency\n        __typename\n      }\n      previewSet {\n        id\n        previews {\n          previewTypeId\n          url\n          __typename\n        }\n        __typename\n      }\n      volumeDiscount {\n        id\n        thresholds {\n          percentOff\n          quantity\n          __typename\n        }\n        __typename\n      }\n      gaCode\n      gaCategory\n      attributes {\n        name\n        value\n        attributes {\n          name\n          value\n          __typename\n        }\n        __typename\n      }\n      experiencesProductCard {\n        name\n        value\n        __typename\n      }\n      __typename\n    }\n    work(locale: $locale) {\n      id\n      title\n      artistName\n      isMatureContent\n      tags\n      __typename\n    }\n    defaultPreviewTypeId\n    groupId\n    rank\n    __typename\n  }\n  __typename\n}\n\nfragment Metadata on SearchResults {\n  metadata {\n    title\n    searchContext {\n      category\n      __typename\n    }\n    resultCount\n    topic\n    searchBar {\n      iaCode\n      pillLabel\n      keywords\n      __typename\n    }\n    __typename\n  }\n  __typename\n}\n\nfragment Filters on SearchResults {\n  filters {\n    resetUrl\n    staticFilters {\n      type\n      label\n      options {\n        name\n        label\n        applied\n        url\n        options {\n          name\n          label\n          applied\n          url\n          __typename\n        }\n        __typename\n      }\n      __typename\n    }\n    filters {\n      type\n      label\n      experiences {\n        name\n        value\n        __typename\n      }\n      options {\n        name\n        label\n        applied\n        disabled\n        url\n        hexColor\n        imageUrl\n        __typename\n      }\n      __typename\n    }\n    appliedCount\n    appliedPath\n    resets {\n      label\n      url\n      __typename\n    }\n    __typename\n  }\n  __typename\n}\n\nfragment Pagination on SearchResults {\n  pagination {\n    currentPage\n    perPage\n    showPreviousPageLink\n    showNextPageLink\n    paginationLinks {\n      namedLinks {\n        previousPage {\n          rel\n          url\n          __typename\n        }\n        nextPage {\n          rel\n          url\n          __typename\n        }\n        __typename\n      }\n      __typename\n    }\n    fromNumber\n    toNumber\n    total\n    __typename\n  }\n  __typename\n}\n\nfragment LandingPage on SearchResults {\n  metadata {\n    formattedQuery\n    landingPage {\n      hero {\n        pitch\n        title\n        image\n        color\n        __typename\n      }\n      bubbles {\n        title\n        items {\n          title\n          image\n          realisticImage\n          url\n          isExternal\n          __typename\n        }\n        hasImages\n        __typename\n      }\n      seoMetadata {\n        pageDescription\n        robots\n        canonicalURL\n        searchTitle\n        seoImage\n        alternatePageVersions {\n          href\n          locale\n          __typename\n        }\n        relatedTagLinks {\n          title\n          href\n          text\n          __typename\n        }\n        faq {\n          title\n          items {\n            question\n            answer\n            __typename\n          }\n          __typename\n        }\n        __typename\n      }\n      footer {\n        text\n        readMoreText\n        breadcrumbs {\n          name\n          url\n          __typename\n        }\n        __typename\n      }\n      __typename\n    }\n    relatedTopics {\n      title\n      url\n      __typename\n    }\n    relatedProducts {\n      id\n      url\n      productTitle\n      fullTitle\n      __typename\n    }\n    searchPageType\n    resultCount\n    searchUUID\n    __typename\n  }\n  __typename\n}\n"
        }
    }

    buildTagParams(queueData, page) {
        return {
            "operationName": "withSearchResults",
            "variables": {
                "query": queueData.query,
                "queryParams": {
                    "iaCode": this.getTagCategoryFilter()[queueData.categorySlug],
                    "queryParamItems": [
                        {
                            "name": "query",
                            "values": queueData.query
                        }
                    ],
                    "searchType": "find"
                },
                "locale": "en",
                "country": "US",
                "currency": "USD",
                "previewTypeIds": [
                    "product_close",
                    "alternate_product_close",
                    "artwork"
                ],
                "experience": "srp"
            },
            "query": "query withSearchResults($query: String!, $queryParams: QueryParams, $locale: String!, $country: String!, $currency: String!, $previewTypeIds: [String!], $experience: String) {\n  searchResults(query: $query, queryParams: $queryParams, locale: $locale, country: $country, currency: $currency, previewTypeIds: $previewTypeIds, experience: $experience) {\n    ...Results\n    ...TrendingResults\n    ...Metadata\n    ...Filters\n    ...Pagination\n    ...LandingPage\n    __typename\n  }\n}\n\nfragment Results on SearchResults {\n  results {\n    inventoryItem(locale: $locale, country: $country, currency: $currency, previewTypeIds: $previewTypeIds) {\n      id\n      marketingProductTypeId\n      description\n      productTypeId\n      productPageUrl\n      blankItemId\n      prominentMessage\n      price {\n        id\n        amount\n        currency\n        discount {\n          amount\n          percent\n          __typename\n        }\n        __typename\n      }\n      previewSet {\n        id\n        previews {\n          previewTypeId\n          url\n          __typename\n        }\n        __typename\n      }\n      gaCode\n      gaCategory\n      attributes {\n        name\n        value\n        attributes {\n          name\n          value\n          __typename\n        }\n        __typename\n      }\n      volumeDiscount {\n        id\n        thresholds {\n          percentOff\n          quantity\n          __typename\n        }\n        __typename\n      }\n      experiencesProductCard {\n        name\n        value\n        __typename\n      }\n      __typename\n    }\n    work(locale: $locale) {\n      id\n      title\n      artistName\n      isMatureContent\n      tags\n      __typename\n    }\n    defaultPreviewTypeId\n    groupId\n    rank\n    __typename\n  }\n  __typename\n}\n\nfragment TrendingResults on SearchResults {\n  trendingResults {\n    inventoryItem(locale: $locale, country: $country, currency: $currency, previewTypeIds: $previewTypeIds) {\n      id\n      marketingProductTypeId\n      description\n      productPageUrl\n      productTypeId\n      price {\n        id\n        amount\n        currency\n        __typename\n      }\n      previewSet {\n        id\n        previews {\n          previewTypeId\n          url\n          __typename\n        }\n        __typename\n      }\n      volumeDiscount {\n        id\n        thresholds {\n          percentOff\n          quantity\n          __typename\n        }\n        __typename\n      }\n      gaCode\n      gaCategory\n      attributes {\n        name\n        value\n        attributes {\n          name\n          value\n          __typename\n        }\n        __typename\n      }\n      experiencesProductCard {\n        name\n        value\n        __typename\n      }\n      __typename\n    }\n    work(locale: $locale) {\n      id\n      title\n      artistName\n      isMatureContent\n      tags\n      __typename\n    }\n    defaultPreviewTypeId\n    groupId\n    rank\n    __typename\n  }\n  __typename\n}\n\nfragment Metadata on SearchResults {\n  metadata {\n    title\n    searchContext {\n      category\n      __typename\n    }\n    resultCount\n    topic\n    searchBar {\n      iaCode\n      pillLabel\n      keywords\n      __typename\n    }\n    __typename\n  }\n  __typename\n}\n\nfragment Filters on SearchResults {\n  filters {\n    resetUrl\n    staticFilters {\n      type\n      label\n      options {\n        name\n        label\n        applied\n        url\n        options {\n          name\n          label\n          applied\n          url\n          __typename\n        }\n        __typename\n      }\n      __typename\n    }\n    filters {\n      type\n      label\n      experiences {\n        name\n        value\n        __typename\n      }\n      options {\n        name\n        label\n        applied\n        disabled\n        url\n        hexColor\n        imageUrl\n        __typename\n      }\n      __typename\n    }\n    appliedCount\n    appliedPath\n    resets {\n      label\n      url\n      __typename\n    }\n    __typename\n  }\n  __typename\n}\n\nfragment Pagination on SearchResults {\n  pagination {\n    currentPage\n    perPage\n    showPreviousPageLink\n    showNextPageLink\n    paginationLinks {\n      namedLinks {\n        previousPage {\n          rel\n          url\n          __typename\n        }\n        nextPage {\n          rel\n          url\n          __typename\n        }\n        __typename\n      }\n      __typename\n    }\n    fromNumber\n    toNumber\n    total\n    __typename\n  }\n  __typename\n}\n\nfragment LandingPage on SearchResults {\n  metadata {\n    formattedQuery\n    landingPage {\n      hero {\n        pitch\n        title\n        image\n        color\n        __typename\n      }\n      bubbles {\n        title\n        items {\n          title\n          image\n          realisticImage\n          url\n          isExternal\n          __typename\n        }\n        hasImages\n        __typename\n      }\n      seoMetadata {\n        pageDescription\n        robots\n        canonicalURL\n        searchTitle\n        seoImage\n        alternatePageVersions {\n          href\n          locale\n          __typename\n        }\n        relatedTagLinks {\n          title\n          href\n          text\n          __typename\n        }\n        faq {\n          title\n          items {\n            question\n            answer\n            __typename\n          }\n          __typename\n        }\n        __typename\n      }\n      footer {\n        text\n        readMoreText\n        breadcrumbs {\n          name\n          url\n          __typename\n        }\n        __typename\n      }\n      __typename\n    }\n    relatedTopics {\n      title\n      url\n      __typename\n    }\n    relatedProducts {\n      id\n      url\n      productTitle\n      fullTitle\n      __typename\n    }\n    searchPageType\n    resultCount\n    searchUUID\n    __typename\n  }\n  __typename\n}\n"
        }
    }

    buildSkuParams(designId, category) {
        return {
            "operationName": "withInventoryItems",
            "variables": {
                "locale": "en",
                "country": "US",
                "currency": "USD",
                "workId": parseInt(designId),
                "categoryId": category,
                "previewTypeIds": [
                    "product_close",
                    "alternate_product_close",
                    "artwork"
                ]
            },
            "query": "query withInventoryItems($workId: Int!, $previewTypeIds: [String!]!, $locale: String!, $country: String!, $currency: String!, $categoryId: String!) {\n  inventory_categorySet(workId: $workId, previewTypeIds: $previewTypeIds, locale: $locale, country: $country, currency: $currency, categoryId: $categoryId, unit: IN) {\n    ...Results\n    __typename\n  }\n}\n\nfragment Results on inventory_CategorySet {\n    items {\n        id\n        attributes {\n            name\n            value\n            attributes {\n                name\n                value\n                __typename\n            }\n        }\n        previewSet {\n            id\n            previews {\n                previewTypeId\n                url\n                __typename\n            }\n        }\n        __typename\n    }\n}\n"
        }
    }

    async crawlCategory() {
        let categorySlugs = Object.keys(this.getCategorySlugs());
        if (categorySlugs) {
            for (let slug of categorySlugs) {
                this.slugs[slug] = 1;
                this.pushToQueue({
                    type: 'category',
                    slug: slug,
                    categorySlug: slug,
                    depth: 1
                });
            }
        }
    }

    pushToQueue(queueData) {
        let self = this;
        let task = () => {
            return self.handleGetJsonCategory(queueData).catch(function (e) {
                console.log('err pushToQueue:', e);
                return Promise.resolve();
            });
        };
        this.handleCategoryQueue.pushTask(task);
    }

    validateItem(item) {
        let retVal = true;

        let slug = this.gaCodeToCategorySlug(item.inventoryItem.gaCode);
        if (!slug) {
            retVal = false;
        }

        return retVal;
    }

    async handleGetJsonCategory(queueData) {
        let page = 0;
        let maxPage = Config.maxPage;
        while(true) {
            let params = {}
            if (queueData.type == 'category') {
                params = this.buildCategoryParams(queueData, page);
            } else {
                params = this.buildTagParams(queueData, page);
            }
            let res = await this.getData(params);
            if (res && res.data && res.data.searchResults) {
                let results = res.data.searchResults.results;
                let items = [];
                for (let result of results) {
                    if (result.inventoryItem) {
                        if (!this.validateItem(result)) {
                            continue;
                        } else {
                            let item = this.buildItem(result);
                            // console.log(item);
                            items.push(item)
                        }
                    }
                }
                // console.log('items', items);
                await this.storeData(items);
                if (queueData.depth < this.maxDepth) {
                    for (let result of results) {
                        if (result.work && result.work.tags) {
                            for (let tag of result.work.tags) {
                                let tagSlug = tag.replace(' ', '+')
                                if (!this.slugs[tagSlug]) {
                                    this.slugs[tagSlug] = 1;
                                    this.pushToQueue({
                                        categorySlug: queueData.categorySlug,
                                        type: 'tag',
                                        query: tag,
                                        slug: tagSlug,
                                        depth: queueData.depth + 1
                                    }); 
                                    break;
                                }
                            }
                        }
                    }
                }
                let hasNext = res.data.searchResults.pagination.showNextPageLink;
                let currentPage = res.data.searchResults.pagination.currentPage;
                if (currentPage != page) {
                    break;
                }
                if (!hasNext) {
                    break;
                }
                if (page >= maxPage) {
                    break;
                }
            } else {
                console.log('error handleCategory', queueData.slug, page, res);
                if (page >= maxPage) {
                    break;
                }
            }
            page++;
            break;
        }
    }

    async sleep (miliSeconds) {
        return await new Promise((resolve) => {
            setTimeout(() => {
                resolve();
            }, miliSeconds);
        })
    }

    async storeData(items) {
        if (!items) {
            return;
        }
        for (let item of items) {
            // let attributes = await this.buildAttributes(item.design_id, item.category);
            //  console.log('attributes', attributes);
            // if (attributes) {
            //     item.attributes = attributes;
            // }
            let res = await Service.sendRequest(
                this.siteUrl + '/crawl-product/async-auto-crawl/crawl-redbubble',
                {
                    headers: {'Content-Type': 'application/json'},
                    params: {
                        method: 'POST',
                        body: JSON.stringify({
                            crawl_item: item,
                            brand_id: 1,
                            generate_variant: 1,
                            is_download_image: 0,
                            //is_overwrite_product: 1,
                        })
                    }
                }
            )
            await this.log(res, item);
        }
    }

    async log(response, item) {
        let productId = -1;
        let designId = item && item.design_id ? item.design_id : 0;
        if (response) {
            response = JSON.parse(response);
        }
        if (response && response.status == 'successful' && response.result &&  response.result.id) {
            productId = response.result.id;
        }
        await History.insertRedbubbleHistory({
            'product_id': productId,
            'design_id': designId,
        })
    }



    pushInsert(attributes) {
        // let task = () => {
        //     return crawlRedbubbleObj.InsertOrUpdate(itemData).catch(function (e) {
        //         console.log('err pushRedbbule:', itemData.design_id);
        //         return Promise.resolve();
        //     });
        // };

        let taskAttribute = () => {
            return crawlRedbubbleAttributeObj.InsertOrUpdate(attributes).catch(function (e) {
                console.log('err pushRedbbuleAttribute:', attributes[0].design_id, e);
                return Promise.resolve();
            });
        };
        // this.insertProductUrlQueue.pushTask(task);
        this.insertProductUrlQueue.pushTask(taskAttribute);
    }

    buildItem(data) {
        let inventoryItem = data.inventoryItem;

        return {
            category: this.gaCodeToCategorySlug(inventoryItem.gaCode),
            design_id: data.work.id,
            store: data.work.artistName,
            tags: JSON.stringify(data.work.tags),
            title: data.work.title,
            url: inventoryItem.productPageUrl,
            image_url: this.getImageUrl(inventoryItem.previewSet, data.defaultPreviewTypeId),
            design_url: this.getDesignUrl(this.getImageUrl(inventoryItem.previewSet, 'artwork'))
        }
    }

    async buildAttributes (workId, categorySlug) {
        let categoryId = this.getCategorySlugs()[categorySlug];
        let retVal = false;
        let params = this.buildSkuParams(workId, categoryId);
        let res = await this.getData(params);
        if (res && res.data && res.data.inventory_categorySet && res.data.inventory_categorySet.items) {
            retVal = [];
            let items = res.data.inventory_categorySet.items;
            for (let item of items) {
                retVal.push({
                    design_id: workId,
                    category: categorySlug,
                    attributes: JSON.stringify(item.attributes),
                    preview_set: JSON.stringify(item.previewSet)
                })
            }
        }

        return retVal;
    }

    getImageUrl (previewSet, previewTypeId) {
        let retVal = '';
        if (previewSet.previews && previewSet.previews.length) {
            for (let item of previewSet.previews) {
                if (item.previewTypeId == previewTypeId) {
                    retVal = item.url;
                    break;
                }
            }
        }

        return retVal;
    }

    getDesignUrl(imageUrl) {
        let retVal = '';
        if (imageUrl) {
            retVal = imageUrl.substring(0, imageUrl.lastIndexOf('/')) + '/--.u2.png';
        }

        return retVal;
    }

    async getData(params) {
        let res = await Service.sendRequestViaPuppeteer('https://www.redbubble.com/boom/graphql', params);
        return res ? res : {};
    }
    async getDataCurl(params) {
        let res = await Service.sendRequestRedbubble('https://www.redbubble.com/boom/graphql', params);
        return res ? res : {};
    }


}


module.exports = Redbubble;