const Utils = require(__dir + '/src/helper/utils');
const TaskQueue = require(__dir + '/src/helper/queue');
const Service = require(__dir + '/src/helper/service');
const CrawlProductSpreadShirt = require(__dir + '/src/models/crawl_product_spreadshirt');
const CrawlProductSpreadShirtObj = new CrawlProductSpreadShirt();
const SiteMap = require(__dir + '/src/parser/sitemap');
class SpreadShirt {
    constructor() {
        this.inserDesignUrlQueue = new TaskQueue(4, 'insert design url ', false);
        this.inserKeywordQueue = new TaskQueue(1, 'handle keyword ');
    }
    async spider() {
        //https://www.spreadshirt.de/sitemaps/t-shirts-sitemap.xml
        //https://www.spreadshirt.fr/sitemaps/t-shirts-sitemap.xml
        //https://www.spreadshirt.co.uk/sitemaps/t-shirts-sitemap.xml
        //https://www.spreadshirt.es/sitemaps/camisetas-sitemap.xml
        let urls = await SiteMap.getDataFromXML('https://www.spreadshirt.de/sitemaps/t-shirts-sitemap.xml');
        if (urls.length > 0) {
            for (let url of urls) {
                if (!url) {
                    continue;
                }
                url = Utils.buildUrl(url);
                let urlSplit = url.split('/');
                let keyword = urlSplit.pop();
                keyword = keyword.replace('-', ' ');
                let category =  urlSplit.pop();
                this.pushHandleKeyword(keyword, category);
            }
        }
    }

    pushHandleKeyword(keyword, category) {
        const self = this;
        let task = () => {
            return self.handleKeyWord(keyword, category).catch(function (e) {
                console.log('err pushHandleKeyword:' + link);
                return Promise.resolve();
            });
        };
        this.inserKeywordQueue.pushTask(task);
    }

    async handleKeyWord(keyword, category) {
        let limit = 500;
        let response = await this.getData(keyword, 0, limit);
        if (response && response.results) {
            this.handleDesigns(keyword, response.results, category)
            let total = response.total;
            let offset = limit;
            while (offset < total) {
                let nextResponse = await this.getData(keyword, offset, limit);
                offset += limit;
                if (nextResponse && nextResponse.results) {
                    this.handleDesigns(keyword, nextResponse.results)
                }
            }
        }
    }

    async getData(keyword, offset, limit) {
        let url = this.buildApiUrl(keyword, offset, limit);
        let response = await Service.sendRequest(url);
        if(response) {
            response = JSON.parse(response);
        }
        return response;
    }

    handleDesigns(keyword, items, category) {
        if (!items) {
          return;
        }
        for (let item of items) {
            if (!item || !item.designId) {
                continue;
            }
            try {
                this.handleDesign(keyword, item, category);
            } catch (e) {
                console.log('error on handleDesign ')
            }
        }

    }

    handleDesign(keyword, item, category) {
        let designId = item.designId;
        let name = item.name ? item.name : '';
        let url = this.buildImageUrl(designId);
        // let info = {
        //     f: item.isFree ? item.isFree : '',
        //     a: item.isAdultContent ? item.isAdultContent : '',
        //     b: item.backgroundColor ? item.backgroundColor : '',
        //     cc: item.colorCount ? item.colorCount : '',
        //     c: item.colors ? item.colors : '',
        //     cre: item.created ? item.created : '',
        //     cat: category
        // }
        this.pushInsertDesign({
            url: url,
            keyword: Utils.emoji(keyword),
            name: Utils.emoji(name),
            category: category,
            design_id: designId,
        });
    }



    pushInsertDesign(data) {
        let task = () => {
            return CrawlProductSpreadShirtObj.InsertOrUpdate(data).catch(function (e) {
                console.log('err pushInsertDesign:' + e);
                return Promise.resolve();
            });
        };
        this.inserDesignUrlQueue.pushTask(task);
    }

    buildApiUrl(keyword, offset = 0, limit = 500) {
        //let url = `https://designer.spreadshirt.com/search/omat/en_US/marketplace/designs?limit=${limit}&offset=${offset}&term=${keyword}&designType=ALL&safeSearch=ALL&imageType=ALL`;
        let url = `https://designer.spreadshirt.de/search/omat/de_DE/marketplace/designs?limit=${limit}&offset=${offset}&term=${keyword}&designType=ALL&safeSearch=ALL&imageType=ALL`;
        return url;
    }

    buildImageUrl(designId) {
        return `https://image.spreadshirtmedia.net/image-server/v1/designs/${designId},height=1200.png`
    }


}

module.exports = SpreadShirt;