const TaskQueue = require(__dir + '/src/helper/queue');
const Service = require(__dir + '/src/helper/service');
const CrawlProductData = require(__dir + '/src/models/crawl_product_data');
const CrawlProductDataObj = new CrawlProductData();
class TeepublicInsert {
    constructor() {
        this.insertQueue = new TaskQueue(10, 'insert product');
    }

    async handleProducts() {
        await this.sleep(3000);
        let ids = await CrawlProductDataObj.getPending();
        for (let id of ids) {
            let url = 'https://printerval.com/crawl-product/async-crawl-teepublic'
            url += '?craw_data_id=' +  id;
            url += '&force_status=PENDING';
            url += "&enable_style=152,153,154,155,12555";
           this.pushInsertQueue(url);
        }

    }
    async sleep(ms) {
        await new Promise((res) => {
            setTimeout(res, ms)
        });
    }

    pushInsertQueue(url) {
        const self = this;
        let task = () => {
            return self.curl(url).catch(function (e) {
                console.log('err request:' + url);
                return Promise.resolve();
            });
        };
        this.insertQueue.pushTask(task);
    }

    async curl(url) {
        await Service.sendRequest(url);
    }





}

module.exports = TeepublicInsert;