const TaskQueue = require(__dir + '/src/helper/queue');
const Service = require(__dir + '/src/helper/service');
const CrawlProductUrl= require(__dir + '/src/models/crawl_product_url');
const CrawlProductUrlObj = new CrawlProductUrl();
const Utils = require(__dir + '/src/helper/utils');
const TYPE_TSHIRT = 't-shirt';
const TYPE_TAG = 'tag';
class TeepublicRebuild {
    constructor() {
        this.insertQueue = new TaskQueue(10, 'insert product');
    }

    async rebuildTags() {

    }
    async rebuildType() {
        let IDFROM = 0;
        let IDMAX = 1074846;
        let PAGE = 1000;
        await this.sleep(3000);
        while (IDFROM < IDMAX) {
            let items = await CrawlProductUrlObj.getById(IDFROM, IDFROM + PAGE)
            IDFROM += PAGE;
            if (items) {
                for (let item of items) {
                    this.handleItem(item)
                }
            }
        }
    }

    handleItem(item) {
        if (Utils.isProductUrl(item.url)) {
            if (Utils.isTshirtUrl(item.url)) {
                item.type = TYPE_TSHIRT;
            } else if (this.getTypeUrl(item.url)) {
                item.type = this.getTypeUrl(item.url);
                this.copyToTshirt(item);
            }
        } else {

            item.type = TYPE_TAG
        }
        this.pushInsertQueue(item);
    }

    copyToTshirt(item) {
        let tshirtItem = {
            url: item.url.replace(this.getTypeUrl(item.url), TYPE_TSHIRT),
            type: TYPE_TSHIRT,
        }
        this.pushInsertQueue(tshirtItem);
    }

    getTypeUrl(url) {
        let urlSplit = url.split('/');
        if (urlSplit.length == 5) {
            return urlSplit[urlSplit.length  - 2]

        }
        return null;
    }



    async sleep(ms) {
        await new Promise((res) => {
            setTimeout(res, ms)
        });
    }

    pushInsertQueue(data) {
        let newItem = {
            url: data.url,
            type: data.type,
        }
        if (data.id) {
            newItem.id = data.id;
        }
        let task = () => {
            return CrawlProductUrlObj.InsertOrUpdate(newItem).catch(function (e) {
                console.log('err insert:');
                return Promise.resolve();
            });
        };
        this.insertQueue.pushTask(task);
    }





}

module.exports = TeepublicRebuild;