const Utils = require(__dir + '/src/helper/utils');
const Sitemap = require(__dir + '/src/parser/sitemap');
const TaskQueue = require(__dir + '/src/helper/queue');
const Service = require(__dir + '/src/helper/service');
const CrawlZazzle = require(__dir + '/src/models/crawl_zazzle');
const CrawlZazzleInfo = require(__dir + '/src/models/crawl_zazzle_info');
const Config = require(__dir + '/src/config/crawl')
const CrawlZazzleObj = new CrawlZazzle();
const CrawlZazzleInfoObj = new CrawlZazzleInfo();

class Zazzle {

    constructor() {
        this.handleCategoryQueue = new TaskQueue(1, 'spider zazzle category');
        this.insertProductUrlQueue = new TaskQueue(10, 'queue zazzle insert');
        this.category = null;
        this.siteUrl = Config.siteUrl;
    }

    categoryMap () {
        return {
            "hanes_mens_crew_darktshirt_5250": "t-shirts",
            "aa_mens_crew_tshirt_2001": "t-shirts",
            "hanes_womens_crew_tshirt_5680": "t-shirts",
            "bella_womens_vneck_tshirt_6005": "t-shirts",
            "hanes_womens_nano_vneck_s04v": "t-shirts",
            "hanes_mens_crew_tshirt_5250": "t-shirts",
            "portcompany_mens_crew_tshirt_pc54": "t-shirts",
            "gildan_mens_crew_tshirt_8600": "t-shirts",
            "ladies_fitted_tshirt": "t-shirts",
            "sporttek_mens_competitor_tshirt_st350": "t-shirts",
            "hanes_girls_crew_tshirt_5450": "t-shirts",
            "lat_girls_crew_tshirt_2616": "t-shirts",
            "lat_womens_pluscrew_tshirt_3804": "t-shirts",
            "hanes_boys_crew_tshirt_5450": "t-shirts",
            "hanes_boys_pullover_hoodie_p473": "t-shirts",
            "bella_mens_zipfull_hoodie_3739": "t-shirts",
            "hanes_girls_pullover_hoodie_p473": "t-shirts",
            "bella_womens_zipfull_hoodie_3739": "t-shirts",
            "truemade_mens_pullover_hoodie_z170": "t-shirts",
            "truemade_womens_pullover_hoodie_z170": "t-shirts",
            "bella_womens_racerback_ringspun_tank_8800": "t-shirts",
            "truemade_mens_crew_sweatshirt_z260": "t-shirts",
            "truemade_womens_crew_sweatshirt_z260": "t-shirts",
            "ladies_fitted_raglan": "t-shirts",
            "sunapp_mens_raglan_3_4_sleeve_20521": "t-shirts",
            "gildan_mens_value_sleeveless_g2700": "t-shirts",
            "hanes_mens_crew_longsleeve_5586": "t-shirts",
            "hanes_womens_crew_longsleeve_5586": "t-shirts"


            // "hanes_boys_pullover_hoodie_p473": "hoodies",
            // "bella_mens_zipfull_hoodie_3739": "hoodies",
            // "hanes_girls_pullover_hoodie_p473": "hoodies",
            // "bella_womens_zipfull_hoodie_3739": "hoodies",
            // "truemade_mens_pullover_hoodie_z170": "hoodies",
            // "truemade_womens_pullover_hoodie_z170": "hoodies",


            // "bella_womens_racerback_ringspun_tank_8800": "tank-tops",


            // "truemade_mens_crew_sweatshirt_z260": "sweatshirts",
            // "truemade_womens_crew_sweatshirt_z260": "sweatshirts",


            // "ladies_fitted_raglan": "longsleeves",
            // "sunapp_mens_raglan_3_4_sleeve_20521": "longsleeves",
            // "gildan_mens_value_sleeveless_g2700": "longsleeves",
            // "hanes_mens_crew_longsleeve_5586": "longsleeves",
            // "hanes_womens_crew_longsleeve_5586": "longsleeves"
        }
    }

    async crawlCategory() {
        for (let page = 1; page < 10; page++) {
            this.pushToQueue(page);
        }
    }

    pushToQueue(page) {
        let self = this;
        let task = () => {
            console.log('page', page);
            return self.crawlByPage(page).catch(function (e) {
                console.log('err pushToQueue:', e);
                return Promise.resolve();
            });
        };
        this.handleCategoryQueue.pushTask(task);
    }

    async crawlByPage(page) {
        let url = `https://www.zazzle.com/svc/z3/search/GetSearchWithProperties?cv=1&diffParameters=pg&diffProperties=ProductSearchTopIds&parameters=st=date_created%26qs=clothing%26pg=${page}%26dp=252448753675037147&properties=LightProductObjects%3Dtrue%26OriginalSearchTerm%3Dclothing%26Maturity%3DG%26IsPublic%3Dtrue%26ShowFullSearchPages%3Dfalse%26LookAheadPages%3D16%26LimitTypesInSearch%3Dtrue%26MaxStoresPerPage%3D6%26IsHumanSearch%3Dfalse%26UserDefaultPageSize%3D60%26GetAggregations%3Dtrue%26LegoStoreAggregation%3Dfalse%26LegoStoreCategoryAggregation%3Dfalse%26UseCYOSearch%3Dfalse%26IgnoreCYOManual%3Dfalse%26GetGuidedSearch%3Dtrue%26IsBestSellerSearch%3Dfalse%26SeekingAlphaSource%3DCuratedCollections%26SeekingAlphaUseSeparateTask%3Dfalse%26SeekingAlphaCollectionIds%3D119676194642161461%26SeekingAlphaDistribution%3DMixed%26SeekingAlphaDistributionAmountPg1%3D30%26SeekingAlphaDistributionAmountPg2%3D30%26SeekingAlphaDistributionAmountPg3%3D15&type=SearchResultsData&csrf=cbf15f9bb4ee6473&client=js`;
        let res = await this.getData(url);
        if (res && res.data && res.data.search && res.data.search.searchResultsData) {
            let items = res.data.search.searchResultsData.products;
            await this.handleItems(items);
        }
    }

    async handleItems(items) {
        if (!items) {
            return;
        }
        let storeItems = [];
        for (let id in items) {
            let item = items[id];
            if (item.productType == 'zazzle_shirt') {
                let zazzleItem = this.buildItem(item);
                if (zazzleItem.category) {
                    storeItems.push(zazzleItem)
                }
                // console.log('zazzleItem', zazzleItem);
                // this.pushInsert(zazzleItem, zazzleItemInfo);
                // break;
            }
        }
        console.log('storeItems', storeItems.length);
        await this.storeItems(storeItems)
    }

    async storeItems (items) {
        let res = await Service.sendRequest(
            this.siteUrl + '/service/pod/crawl-product-zazzle',
            {
                headers: {'Content-Type': 'application/json'}, 
                params: {
                    method: 'POST', 
                    body: JSON.stringify({
                        items: items
                    }),
                    timeout: 0
                }
            }
        )

        console.log('res', res);
    }

    buildItem(data) {
        let params = new URLSearchParams(data.attributes);
        let retval = {
            design_code: this.getColumn(data, 'designId'),
            name: this.getColumn(data, 'titleSeo'),
            type: this.getColumn(data, 'productType'),
            // product_id: this.getColumn(data, 'id'),
            // store_handle: this.getColumn(data, 'storeHandle'),
            // store_name: this.getColumn(data, 'storeName'),
            // store_id: this.getColumn(data, 'storeId'),
            // created_at:  new Date()
        }
        if (params.get('style')) {
            let style = params.get('style');
            if (this.categoryMap()[style]) {
                retval.category = this.categoryMap()[style]
            }
        }
        return retval
    }

    getColumn(data, column) {
        let result = data && data[column] ? data[column] : null;
        if (Array.isArray(result) || typeof result === 'object' ) {
            result = JSON.stringify(result);
        }
        return result;
    }

    async getData(url) {
        let res = await Service.sendRequest(url);
        return res ? JSON.parse(res) : {};
    }


}


module.exports = Zazzle;