const Utils = require(__dir + '/src/helper/utils');
const Sitemap = require(__dir + '/src/parser/sitemap');
const TaskQueue = require(__dir + '/src/helper/queue');
const Service = require(__dir + '/src/helper/service');
const CrawlZazzle = require(__dir + '/src/models/crawl_zazzle');
const CrawlZazzleInfo = require(__dir + '/src/models/crawl_zazzle_info');
const CrawlZazzleObj = new CrawlZazzle();
const CrawlZazzleInfoObj = new CrawlZazzleInfo();
const Keywords = require(__dir + '/src/models/keywords');
const History = require(__dir + '/src/models/history');

class Zazzle {

    constructor() {
        this.handleStoreQueue = new TaskQueue(10, 'spider store');
        this.insertProductUrlQueue = new TaskQueue(30, 'queue zazzle insert');
        this.category = null;
        this.language = 'us';
    }

    async crawlStore() {
        let stores = await this.getAllStore(__dir + '/source/sitemap_designstores_pt.xml');
        this.language = 'pt';
        let storeExists = await  CrawlZazzleObj.getAllSlug();
        if (stores) {
            for (let store of stores) {
                let storeSplit = store.split('/store/');
                let slug = storeSplit[1];
                if (storeExists.has(slug)) {
                    console.log('store is exists', slug);
                    continue;
                }
                storeExists.add(slug);
                this.pushToQueue(slug);
            }
        }
    }

    async replaceDuplicate() {
        console.log('replaceDuplicate');
        let from = 1;
        let to = 65514916;
        let page = 5000;
        let productIds = new Set();
        let productIds2 = new Set();
        let deleteIds = [];
        for (let i = from; i < to; i += 5000) {
            console.log(i, i + page);
            let items = await  CrawlZazzleObj.getProductId(i, i + page);
            if (items.length > 0) {
                for (let item of items) {
                    if (productIds.has(item.product_id) || productIds2.has(item.product_id)) {
                        deleteIds.push(item.id);
                    } else {
                        if (i > 15000000) {
                            productIds2.add(item.product_id);
                        } else {
                            productIds.add(item.product_id);
                        }

                    }
                }

                if (deleteIds.length > 0) {
                    this.pushDelete(deleteIds);
                    deleteIds = [];
                }
            }


        }
    }

    pushToQueue(slug) {
        let self = this;
        let task = () => {
            return self.handleStore(slug).catch(function (e) {
                console.log('err pushToQueue:', slug);
                return Promise.resolve();
            });
        };
        this.handleStoreQueue.pushTask(task);
    }

    async getAllStore(path) {
        return await Sitemap.parseXMLFile(path)
    }

    async handleStore(slug) {
        let maxPageId = 17;
        for (let pageId = 1; pageId <= 17; pageId++) {
            if (pageId > maxPageId) {
                break;
            }
            //let url = `https://www.zazzle.com/svc/z3/storeproductssearch/GetMarketplaceSearchFromParams?cv=1&parameters=ch%3D${slug}%26pg%3D${pageId}&csrf=e1c413f809c7d50e&client=js`;
            //let url = `https://www.zazzle.com/svc/z3/storeproductssearch/GetMarketplaceSearchFromParams?cv=1&parameters=ch%3D${slug}%26dp%3D252448753675037147%26pg%3D${pageId}&csrf=4e8a93fc9b88729e&client=js`;
            //let url = `https://www.zazzle.com/svc/z3/storeproductssearch/GetMarketplaceSearchFromParams?cv=1&parameters=ch%3D${slug}%26dp%3D252448753675037147%26pg%3D${pageId}&client=js`;
            let url = `https://www.zazzle.com/svc/z3/storeproductssearch/GetMarketplaceSearchFromParams?cv=1&parameters=ch%3D${slug}%26pg%3D${pageId}&client=js`;
            //let url =   `https://www.zazzle.com/svc/z3/storeproductssearch/GetMarketplaceSearchFromParams?cv=1&parameters=st%3Ddate_created%26ch%3D${slug}%26sd%3Ddesc%26pg%3D${pageId}&client=js`;

            let res = await this.getData(url);
            if (res && res.data && res.data.searchResultsData) {
                maxPageId = res.data.searchResultsData.lastPageNum;
                console.log(maxPageId, url);
                if (maxPageId > 0) {
                    let items = res.data.entities.productSearchInfos;
                    this.handleStores(items, slug);
                }
            }
        }
    }

    handleStores(items, slug) {
        if (!items) {
            return;
        }
        let zazzleItems = [];
        let zazzleItemsInfo = [];
        for (let id in items) {
            let item = items[id];
            let zazzleItem = this.buildItem(item, slug);
            zazzleItems.push(zazzleItem);
            //let zazzleItemInfo = this.buildItemInfo(item);
            //zazzleItemsInfo.push(zazzleItemInfo);
            //this.pushInsert(zazzleItem, zazzleItemInfo);
        }
        this.pushMultiInsert(zazzleItems, zazzleItemsInfo);
    }


    pushMultiInsert(zazzleItems, zazzleItemsInfo) {
        let task = () => {
            return CrawlZazzleObj.MultiInsert(zazzleItems).catch(function (e) {
                console.log('err ZazzleObj:', e);
                return Promise.resolve();
            });
        };
        // let taskInfo = () => {
        //     return CrawlZazzleInfoObj.MultiInsert(zazzleItemsInfo).catch(function (e) {
        //         console.log('err ZazzleInfoObj Info:');
        //         return Promise.resolve();
        //     });
        // };
        this.insertProductUrlQueue.pushTask(task);
        // this.insertProductUrlQueue.pushTask(taskInfo);
    }


    pushDelete(ids) {
        let task = () => {
            return CrawlZazzleObj.TickDelete(ids).catch(function (e) {
                console.log('err ZazzleObj TickDelete:');
                return Promise.resolve();
            });
        };
        this.insertProductUrlQueue.pushTask(task);
    }


    pushInsert(zazzleItem, zazzleItemInfo) {
        let task = () => {
            return CrawlZazzleObj.InsertOrUpdate(zazzleItem).catch(function (e) {
                console.log('err pushZazzle:', zazzleItem.design_id);
                return Promise.resolve();
            });
        };
        let taskInfo = () => {
            return CrawlZazzleInfoObj.InsertOrUpdate(zazzleItemInfo).catch(function (e) {
                console.log('err pushZazzle Info:' , zazzleItem.design_id);
                return Promise.resolve();
            });
        };
        this.insertProductUrlQueue.pushTask(task);
        this.insertProductUrlQueue.pushTask(taskInfo);
    }



    buildItem(data, slug = null) {
        return {
            design_id: this.getColumn(data, 'designId'),
            product_title: this.getColumn(data, 'titleSeo'),
            produc_type: this.getColumn(data, 'productType'),
            product_id: this.getColumn(data, 'id'),
            store_handle: this.getColumn(data, 'storeHandle'),
            store_name: this.getColumn(data, 'storeName'),
            store_id: this.getColumn(data, 'storeId'),
            store_slug: slug ? slug : this.getColumn(data, 'storeName'),
            created_at:  new Date(),
            language: this.language
        }
    }

     slugify(str) {
        if (!str) {
            return;
        }
        return String(str)
            .normalize('NFKD') // split accented characters into their base characters and diacritical marks
            .replace(/[\u0300-\u036f]/g, '') // remove all the accents, which happen to be all in the \u03xx UNICODE block.
            .trim() // trim leading or trailing whitespace
            .toLowerCase() // convert to lowercase
            .replace(/[^a-z0-9 -]/g, '') // remove non-alphanumeric characters
            .replace(/\s+/g, '-') // replace spaces with hyphens
            .replace(/-+/g, '-'); // remove consecutive hyphens
    }

    buildItemInfo(data) {
        return {
            design_id: this.getColumn(data, 'designId'),
            product_id: this.getColumn(data, 'id'),
            data: JSON.stringify(data)
        }
    }

    getColumn(data, column) {
        let result = data && data[column] ? data[column] : null;
        if (Array.isArray(result) || typeof result === 'object' ) {
            result = JSON.stringify(result);
        }
        return result;
    }

    async getData(url) {
        let res = await Service.sendRequest(url);
        return res ? JSON.parse(res) : {};
    }

    async crawlByKeywords() {
        let keywords = await Keywords.get();
        let history = await History.history()
        for (let keywordItem of keywords) {
            if (history.has(this.buildLogUrl(keywordItem.keyword))) {
                console.log('exists ', keywordItem.keyword);
                continue;
            }

            this.pushToQueueHandleKeyword(keywordItem.keyword);
        }
    }

    pushToQueueHandleKeyword(keyword) {
        let self = this;
        let task = () => {
            return self.handleKeyword(keyword).catch(function (e) {
                console.log('err pushToQueue:', keyword);
                return Promise.resolve();
            });
        };
        this.handleStoreQueue.pushTask(task);
    }

    async handleKeyword(keyword) {
        History.insert({
            url: this.buildLogUrl(keyword)
        });
        let maxPageId = 17;
        for (let pageId = 1; pageId <= 15; pageId++) {
            if (pageId > maxPageId) {
                break;
            }
            let url = this.getSearchUrl(keyword, pageId);
            let res = await this.getData(url);
            if (res && res.data
                && res.data.search
                && res.data.search.searchResultsData) {
                maxPageId = res.data.search.searchResultsData.lastPageNum;
                if (maxPageId > 0) {
                    let items = res.data.search.searchResultsData.products;
                    this.handleStores(items);
                }
            }
        }
    }

    buildLogUrl(keyword) {
        return 'https://www.zazzle.com/' + keyword;
    }

    getSearchUrl(keyword, page) {
        keyword = encodeURIComponent(keyword);
        return 'https://www.zazzle.com/svc/z3/search/GetSearchWithProperties?cv=1&diffParameters=pg&diffProperties=ProductSearchTopIds&parameters=qs%3D'
            + keyword + '%26pg%3D' + page + '%26dp%3D252735970482259074%26q%3D'
            + keyword + '%26sgsc%3D' + keyword
            + '%26HumanSearch%3DTrue&properties=LightProductObjects%3Dtrue%26OriginalSearchTerm%3D'
            + keyword + '%26Maturity%3DG%26IsPublic%3Dtrue%26ShowFullSearchPages%3Dfalse%26LookAheadPages%3D16%26LimitTypesInSearch%3Dtrue%26MaxStoresPerPage%3D6%26IsHumanSearch%3Dtrue%26UserDefaultPageSize%3D60%26GetAggregations%3Dtrue%26LegoStoreAggregation%3Dfalse%26LegoStoreCategoryAggregation%3Dfalse%26UseCYOSearch%3Dfalse%26IgnoreCYOManual%3Dfalse%26GetGuidedSearch%3Dtrue%26IsBestSellerSearch%3Dfalse%26ExcludedKeywords%3Dinvitation%252Ccard&type=SearchResultsData&csrf=b4e4347a137ff10b&client=js'
    }




}


module.exports = Zazzle;