<?php

namespace Modules\Dashboard\Controllers\Report;

use Modules\Dashboard\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class CustomerReportController extends Controller {

    public $customerReturning = [];
    
    public function buildCustomerReturning($orders, $reportDate)
    {
        $countOrder = count($orders);
        $customerIds = [];
        for ($i = 0; $i < $countOrder; $i++) {
            $customerIds[] = $orders[$i]->customer_id;
        }

        $customers = DB::connection('mysql_customer')->table('customer')
            ->whereIn('id', $customerIds)
            ->select(['id', 'created_at'])
            ->get();

        foreach ($customers as &$value) {
            if ($value->created_at < $reportDate) {
                $value->is_returning = true;
                $this->customerReturning[] = $value->id; 
            }
        }

        $this->customerReturning = array_unique($this->customerReturning);
        
        return $customers;
    }

    public function getRegistedCustomerData()
    {
        $customers = DB::connection('mysql_customer')->table('customer')
            ->whereNotNull('api_token')
            ->select(['id', 'created_at'])
            ->get();
        
        $dataGroup = [];

        foreach ($customers as $customer) 
        {
            $dateKey = substr($customer->created_at, 0, 10);
            if (!isset($dataGroup[$dateKey])) $dataGroup[$dateKey] = 0;

            $dataGroup[$dateKey] ++;
        }

        return $dataGroup;
    }

    public function mapOrderCustomer($orders)
    {
        foreach ($orders as &$value) {
            $value->is_returning = false;
            if (in_array($value->customer_id, $this->customerReturning)) {
                $value->is_returning = true;
            }
        }
        return $orders;
    }

}