<?php

namespace Modules\Dashboard\Controllers\Report;

use Cache;
use Illuminate\Http\Request;
use Modules\Dashboard\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Dashboard\Models\Log;

class ReportByConversionController extends Controller {
    public function getOrderByConversion(Request $request)
    {
        $response = [
            'status' => 'fail'
        ];

        if (!$request->has('dateFrom') || !$request->has('dateTo')) return $response;

        $response['status'] = 'successful';

        $locate = $request->input('locale', 'us');

        if (class_exists(`\App\Helpers\DBConnect`)) {
            $connection = \App\Helpers\DBConnect::connect($locate);
        } else {
            $connection = DB::connection();
        }

        $dateFrom = date('Y-m-d 00:00:00', $request->input('dateFrom'));
        $dateTo = date('Y-m-d 23:59:59', $request->input('dateTo'));

        $period = new \DatePeriod(
            new \DateTime($dateFrom),
            new \DateInterval('P1D'),
            new \DateTime($dateTo)
        );
        $sumAmountOrderByDate = $connection->table('order')
            ->select(DB::raw("DATE_FORMAT(sb_order.created_at, '%Y-%m-%d') as date"), DB::raw('sum(amount) as sum'))
            ->where('order.payment_status', 'PAID')
            ->where('order.created_at', '>=', $dateFrom)
            ->where('order.created_at', '<=', $dateTo)
            ->whereNotIn('order.customer_id', config('dashboard::report-order.ignore_customers', [5031, 14529, 366023]))
            ->groupBy('date')
            ->get()
            ->keyBy('date');
        $orderCountByDate = $connection->table('order')
            ->select(DB::raw("DATE_FORMAT(sb_order.created_at, '%Y-%m-%d') as date"), DB::raw('count(*) as count'), DB::raw('sum(amount) as sum'))
            ->leftJoin('order_meta as om', function($leftJoin)
            {
                $leftJoin->on('om.order_id', '=', 'order.id')
                    ->where('om.key', '=', 'remake_origin_code' );
            })
            ->where('order.payment_status', 'PAID')
            ->where('order.created_at', '>=', $dateFrom)
            ->where('order.created_at', '<=', $dateTo)
            ->whereNull('om.value')
            ->whereNotIn('order.customer_id', config('dashboard::report-order.ignore_customers', [5031, 14529, 366023]))
            ->whereNull('order.parent_id')
            ->groupBy('date')
            ->get()
            ->keyBy('date');

        $cartCountByDate = $connection->table('cart')
            ->select(DB::raw("DATE_FORMAT(sb_cart.created_at, '%Y-%m-%d') as date"), DB::raw('count(*) as count'))
            ->where('created_at', '>=', $dateFrom)
            ->where('created_at', '<=', $dateTo)
            ->where(function ($query) {
                $query->whereNull('customer_id')
                    ->orWhereNotIn('customer_id', config('dashboard::report-order.ignore_customers', [5031, 14529, 366023]));
            })
            ->groupBy('date')
            ->get()
            ->keyBy('date');
        $viewCountByDate = [];
        $today = new \DateTime(date('Y-m-d 00:00:00', time()));
        foreach ($period as $value) {
            $date = $value->format('Y-m-d');
            $cacheKey = 'OrderByConversion::product_view_' . $locate . '_V3_' . $date;
            if ($value < $today && Cache::has($cacheKey)) {
                $viewCountByDate[$date] = Cache::get($cacheKey);
            } else {
                $viewCountByDate[$date] = $connection->table('user_viewed')
                    ->select(DB::raw("distinct imei, target"))
                    ->where('type', 'product')
                    ->where('created_at', '>=', $value->format('Y-m-d 00:00:00'))
                    ->where('created_at', '<=', $value->format('Y-m-d 23:59:59'))
                    ->count();
                if ($viewCountByDate[$date]) {
                    Cache::put($cacheKey, $viewCountByDate[$date], 15 * 86400);
                }
            }
        }

        $groupDates = [
            'order_cart' => [],
            'order_view' => [],
            'amount_avg' => [],
        ];


        $xAxis = [];
        foreach ($period as $value) {
            $date = $value->format('Y-m-d');
            $xAxis[] = $date;
            if (isset($orderCountByDate[$date]) && isset($cartCountByDate[$date]) && $cartCountByDate[$date]->count) {
                $groupDates['order_cart'][$date] = round($orderCountByDate[$date]->count * 100 / $cartCountByDate[$date]->count, 2, PHP_ROUND_HALF_UP);
                $groupDates['cart'][$date] = $cartCountByDate[$date]->count;
            } else {
                $groupDates['cart'][$date] = 0;
                $groupDates['order_cart'][$date] = 0;
            }

            if (isset($orderCountByDate[$date]) && isset($viewCountByDate[$date]) && $viewCountByDate[$date]) {
                $groupDates['order_view'][$date] = round($orderCountByDate[$date]->count * 100 / $viewCountByDate[$date], 2, PHP_ROUND_HALF_UP);
            } else {
                $groupDates['order_view'][$date] = 0;
            }

            if (isset($orderCountByDate[$date]) && $orderCountByDate[$date]->count) {
                $groupDates['amount_avg'][$date] = round($sumAmountOrderByDate[$date]->sum / $orderCountByDate[$date]->count, 2, PHP_ROUND_HALF_UP);
            } else {
                $groupDates['amount_avg'][$date] = 0;
            }
        }

        $response['group_by_date'] = $groupDates;
        $response['xAxis'] = $xAxis;

        return $response;

    }
}