<?php

namespace Modules\Dashboard\Controllers\Report;

use Illuminate\Http\Request;
use Modules\Dashboard\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Dashboard\Models\Log;

class ReportErrorController extends Controller {
    public function reportErrorDaily(Request $request) {
        $response = [
            'status' => 'fail'
        ];

        $response['status'] = 'successful';
        $locate = $request->input('locale', 'us');
        if (class_exists(`\App\Helpers\DBConnect`)) {
            $connection = \App\Helpers\DBConnect::connect($locate);
        } else {
            $connection = DB::connection();
        }

        $dateFrom = date('Y-m-d 00:00:00', time());
        $dateTo = date('Y-m-d 23:59:59', time());

        $errors = $connection->table('error_log')
            ->where('created_at', '>=', $dateFrom)
            ->where('created_at', '<=', $dateTo)
            ->get();
        $errorGroupByUrl = [];

        foreach ($errors as $error) {
            $url = $error->url;
            if (strpos($url, '?') !== false) {
                $url = substr($url, strpos($url, '?'));
            }
            if (preg_match("/\/([^\/\[\]])+-p\d+$/", $url)) {
                $parseUrl = parse_url($url);
                if (isset($parseUrl['path']) && strpos($parseUrl['path'], '/') === 0) {
                    $url = preg_replace("/\/([^\/\[\]])+-p\d+$/", "/$1-p[id]", $url);
                }
            }
            if (preg_match("/\/(\d+)(\/|$)/", $url)) {
                $url = preg_replace("/\/(\d+)(\/|$)/", "/[id]$2", $url);
            } else if (preg_match("/\/([a-zA-z\-]+)(\d+)(\.|$)/", $url)) {
                $url = preg_replace("/\/([a-zA-z\-]+)(\d+)(\.|$)/", "/$1[id]$3", $url);
            }
            if (preg_match("/\/[^\/\[\]]+-p\[id\]$/", $url)) {
                $url = preg_replace("/\/[^\/\[\]]+-p\[id\]$/", "/slug-p[id]", $url);
            }
            $key = $url;
            $keyM = md5(($error->message));
            if (!isset($errorGroupByUrl[$key])) {
                $errorGroupByUrl[$key] = [
                    'url' => $url,
                    'count' => 0,
                    'messages' => []
                ];
 
            }
            if (!isset($errorGroupByUrl[$key]['messages'][$keyM])) {
                $errorGroupByUrl[$key]['messages'][$keyM] = [
                    'message' => $error->message,
                    'count' => 0,
                    'latest_occur' => $error->created_at,
                ];
            }
            $errorGroupByUrl[$key]['count']++;
            $errorGroupByUrl[$key]['messages'][$keyM]['count']++;
            $date = date_create_from_format("Y-m-d H:i:s", $error->created_at);
            if ($date > date_create_from_format("Y-m-d H:i:s", $errorGroupByUrl[$key]['messages'][$keyM]['latest_occur'])) {
                $errorGroupByUrl[$key]['messages'][$keyM]['latest_occur'] = $error->created_at;
            }
        }

        usort($errorGroupByUrl, function ($a, $b) {
            return $a['count'] < $b['count'];
        });

        foreach ($errorGroupByUrl as $key => &$value) {
            usort($value['messages'], function ($a, $b) {
                $dateA = date_create_from_format("Y-m-d H:i:s", $a['latest_occur']);
                $dateB = date_create_from_format("Y-m-d H:i:s", $b['latest_occur']);

                return $dateA < $dateB;
            });
        }

        return [
            'status' => 'successful',
            'result' => array_slice($errorGroupByUrl, 0, 100)
        ];
    }
}