<?php

namespace Modules\Dashboard\Controllers\Report;

use Illuminate\Http\Request;
use Modules\Dashboard\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class ReportProductController extends Controller {
    public function productCountBySource(Request $request) {
        $response = [
            'status' => 'successful',
            'result' => []
        ];
        $fromTime = date('Y-m-d 00:00:00', time());
        $toTime = date('Y-m-d 23:59:59', time());
        if ($request->get('from_time')) {
            $fromTime = $request->get('from_time') . ' 00:00:00';
        }
        if ($request->get('to_time')) {
            $toTime = $request->get('to_time') . ' 23:59:59';
        }

        $response['result'] = DB::table('product_crawl_code')
            ->where('created_at', '>=', $fromTime)
            ->where('created_at', '<=', $toTime)
            ->groupBy('site')
            ->get(['site', DB::raw('count(*) as count')]);

        return $response;
    }
}