<?php

namespace Modules\Dashboard\Controllers\Report;

use Cache;
use DateTime;
use Illuminate\Http\Request;
use Modules\Dashboard\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class ReportProductSaleChangeController extends Controller {
    public function index() {
        return view('dashboard::report.product-sale-change');
    }

    public function report(Request $request) {
        set_time_limit(1800);
        
        $response = [
            'status' => 'fail'
        ];

        if (!$request->has('date_from') || !$request->has('date_to') || !$request->has('last_period_date_from') || !$request->has('last_period_date_to')) return $response;

        $dateFrom = DateTime::createFromFormat('d/m/Y', $request->input('date_from'));
        $dateTo = DateTime::createFromFormat('d/m/Y', $request->input('date_to'));
        $productSales = DB::table('order')
            ->join('order_item', 'order_item.order_id', '=', 'order.id')
            ->select(DB::raw('product_id, sum(quantity) as total_sale'))
            ->where('order.created_at', '>=', $dateFrom)
            ->where('order.created_at', '<=', $dateTo)
            ->where('order.payment_status', 'PAID')
            ->groupBy('product_id')
            ->having('total_sale', '>=', 5)
            ->get()
            ->pluck('total_sale', 'product_id');

        $lastPeriodDateFrom = DateTime::createFromFormat('d/m/Y', $request->input('last_period_date_from'));
        $lastPeriodDateTo = DateTime::createFromFormat('d/m/Y', $request->input('last_period_date_to'));
        
        $lastPeriodProductSales = DB::table('order')
            ->join('order_item', 'order_item.order_id', '=', 'order.id')
            ->select(DB::raw('product_id, sum(quantity) as total_sale'))
            ->where('order.created_at', '>=', $lastPeriodDateFrom)
            ->where('order.created_at', '<=', $lastPeriodDateTo)
            ->where('order.payment_status', 'PAID')
            ->groupBy('product_id')
            ->having('total_sale', '>=', 5)
            ->get()
            ->pluck('total_sale', 'product_id');
        $reportItems = [];
        $reportProductIds = [];
        foreach ($productSales as $productId => $sale) {
            $item = [
                'product_id' => $productId,
                'sale' => $sale,
                'last_period_sale' => 0,
                'sort_rank' => 1
            ];
            if (!isset($lastPeriodProductSales[$productId])) {
                $reportItems[] = $item;
                $reportProductIds[] = $productId;
            } else {
                $item['last_period_sale'] = $lastPeriodProductSales[$productId];
                $percent = ($sale - $lastPeriodProductSales[$productId]) / $lastPeriodProductSales[$productId] * 100;
                $item['percent'] = round($percent, 1, PHP_ROUND_HALF_UP);
                $item['sort_rank'] = abs($item['percent']);
                if (abs($percent) >= 15) {
                    $reportItems[] = $item;
                    $reportProductIds[] = $productId;
                } 
            }
        }

        foreach ($lastPeriodProductSales as $productId => $sale) {
            $item = [
                'product_id' => $productId,
                'sale' => 0,
                'last_period_sale' => $sale,
                'sort_rank' => 2
            ];
            if (!isset($productSales[$productId])) {
                $reportItems[] = $item;
                $reportProductIds[] = $productId;
            }
        }
        $products = DB::table('product')
            ->whereIn('id', $reportProductIds)
            ->get(['id', 'name', 'slug', 'image_url'])
            ->keyBy('id');
        foreach ($reportItems as &$item) {
            if (isset($products[$item['product_id']])) {
                $item['name'] = $products[$item['product_id']]->name;
                $item['slug'] = $products[$item['product_id']]->slug;
                $item['image_url'] = $products[$item['product_id']]->image_url;
            }
        }

        usort($reportItems, function ($a, $b) {
            return $a['sort_rank'] < $b['sort_rank'];
        });

        return [
            'status' => 'successful',
            'result' => $reportItems
        ];
    }

}