<?php

namespace Modules\Dashboard\Controllers\ReportEvent;
use Illuminate\Support\Facades\DB;

trait EventReportTrait 
{
    protected function getSeparateOrderIds($dateFrom, $dateTo) {
        $retVal = [-1];
        $separates = DB::table('order')
            ->where('order.payment_status', '=', 'PAID')
            ->whereBetween('order.created_at', [$dateFrom, $dateTo])
            ->join('order_meta', function ($join) {
                $join->on( 'order.id', '=', 'order_meta.order_id')->where('order_meta.key', '=', 'separate_origin_code');
            })
            ->select('order.id')
            ->get();
            
        foreach ($separates as $order) {
            array_push($retVal, $order->id);
        }  
        return $retVal;
    }

    public function getEventOrderIds($dateFrom, $dateTo, $eventId = null) {
        $retVal = [-1];
        $query = DB::table('order_item')
            ->whereBetween('order_item.created_at', [$dateFrom, $dateTo])
            ->join('season_event_n_product', 'season_event_n_product.product_id', 'order_item.product_id');

            if ($eventId) {
                $query = $query->where('season_event_n_product.season_event_id', $eventId);
            }

            $eventOrders = $query->select('order_item.order_id')->get();

        foreach ($eventOrders as $item) {
            array_push($retVal, $item->order_id);
        }
        return $retVal;
    }

    protected function getLocaleCurrencyRatio() 
    {
        $currencyRatio = 1;
        if (function_exists('getModuleLocale')) {
            $locales = getModuleLocale();
            $locale = current(array_filter($locales, function($config) {
                return $config['locale'] == strtolower(env('APP_LOCALE'));
            }));
            if (!empty($locale['currencyRatio'])) {
                $currencyRatio = $locale['currencyRatio'];
            }
        }

        return $currencyRatio;
    }
}