<?php

namespace Modules\Dashboard\Controllers\ReportFulfillment;

use Illuminate\Http\Request;
use DB;
use Modules\Dashboard\Controllers\Controller;

class ReportOrderProblemController extends Controller
{
    public function index(Request $request)
    {
        $retVal = ['status' => 'error'];

        if ($request->has('dateFrom') && $request->has('dateTo')) 
        {
            $dateFrom = date('Y-m-d 00:00:00', $request->input('dateFrom'));
            $dateTo = date('Y-m-d 23:59:59', $request->input('dateTo'));
            $retVal = ['status' => 'successful', 'data' => []];

            $period = new \DatePeriod(
                new \DateTime($dateFrom),
                new \DateInterval('P1D'),
                new \DateTime($dateTo)
            );

            $xAxis = [];
            foreach ($period as $value) {
                $xAxis[] = $value->format('Y-m-d');
            }

            $retVal['xAxis'] = $xAxis;

            $reportData = DB::table('order_problem')
                ->whereBetween('created_at', [$dateFrom, $dateTo])
                ->get();


            $reportErrorTypes = [];
            for ($i = 0; $i < count($reportData); $i++) {
                $errorType = $reportData[$i]->type_error;
                if (!in_array($errorType, $reportErrorTypes)) {
                    $reportErrorTypes[] = $errorType;
                }
            }

            $group = [];
            $groupPie = [];

            for ($i = 0; $i < count($reportErrorTypes); $i++) { 
                $group[$reportErrorTypes[$i]] = [];
                $groupPie[$reportErrorTypes[$i]] = 0;

                foreach ($period as $value) {
                    $dateValue = $value->format('Y-m-d');
                    $group[$reportErrorTypes[$i]][$dateValue] = 0;
                }
            }

            foreach ($reportData as $row) 
            {
                $dateKey = substr($row->created_at, 0, 10);
                $group[$row->type_error][$dateKey] ++;
                $groupPie[$row->type_error] ++;
            }

            $retVal['yAxis'] = $group;
            $retVal['pieData'] = $groupPie;
        }
        $today = new \Datetime();
        $orderProblem = DB::table('order_problem')
            ->join("order", function($q) {
                $q->on("order.id", "=", "order_problem.order_id");
                $q->on("order.status", "=", "order_problem.order_status");
            })
            ->whereBetween('order_problem.created_at', [$dateFrom, $dateTo])
            ->groupBy('type_error')
            ->pluck(DB::raw('count(*) as total'), 'type_error');
        $orderDelayFF = DB::table('order_problem')
            ->join("order", function($q) {
                $q->on("order.id", "=", "order_problem.order_id");
                $q->on("order.status", "=", "order_problem.order_status");
            })
            ->join("order_meta", function($q) {
                $q->on("order_meta.order_id", "=", "order_problem.order_id");
                $q->where("order_meta.key", "=", "ticket_has_order");
            })
            ->whereBetween('order_problem.created_at', [$dateFrom, $dateTo])
            ->where('type_error', 'fulfill')
            ->count();
        $orderDelay = DB::table('order_problem')
            ->join("order", function($q) {
                $q->on("order.id", "=", "order_problem.order_id");
                $q->on("order.status", "=", "order_problem.order_status");
            })
            ->join("order_meta", function($q) {
                $q->on("order_meta.order_id", "=", "order_problem.order_id");
                $q->where("order_meta.key", "=", "ticket_has_order");
            })
            ->whereBetween('order_problem.created_at', [$dateFrom, $dateTo])
            ->where('type_error', 'delay')
            ->count();
        $orderProblem["fulfill_has_ticket"] = $orderDelayFF;
        $orderProblem["delay_has_ticket"] = $orderDelay;
        $retVal['pieData'] = $orderProblem;
        return response()->json($retVal, 200, [], JSON_NUMERIC_CHECK);
    }

}