
function googleBotRequest($scope, $rootScope, $http, $timeout) {
    $scope.chartConfig = {};
    $scope.trafficReport = {};
    $scope.dateReports = [
        {code: '-7 days', name: "Previous 7 days"},
        {code: '-14 days', name: "Previous 14 days"},
        {code: '-30 days', name: "Previous 30 days"},
    ];
    $scope.fetchBotRequest = () => {
        if (!$scope.trafficReport.date) {
            $scope.trafficReport.date = $scope.dateReports[0].code;
        }
        var filter = {
            date: $scope.trafficReport.date
        };
        $http.get('/dashboard/get-google-bot-request', {params: filter})
            .then(res => {
                const response = res.data;
                if (response.status === 'successful') {
                    let startDate = response.data.date[0];
                    startDate = new Date(startDate);
                    chartInit(startDate, response.data.date, response.data.total);
                }
            })
    }

    const chartInit = (startDate, date, total) => {
        Highcharts.chart('chart-google-bot-request', {
            chart: {
                type: 'area'
            },
            accessibility: {
                description: ''
            },
            title: {
                text: 'Google bot requests'
            },
            subtitle: {
                text: 'Source: <a href="https://cloudflare.com/" ' +
                    'target="_blank">cloudflare.com</a>'
            },
            xAxis: {
                type: 'datetime'
                // allowDecimals: false,
                // accessibility: {
                //     rangeDescription: 'Range: 1940 to 2017.'
                // }
            },
            yAxis: {
                title: {
                    text: 'Requests'
                }
            },
            tooltip: {
                pointFormatter: function() {
                    const requested = Math.floor(this.y);
                    return `<span style="color:${this.series.color}">${this.series.name}</span>: <b>${numberWithCommas(requested)}</b> requests<br/>`
                },
            },
            plotOptions: {
                series: {
                    // pointStart: new Date(date[0]),
                    pointStart: Date.UTC(startDate.getFullYear(), startDate.getMonth(), startDate.getDate()),
                    pointInterval: 24 * 3600 * 1000,
                },
            },
            series: [{
                name: 'Google bot',
                data: total
            }]
        });

    }

    const numberWithCommas = (x) => {
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }
}
