Number.prototype.round = function(places) {
    return +(Math.round(this + "e+" + places)  + "e-" + places);
}

system.controller("DashboardController", function ($scope, $rootScope, $http, $timeout) {

    this.__proto__ = new googleBotRequest($scope, $rootScope, $http, $timeout);
    
    const fulfilmentDashboardController = new FulfillmentDashboardController($scope, $rootScope, $http, $timeout);

    const BING_NAME = 'Chi phí QC Bing';
    const ADWORDS_NAME = 'Chi phí QC Adwords';
    const TIKTOK_NAME = 'Chi phí QC Tiktok';
    const FACEBOOK_NAME = 'Chi phí QC facebook';
    const PROFIT_ESTIMATE_NAME = 'Lợi nhuận ước tính';
    const PROFIT_NAME = 'Lợi nhuận thực';
    const COST_ESTIMATE_NAME = 'Giá vốn ước tính';
    const COST_NAME = 'Giá vốn thực';
    const ADS_API = 'https://bingads.agoz.me/ads/get-summary-data';
    const CENTRAL_API_DOMAIN = 'https://central.api.printerval.com';
    const BING_SEARCH_CAMPAIGN_NAME = {
        printerval: 'POD_',
        printblur: 'Printblur_'
    }
    $scope.weekDays = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
    $scope.hours = ['00','01','02','03','04','05','06','07','08','09','10','11','12','13','14','15','16','17','18','19','20','21','22','23'];
    $scope.hourReportTypes = [
        {key:'adCost',value:'Chi phí QC'},
        {key:'revanue',value:'Doanh Thu'},
        {key:'order',value:'Đơn Hàng'},
    ];
    $scope.hourReportType = $scope.hourReportTypes[1];
    $scope.colorLists = ['rgb(17,137,193)', 'rgb(240,119,25)', '#adc560', '#e7540c', '#9fcbe1', '#ccc', '#6aafd7', '#6078ae', '#b8501c'];
    $scope.localizationColor = ["#7cb5ec", "#f7a35c", "#8085e9", "#f15c80", "#e4d354", "#2b908f", "#f45b5b", "#058DC7", "#e7540c", "#6078ae", "#90ed7d"];
    Highcharts.setOptions({
        lang: {
            thousandsSep: ""
        }
    });
    const formatter = new Intl.NumberFormat('en-US', {
        style: 'currency',
        currency: 'USD',
    });
    $scope.params = {};
    $scope.localization = dashboardLocalization;
    $scope.currentLocale = {
        locale: currentLocale === 'central' ? 'us' : currentLocale
    }
    $scope.chartByOrderLocalization;
    $scope.chartByRevenueLocalization;
    $scope.chartByOrder;
    $scope.chartByHour;
    $scope.chartBySource;
    $scope.chartByCategory;
    $scope.chartByProduct;
    $scope.chartByCategorySource;
    $scope.chartOrderDeviceTimeline;
    $scope.chartCustomer;
    $scope.chartTicket;
    $scope.productCountBySource = [];
    $scope.chartTicketScores;

    var formatingTooltipOrder = function () {
        var text = '', currentDate = new Date(this.x);
        text = '<b>' + $scope.weekDays[currentDate.getDay()] + ' | ' + this.x + '</b><br/><br/>';
        this.points.forEach(function (item) {
            text += '<span style="color:' + item.point.color + '">\u25CF</span> ' + item.series.name + ': ' + item.point.y + '<br />';
        });
        text += '<br/><b>Tổng: ' + this.points[0].total + '</b>';
        return text;
    };
    
    var formatingTooltipRevenue = function () {
        var text = '', currentDate = new Date(this.x);
        text = '<b>' + $scope.weekDays[currentDate.getDay()] + ' | ' + this.x + '</b><br/><br/>';
        var adsValue = 0, 
            adsText = '',
            profitEstimateValue = '',
            profitValue = '';
            costEstimateValue = '',
            costValue = '';
            
        this.points.forEach(function (item) {
            if ([BING_NAME, ADWORDS_NAME, PROFIT_ESTIMATE_NAME, PROFIT_NAME, COST_ESTIMATE_NAME, COST_NAME, TIKTOK_NAME, FACEBOOK_NAME].indexOf(item.series.name) < 0) {
                text += '<span style="color:' + item.point.color + '">\u25CF</span> ' + item.series.name + ': ' + item.point.y + '<br />';
            } else if ([BING_NAME, ADWORDS_NAME, TIKTOK_NAME, FACEBOOK_NAME] .indexOf(item.series.name) > -1) {
                adsValue += item.point.y;
                adsText = '<br/><span style="color:' + item.point.color + '">\u25CF</span> <b>Chi phí QC: ' + parseInt(adsValue) + '</b>';
            } else if (item.series.name == PROFIT_ESTIMATE_NAME) {
                profitEstimateValue = '<br/><span style="color:' + item.point.color + '">\u25CF</span> <b>' + PROFIT_ESTIMATE_NAME + ': ' + parseInt(item.point.y) + '</b>';
            } else if (item.series.name == PROFIT_NAME) {
                profitValue = '<br/><span style="color:' + item.point.color + '">\u25CF</span> <b>' + PROFIT_NAME + ': ' + parseInt(item.point.y) + '</b>';
            } else if (item.series.name == COST_ESTIMATE_NAME) {
                costEstimateValue = '<br/><span style="color:' + item.point.color + '">\u25CF</span> <b>' + COST_ESTIMATE_NAME + ': ' + parseInt(item.point.y) + '</b>';
            } else if (item.series.name == COST_NAME) {
                costValue = '<br/><span style="color:' + item.point.color + '">\u25CF</span> <b>' + COST_NAME + ': ' + parseInt(item.point.y) + '</b>';
            }
        });
        text += '<p>---------------------</p>';
        text += '<br/><span style="">\u25CF</span><b> Doanh thu: ' + this.points[0].total + '</b>';
        text += adsText;
        text += profitEstimateValue;
        text += profitValue;
        text += costEstimateValue;
        text += costValue;
        return text;
    };

    $scope.fetchReportOrderLocalization = function (series) {
        if (!document.getElementById('chart-by-order-localization')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartByOrderLocalization = Highcharts.chart('chart-by-order-localization', {
                    chart: {
                        type: 'column',
                        zoomType: 'xy'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: []
                    },
                    yAxis: {
                        min: 0,
                        title: {
                            text: null
                        },
                        labels:
                        {
                            enabled: false
                        },
                    },
                    tooltip: {
                        shared: true,
                        formatter: formatingTooltipOrder
                    },
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                        }
                    },
                    series: series
                });
                resolve();
            }, 100);
        });
    }

    $scope.fetchReportRevenueLocalization = function (series) {
        if (!document.getElementById('chart-by-revenue-localization')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartByRevenueLocalization = Highcharts.chart('chart-by-revenue-localization', {
                    chart: {
                        type: 'column',
                        zoomType: 'xy'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: [],
                    },
                    yAxis: {
                        // min: 0,
                        title: {
                            text: null
                        },
                        labels: {
                            enabled: false
                        },
                    },
                    tooltip: {
                        shared: true,
                        formatter: formatingTooltipRevenue,
                    },
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                        }
                    },
                    series: series
                });
                resolve();
            }, 100);
        });
    }

    $scope.fetchReportByOrder = function () {
        if (!document.getElementById('chart-by-order')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartByOrder = Highcharts.chart('chart-by-order', {
                    chart: {
                        type: 'column',
                        zoomType: 'xy'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: [
                        {
                            categories: [],
                            crosshair: true
                        }
                    ],
                    yAxis: [
                        {
                            // min: 0,
                            title: {
                                text: null
                            },
                            labels:
                            {
                                enabled: false
                            },
                        },
                        {
                            // min: 0,
                            title: {
                                text: null
                            },
                            labels:
                            {
                                enabled: false
                            },
                        }
                    ],
                    tooltip: {
                        shared: true
                    },
                    series: [
                        {
                            name: 'Đơn hàng',
                            type: 'column',
                            yAxis: 1,
                            data: [],
                            // colorByPoint: true,
                            color: 'rgb(240, 119, 25)'
                        }, 
                        {
                            name: 'Doanh thu',
                            type: 'spline',
                            data: [],
                            tooltip: {
                                // valueSuffix: 'đ'
                            },
                            color: 'rgb(118, 166, 100)',
                        },
                        {
                            name: 'Chi phí Quảng cáo',
                            data: [],
                            type: 'spline',
                            color: '#8085e9',
                        },
                        {
                            name: PROFIT_ESTIMATE_NAME,
                            data: [],
                            type: 'spline',
                            color: '#ff0000'
                        },
                        {
                            name: PROFIT_NAME,
                            data: [],
                            type: 'spline',
                            color: '#0014ff',
                            // negativeColor: '#000000',
                        }
                    ]
                });
                resolve();
            }, 100);
        })
        
    }

    $scope.fetchTicketScore = function () {
        if (!document.getElementById('chart-ticket-scores')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartTicketScores = Highcharts.chart('chart-ticket-scores', {
                    chart: {
                        type: 'column',
                        zoomType: 'xy'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: [
                        {
                            categories: [],
                            crosshair: true
                        }
                    ],
                    yAxis: [
                        {
                            // min: 0,
                            title: {
                                text: null
                            },
                            labels:
                                {
                                    enabled: false
                                },
                        },
                        {
                            // min: 0,
                            title: {
                                text: null
                            },
                            labels:
                                {
                                    enabled: false
                                },
                        }
                    ],
                    tooltip: {
                        shared: true
                    },
                    series: [
                        {
                            name: 'Total feedback',
                            type: 'column',
                            yAxis: 1,
                            data: [],
                            // colorByPoint: true,
                            color: 'rgb(240, 119, 25)'
                        },
                        {
                            name: 'Avg scores',
                            type: 'spline',
                            data: [],
                            tooltip: {
                                // valueSuffix: 'đ'
                            },
                            color: 'rgb(118, 166, 100)',
                        }
                    ]
                });
                resolve();
            }, 100);
        })

    }

    $scope.fetchReportByCategory = function () {
        if (!document.getElementById('chart-by-category')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartByCategory = Highcharts.chart('chart-by-category', {
                    chart: {
                        plotBackgroundColor: null,
                        plotBorderWidth: null,
                        plotShadow: false,
                        type: 'pie'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    tooltip: {
                        pointFormat: 'Chiếm: <b>{point.percentage:.1f}%</b>'
                    },
                    accessibility: {
                        point: {
                            valueSuffix: '%'
                        }
                    },
                    plotOptions: {
                        pie: {
                            allowPointSelect: true,
                            cursor: 'pointer',
                            dataLabels: {
                                enabled: false,
                                format: '<b>{point.name}</b>',
                                connectorColor: 'silver'
                            },
                            showInLegend: true,
                            innerSize: 65,
                            depth: 40,
                            colors: $scope.colorLists
                        }
                    },
                    series: [
                        {
                            name: 'Danh mục',
                            data: []
                        }
                    ]
                });
                resolve();
            }, 100);
        });
    }

    $scope.fetchReportBySource = function () {
        if (!document.getElementById('chart-by-source')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartBySource = Highcharts.chart('chart-by-source', {
                    chart: {
                        plotBackgroundColor: null,
                        plotBorderWidth: null,
                        plotShadow: false,
                        type: 'pie'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    tooltip: {
                        pointFormat: 'Chiếm: <b>{point.percentage:.1f}%</b>'
                    },
                    accessibility: {
                        point: {
                            valueSuffix: '%'
                        }
                    },
                    plotOptions: {
                        pie: {
                            allowPointSelect: true,
                            cursor: 'pointer',
                            dataLabels: {
                                enabled: false,
                                format: '<b>{point.name}</b>',
                                connectorColor: 'silver'
                            },
                            showInLegend: true,
                            innerSize: 65,
                            depth: 40,
                            colors: $scope.colorLists
                        }
                    },
                    series: [
                        {
                            name: 'Nguồn',
                            data: []
                        }
                    ]
                });
                resolve();
            }, 100);
        });
    }

    $scope.fetchReportByProduct = function () {
        if (!document.getElementById('chart-by-product')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartByProduct = Highcharts.chart('chart-by-product', {
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: [],
                        crosshair: true
                    },
                    yAxis: {
                        min: 0,
                        title: {
                            text: null
                        }
                    },
                    tooltip: {
                        headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
                        pointFormat: '<tr><td style="padding:0">{series.name}: </td>' +
                        '<td style="padding:0"><b>{point.y}</b></td></tr>',
                        footerFormat: '</table>',
                        shared: true,
                        useHTML: true
                    },
                    plotOptions: {
                    column: {
                        pointPadding: 0.2,
                        borderWidth: 0
                    }
                    },
                    series: [
                        {
                            showInLegend: false,             
                            name: 'Số lượng',
                            data: [],
                            colorByPoint: true,
                        }, 
                    ]
                });
                resolve();
            }, 100);
        });
    }

    $scope.fetchReportByCategorySource = function () {
        if (!document.getElementById('chart-by-category-source')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartByCategorySource = Highcharts.chart('chart-by-category-source', {
                    chart: {
                        type: 'column',
                        zoomType: 'xy'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: []
                    },
                    yAxis: [
                        {
                            min: 0,
                            title: {
                                text: null
                            },
                            labels: {
                                enabled: false
                            },
                        },
                        {
                            min: 0,
                            title: {
                                text: null
                            },
                            labels: {
                                enabled: false
                            },
                            opposite: true
                        }
                    ],
                    legend: {
                        center: 'right',
                        enabled: false
                    },
                    tooltip: {
                        formatter: function () {
                            var text = '', currentDate = new Date(this.x);
                            var columnName = (this.series.userOptions.stack == 1) ? 'Danh mục' : 'Nguồn';
                            text = `<b>${$scope.weekDays[currentDate.getDay()]} | ${this.x}</b><br/>`;
                            text += `<br/><b><span style="color: ${this.color}">\u25CF</span> ${columnName}: </b> ${this.series.name}`;
                            text += `<br/><b><span style="color: ${this.color}">\u25CF</span> Số lượng: </b> ${this.y}`;
                            text += `<br/><b><span style="color: ${this.color}">\u25CF</span> Tổng: </b> ${this.point.stackTotal}`;
                            return text;
                        }
                    },
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                        }
                    },
                    colors: ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'].concat($scope.localizationColor),
                    series: []
                });
                resolve();
            }, 100);
        });
    }

    $scope.fetchReportByHour= function () {
        if (!document.getElementById('chart-by-hour')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartByHour = Highcharts.chart('chart-by-hour', {
                    // chart: {
                    //     type: 'column',
                    //     zoomType: 'xy'
                    // },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories:['00','01','02','03','04','05','06','07','08','09','10','11','12','13','14','15','16','17','18','19','20','21','22','23'],
                        pointStart: 0
                    },
                    yAxis: {
                        // type: 'logarithmic',
                    },
                    tooltip: {
                        shared: true
                    },
                    plotOptions: {
                        line: {
                            marker: {
                                enabled: false
                            }
                        }
                    },
                    series: [
                        {
                            color:'#d2d6de'
                        },
                        { color:'rgb(80, 180, 50)'}
                    ]
                });
                resolve();
            }, 100);
        })

    }

    $scope.changeCurrentLocale = function () {
        $scope.find();

    }
    $scope.changeHourReportType = function(){
        renderOrderByHour();
        renderOrderByHour();
    }

    $scope.find = function () {
        $scope.getReport();
        renderOrderByDeviceChart();
        renderCustomerChart();
        renderTicketChart();
        $scope.renderOrderByConversionChart();
        $scope.renderErrorDailyChart();
        $scope.getProductCountBySource();
        renderOrderByHour();
        renderTicketScores();

        fulfilmentDashboardController.renderChart();
    }

    $scope.getReport = function (isChartOrder) {
        if (!document.getElementById('chart-by-order-localization')) {
            return;
        }
        var dateFrom = $("#date-from").val();
        var dateTo = $("#date-to").val();
        if (!dateFrom || dateFrom == '') {
            toastr.error('Mời chọn ngày bắt đầu Thống kê.');
            return;
        }
        if (!dateTo || dateTo == '') {
            toastr.error('Mời chọn kết thúc Thống kê.');
            return;
        }
        dateFrom = new Date(dateFrom);
        dateFrom.setHours(0, 0, 0, 0);
        dateTo = new Date(dateTo)
        dateTo.setHours(23, 59, 59, 0);

        if (dateFrom.getTime() >= dateTo.getTime()) {
            toastr.error('Ngày Bắt đầu thống kê phải nhỏ hơn ngày Kết thúc.');
            return;
        }

        $scope.params = {
            dateFrom: dateFrom.getTime() / 1000,
            dateTo: dateTo.getTime() / 1000
        };

        var localizationParams = angular.copy($scope.params);
        localizationParams.convert_currency = true;

        var localizationPromise = []; //cần push theo đúng thứ tự
        for (var k in $scope.localization) {
            var item = $scope.localization[k];
            localizationPromise.push(new Promise (function (resolve) {
                var locale = item.locale,
                    typeName = 'revenue';
                var endPoint = '/dashboard/report-by-order-localization';
                if (item.locale != 'us') {
                    endPoint = '/' + item.locale + endPoint;
                }
                $http.get(endPoint, { params: localizationParams }).then(function (response) {
                    if (response.data.status == "successful" && response.data.data) {
                        resolve({ locale: locale, data: response.data.data, type: typeName});
                    } else {
                        resolve({ locale: locale, data: [], type: typeName});
                    }
                }, function (error) {
                    resolve({ locale: locale, data: [], type: typeName});
                });
            }));
        }

        /* Tổng chi phí Quảng Cáo theo tất cả thị trường */
        localizationPromise.push(new Promise (function (resolve) {
            var paramsAdwords = angular.copy($scope.params),
            typeName = 'ads_cost';
            paramsAdwords.type = 'adwords';
            paramsAdwords.searchStartCampaignName = getAdsConfig('adwords', 'searchStartCampaignName');
            paramsAdwords.searchAccountKeys = getAdsConfig('adwords', 'searchAccountKeys');
            $http.get(ADS_API, { params: paramsAdwords }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    resolve({data: response.data.data, type: typeName});
                } else {
                    resolve({data: [], type: typeName});
                }
            }, function (error) {
                resolve({data: [], type: typeName});
            });
        }));
        localizationPromise.push(new Promise (function (resolve) {
            var paramsBing = angular.copy($scope.params),
            typeName = 'ads_cost';
            paramsBing.type = 'bing';
            paramsBing.searchStartCampaignName = getAdsConfig('bing', 'searchStartCampaignName');
            $http.get(ADS_API, { params: paramsBing }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    resolve({data: response.data.data, type: typeName});
                } else {
                    resolve({data: [], type: typeName});
                }
            }, function (error) {
                resolve({data: [], type: typeName});
            });
        }));

        localizationPromise.push(new Promise (function (resolve) {
            var paramsTiktok = angular.copy($scope.params),
            typeName = 'ads_cost';
            paramsTiktok.type = 'tiktok';
            paramsTiktok.searchStartCampaignName = getAdsConfig('tiktok', 'searchStartCampaignName');
            paramsTiktok.searchAccountKeys = getAdsConfig('tiktok', 'searchAccountKeys');
            $http.get(ADS_API, { params: paramsTiktok }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    resolve({data: response.data.data, type: typeName});
                } else {
                    resolve({data: [], type: typeName});
                }
            }, function (error) {
                resolve({data: [], type: typeName});
            });
        }));
        localizationPromise.push(new Promise (function (resolve) {
            var paramsFacebook = angular.copy($scope.params),
            typeName = 'ads_cost';
            paramsFacebook.type = 'facebook';
            paramsFacebook.searchStartCampaignName = getAdsConfig('facebook', 'searchStartCampaignName');
            paramsFacebook.searchAccountKeys = getAdsConfig('facebook', 'searchAccountKeys');
            $http.get(ADS_API, { params: paramsFacebook }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    resolve({data: response.data.data, type: typeName});
                } else {
                    resolve({data: [], type: typeName});
                }
            }, function (error) {
                resolve({data: [], type: typeName});
            });
        }));
        
        for (var k in $scope.localization) {
            var item = $scope.localization[k];
            localizationPromise.push(new Promise (function (resolve) {
                var locale = item.locale,
                    typeName = 'base_cost';
                var endPoint = '/dashboard/report-by-cost-localization';
                if (item.locale != 'us') {
                    endPoint = '/' + item.locale + endPoint;
                }
                $http.get(endPoint, { params: $scope.params }).then(function (response) {
                    if (response.data.status == "successful" && response.data.data) {
                        resolve({ locale: locale, data: response.data.data, type: typeName});
                    } else {
                        resolve({ locale: locale, data: [], type: typeName});
                    }
                }, function (error) {
                    resolve({ locale: locale, data: [], type: typeName});
                });
            }));
        }

        for (var k in $scope.localization) {
            var item = $scope.localization[k];
            localizationPromise.push(new Promise (function (resolve) {
                var locale = item.locale,
                    typeName = 'estimate_cost';
                var endPoint = '/dashboard/report-by-cost-estimate-localization';
                if (item.locale != 'us') {
                    endPoint = '/' + item.locale + endPoint;
                }
                $http.get(endPoint, { params: localizationParams }).then(function (response) {
                    if (response.data.status == "successful" && response.data.data) {
                        resolve({ locale: locale, data: response.data.data, type: typeName});
                    } else {
                        resolve({ locale: locale, data: [], type: typeName});
                    }
                }, function (error) {
                    resolve({ locale: locale, data: [], type: typeName});
                });
            }));
        }

        /* Tổng chi phí Quảng Cáo theo thị trường hiện tại */
        localizationPromise.push(new Promise (function (resolve) {
            var paramsAdwords = angular.copy($scope.params),
            typeName = 'ads_cost_locale';
            paramsAdwords.type = 'adwords';
            paramsAdwords.searchAccountKeys = getAdsConfig('adwords', 'searchAccountKeys');
            paramsAdwords.searchStartCampaignName = getAdsConfig('adwords', 'searchStartCampaignName', $scope.currentLocale.locale.toUpperCase());
            $http.get(ADS_API, { params: paramsAdwords }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    resolve({data: response.data.data, type: typeName});
                } else {
                    resolve({data: [], type: typeName});
                }
            }, function (error) {
                resolve({data: [], type: typeName});
            });
        }));

        localizationPromise.push(new Promise (function (resolve) {
            var paramsBing = angular.copy($scope.params),
            typeName = 'ads_cost_locale';
            paramsBing.type = 'bing';
            paramsBing.searchStartCampaignName = getAdsConfig('bing', 'searchStartCampaignName', $scope.currentLocale.locale.toUpperCase());
            $http.get(ADS_API, { params: paramsBing }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    resolve({data: response.data.data, type: typeName});
                } else {
                    resolve({data: [], type: typeName});
                }
            }, function (error) {
                resolve({data: [], type: typeName});
            });
        }));

        localizationPromise.push(new Promise (function (resolve) {
            var paramsTiktok = angular.copy($scope.params),
            typeName = 'ads_cost_locale';
            paramsTiktok.type = 'tiktok';
            paramsTiktok.searchAccountKeys = getAdsConfig('tiktok', 'searchAccountKeys');
            paramsTiktok.searchStartCampaignName = getAdsConfig('tiktok', 'searchStartCampaignName', $scope.currentLocale.locale.toUpperCase());
            $http.get(ADS_API, { params: paramsTiktok }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    resolve({data: response.data.data, type: typeName});
                } else {
                    resolve({data: [], type: typeName});
                }
            }, function (error) {
                resolve({data: [], type: typeName});
            });
        }));
        
        localizationPromise.push(new Promise (function (resolve) {
            var paramsFacebook = angular.copy($scope.params),
            typeName = 'ads_cost_locale';
            paramsFacebook.type = 'facebook';
            paramsFacebook.searchAccountKeys = getAdsConfig('facebook', 'searchAccountKeys');
            paramsFacebook.searchStartCampaignName = getAdsConfig('facebook', 'searchStartCampaignName', $scope.currentLocale.locale.toUpperCase());
            $http.get(ADS_API, { params: paramsFacebook }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    resolve({data: response.data.data, type: typeName});
                } else {
                    resolve({data: [], type: typeName});
                }
            }, function (error) {
                resolve({data: [], type: typeName});
            });
        }));
        

        if (!isChartOrder) {
            $scope.chartByOrderLocalization.showLoading();
            $scope.chartByRevenueLocalization.showLoading();
        }
        $scope.chartByOrder.showLoading();
        
        Promise.all(localizationPromise).then(function (localizationData) {

            /** Tính Doanh thu */
            var xAxis = [],
                index = 0,
                sumRevenue = {}, sumCurrentRevenue = {};

            for (index in $scope.localization) {
                var item = localizationData[index];
                if (item && item.type == "revenue") {
                    var orders = [], revenues = [], itemXAxis = Object.keys(item.data);
                    if (itemXAxis.length > xAxis.length) {
                        xAxis = itemXAxis;
                    }
                    itemXAxis.forEach(function (day) {
                        orders.push(item.data[day].totalQuantity);

                        if (!sumRevenue[day]) sumRevenue[day] = 0;
                        var revenueValue = (item.data[day]) ? item.data[day].totalAmount : 0;
                        sumRevenue[day] += revenueValue;
                        revenues.push(revenueValue);
                    });

                    if (!isChartOrder) {
                        $scope.chartByOrderLocalization.series[index].setData(orders);
                        $scope.chartByRevenueLocalization.series[index].setData(revenues);
                    }
                    
                    /** Báo cáo Ngày theo thị trường hiện tại */
                    if (item.locale == $scope.currentLocale.locale) {
                        var currentOrders = [],
                            currentRevenues = [];
            
                        xAxis.forEach(function (day) {
                            sumCurrentRevenue[day] = item.data[day].totalAmount;

                            currentOrders.push(item.data[day].totalQuantity);
                            currentRevenues.push(item.data[day].totalAmount);
                        });

                        $scope.chartByOrder.xAxis[0].setCategories(xAxis); //x
                        $scope.chartByOrder.series[0].setData(currentOrders);
                        $scope.chartByOrder.series[1].setData(currentRevenues);
                    }
                }
            }

            /** Tính Tổng chi phí Quảng cáo */
            var sumAds = {};

            for (var j = 1; j <= 4; j++) { //4 loại bao gồm Bing và Adwords Tiktok Facebook
                index++;
                item = localizationData[index];
                if (item.type == "ads_cost") {
                    var costs = [];
                    for (var i in xAxis) {
                        var date = xAxis[i];
                        var valueCost = 0;
                        for (var k in item.data) {
                            if (date == item.data[k].date_report) {
                                valueCost = parseFloat(item.data[k].cost);
                            }
                        }
                        if (!sumAds[date]) sumAds[date] = 0;

                        sumAds[date] = Math.round((sumAds[date] + valueCost) * 100) / 100; //làm tròn 2 số cuối
                        costs.push(valueCost);
                    }
                    try {
                        $scope.chartByRevenueLocalization.series[index].setData(costs);
                    } catch (error) { }
                }
            }
      
            /** Tính Tổng giá vôn thực */
            var sumCosts = {}, sumCurrentCosts = {},
                sumEstimateCost = {}, sumCurrentEstimateCosts = {},
                lineEstimateProfit = index + 1,
                lineProfit = lineEstimateProfit + 1;

            for (var k = 0; k < $scope.localization.length; k++) {
                index++;
                var item = localizationData[index];
                if (item.type == "base_cost") {
                    xAxis.forEach(function (day) {
                        if (!sumCosts[day]) sumCosts[day] = 0;
                        var valueCost = (item.data[day]) ? item.data[day].totalCost : 0;
                        sumCosts[day] += valueCost;

                        // ------------------------------------------------------ //
                        if (item.locale == $scope.currentLocale.locale) {
                            sumCurrentCosts[day] = valueCost;
                        }  
                    }); 
                }
            }

            /** Tính Tổng giá vốn dự đoán */
            for (var k = 0; k < $scope.localization.length; k++) {
                index++;
                var item = localizationData[index];
                if (item.type == "estimate_cost") {
                    xAxis.forEach(function (day) {
                        if (!sumEstimateCost[day]) sumEstimateCost[day] = 0;
                        var valueCost = (item.data[day]) ? item.data[day].totalCost : 0;
                        sumEstimateCost[day] += valueCost;

                        // ------------------------------------------------------ //
                        if (item.locale == $scope.currentLocale.locale) {
                            sumCurrentEstimateCosts[day] = valueCost;
                        }
                    });  
                }
            }

            /** Tính Tổng chi phí Quảng cáo theo thị trường */
            var sumCurrentAds = {};

            for (var j = 1; j <= 3; j++) { //2 loại bao gồm Bing và Adwords
                index++;
                item = localizationData[index];
                if (item.type == "ads_cost_locale") {
                    var costs = [];
                    for (var i in xAxis) {
                        var date = xAxis[i];
                        var valueCost = 0;
                        for (var k in item.data) {
                            if (date == item.data[k].date_report) {
                                valueCost = parseFloat(item.data[k].cost);
                            }
                        }
                        if (!sumCurrentAds[date]) sumCurrentAds[date] = 0;
                        
                        sumCurrentAds[date] = Math.round((sumCurrentAds[date] + valueCost) * 100) / 100; //làm tròn 2 số cuối
                    }
                }
            }

            var profitsEstimate = [], profits = [];
            var profitsCurrentEstimate = [], profitsCurrent = [];
            xAxis.forEach(function (day) {
                // console.log("sumRevenue-" + day, sumRevenue[day] || 0);
                // console.log("sumAds-" + day, sumAds[day] || 0);
                // console.log("sumCosts-" + day, sumCosts[day] || 0);

                /** Tính lợi Nhuận thực và Lợi nhuận ước tính */
                var profitEstimate = (sumRevenue[day] || 0) - (sumAds[day] || 0) - (sumEstimateCost[day] || 0);
                profitsEstimate.push(profitEstimate);
                var profit = (sumRevenue[day] || 0) - (sumAds[day] || 0) - (sumCosts[day] || 0);
                profits.push(profit);

                // ------------------------------------------------------ //
                var profitCurrentEstimate = (sumCurrentRevenue[day] || 0) - (sumCurrentAds[day] || 0) - (sumCurrentEstimateCosts[day] || 0);
                profitsCurrentEstimate.push(profitCurrentEstimate.round(2));

                var profitCurrent = (sumCurrentRevenue[day] || 0) - (sumCurrentAds[day] || 0) - (sumCurrentCosts[day] || 0);
                profitsCurrent.push(profitCurrent.round(2));
            });

            try {
                if (!isChartOrder) {
                    $scope.chartByRevenueLocalization.series[lineEstimateProfit].setData(profitsEstimate);
                    $scope.chartByRevenueLocalization.series[lineProfit].setData(profits);
                    $scope.chartByRevenueLocalization.series[lineProfit + 1].setData(Object.values(sumEstimateCost));
                    $scope.chartByRevenueLocalization.series[lineProfit + 2].setData(Object.values(sumCosts));
                }
                $scope.chartByOrder.series[2].setData(Object.values(sumCurrentAds));
                $scope.chartByOrder.series[3].setData(profitsCurrentEstimate);
                $scope.chartByOrder.series[4].setData(profitsCurrent);
            } catch (error) { }
            
            if (!isChartOrder) {
                $scope.chartByOrderLocalization.xAxis[0].setCategories(xAxis); //x
                $scope.chartByRevenueLocalization.xAxis[0].setCategories(xAxis); //x
                $scope.chartByOrderLocalization.hideLoading();
                $scope.chartByRevenueLocalization.hideLoading();
            }

            $scope.chartByOrder.hideLoading();
        }).catch(function (error) { console.error(error); });

        if (!isChartOrder && permissionReportByAttributes) {
            $scope.chartBySource.showLoading();
            let prefixUrl = '';
            if ($scope.currentLocale.locale != 'us') {
                prefixUrl = '/' + $scope.currentLocale.locale;
            }
            $http.get(prefixUrl + '/dashboard/report-by-source', { params: $scope.params }).then(function (response) {
                var sources = [];
                if (response.data.status == "successful" && response.data.data) {
                    response.data.data.forEach(function (item) {
                        sources.push({ name: item.source, y: item.quantity });
                    });
                    $scope.chartBySource.series[0].setData(sources);
                } else {
                    $scope.chartBySource.series[0].setData([]);
                }
                $scope.chartBySource.hideLoading();
            }, function (error) {
                toastr.error('Có lỗi xảy ra trong quá trình Lấy báo cáo đơn hàng theo nguồn. Xin vui lòng thử lại.');
            });

            $scope.chartByCategory.showLoading();
            $http.get(prefixUrl + '/dashboard/report-by-category', { params: $scope.params }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    var categories = [];
                    response.data.data.forEach(function (item) {
                        categories.push({ name: item.name, y: item.quantity });
                    });
                    $scope.chartByCategory.series[0].setData(categories);
                } else {
                    $scope.chartByCategory.series[0].setData([]);
                }
                $scope.chartByCategory.hideLoading();
            }, function (error) {
                toastr.error('Có lỗi xảy ra trong quá trình Lấy báo cáo đơn hàng theo danh mục. Xin vui lòng thử lại.');
            });

            $scope.chartByProduct.showLoading();
            $http.get(prefixUrl + '/dashboard/report-by-product', { params: $scope.params }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    var xAxis = [], products = [];
                    response.data.data.forEach(function (item) {
                        xAxis.push(item.name);
                        products.push(item.quantity);
                    });
                    $scope.chartByProduct.xAxis[0].setCategories(xAxis); //x
                    $scope.chartByProduct.series[0].setData(products);
                } else {
                    $scope.chartByProduct.xAxis[0].setCategories([]); //x
                    $scope.chartByProduct.series[0].setData([]);
                }
                $scope.chartByProduct.hideLoading();
            }, function (error) {
                toastr.error('Có lỗi xảy ra trong quá trình Lấy báo cáo đơn hàng theo sản phẩm. Xin vui lòng thử lại.');
            });


        }
    }

    $scope.init = function () 
    {
        $scope.fetchBotRequest();
        $timeout(function () {
            $("#date-from").datepicker({
                dateFormat: "yy-mm-dd",
            }).datepicker("setDate", "-1w");

            $("#date-to").datepicker({
                dateFormat: "yy-mm-dd",
            }).datepicker("setDate", "+0");
            $("#date-compare").datepicker({
                dateFormat: "yy-mm-dd",
                onSelect: function(dateText) {
                    $scope.changeHourReportType();
                }
            }).datepicker("setDate", "-1d");
            var series = [];
            for (var k in $scope.localization) {
                var item = $scope.localization[k];
                series.push({
                    name: item.name,
                    data: [],
                    color: $scope.localizationColor[k],
                    stack: 1,
                    type: 'column'
                });
            }

            var seriesRevenue = angular.copy(series);
            seriesRevenue.push(
                {
                    name: ADWORDS_NAME,
                    data: [],
                    stack: 2,
                    color: '#76a664',
                    type: 'column'
                },
                {
                    name: BING_NAME,
                    data: [],
                    stack: 2,
                    color: '#007e6d',
                    type: 'column'
                },
                {
                    name: TIKTOK_NAME,
                    data: [],
                    stack: 2,
                    color: '#002e6d',
                    type: 'column'
                },
                {
                    name: FACEBOOK_NAME,
                    data: [],
                    stack: 2,
                    color: '#007e6d',
                    type: 'column'
                },
                {
                    name: PROFIT_ESTIMATE_NAME,
                    data: [],
                    type: 'spline',
                    color: '#ff0000'
                },
                {
                    name: PROFIT_NAME,
                    data: [],
                    type: 'spline',
                    color: '#0014ff',
                },
                {
                    name: COST_ESTIMATE_NAME,
                    data: [],
                    type: 'spline',
                    opacity: 0,
                    color: '#fff'
                },
                {
                    name: COST_NAME,
                    data: [],
                    type: 'spline',
                    opacity: 0,
                    color: '#fff',
                    // negativeColor: '#000000',
                }
            );
            Promise.all([
                $scope.fetchReportOrderLocalization(series),
                $scope.fetchReportRevenueLocalization(seriesRevenue),
                $scope.fetchReportByOrder(),
                $scope.fetchReportByCategory(),
                $scope.fetchReportBySource(),
                $scope.fetchReportByProduct(),
                $scope.fetchReportByCategorySource(),
                $scope.fetchReportByHour(),
                $scope.fetchTicketScore(),
                 // Init order by devices chart
                $scope.initOrderByDeviceTimeLineChart(),
                $scope.initOrderByConversionTimeLineChart(),

                // Init customer
                initCustomerChart(),
                initTicketChart(),

                // fulfillment dashboard
                fulfilmentDashboardController.init()

            ]).then(function () {
                $scope.find();
            });
        });

    }

    function renderOrderByDeviceChart() 
    {
        if (!document.getElementById('chart-order-by-device-timline')) {
            return;
        }

        $scope.chartOrderDeviceTimeline.showLoading();

        var dateFrom = $("#date-from").val();
        var dateTo = $("#date-to").val();

        dateFrom = new Date(dateFrom);
        dateFrom.setHours(0, 0, 0, 0);
        dateTo = new Date(dateTo)
        dateTo.setHours(23, 59, 59, 0);

        $scope.params = {
            dateFrom: dateFrom.getTime() / 1000,
            dateTo: dateTo.getTime() / 1000,
            locale: $scope.currentLocale.locale
        };

        $http.get('/dashboard/get-report-order-with-device', { params: $scope.params }).then(function (response) {
            if (response.data.status == "successful") {

                while ($scope.chartOrderDeviceTimeline.series.length) {
                    $scope.chartOrderDeviceTimeline.series[0].remove();
                }

                let groupByDevice = {
                    colorByPoint: true,
                    data: []
                };

                for (const keyDevice in response.data.group_by_device) {
                    if (Object.hasOwnProperty.call(response.data.group_by_device, keyDevice)) {
                        const count = response.data.group_by_device[keyDevice];
                        const capitalized = keyDevice.charAt(0).toUpperCase() + keyDevice.slice(1);
                        groupByDevice.data.push({
                            name: capitalized,
                            y: count
                        });
                    }
                }
                

                $scope.chartOrderDeviceTimeline.xAxis[0].setCategories(response.data.xAxis);
                for (const keyDevice in response.data.group_by_date) {
                    if (Object.hasOwnProperty.call(response.data.group_by_date, keyDevice)) {
                        const payload = response.data.group_by_date[keyDevice];
                        const capitalized = keyDevice.charAt(0).toUpperCase() + keyDevice.slice(1);
                        const seriesValues = Object.values(payload);

                        $scope.chartOrderDeviceTimeline.addSeries({
                            name: capitalized,
                            data: seriesValues
                        });
                    }
                }

                $scope.chartOrderDeviceTimeline.hideLoading();

            }
        });

    }

    function getAdsConfig (type, key, locale = '') {
        var retVal = '';
        if (configAdsObj && typeof configAdsObj[type] != 'undefined' && typeof configAdsObj[type][key] != 'undefined') {
            retVal = configAdsObj[type][key];
        }
        retVal = retVal.replace("[locale]", locale);
        return retVal;
    }

    const initCustomerChart = () => {
        if (!document.getElementById('chart-customer')) {
            return;
        }
        return new Promise (function (resolve) 
        {
            $timeout(function () {

                $scope.chartCustomerTimeline = Highcharts.chart('chart-customer', {
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: null
                    },
                    subtitle: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: []
                    },
                    yAxis: [
                        {
                            // min: 0,
                            title: {
                                text: 'Đặt hàng'
                            },
                            labels: {
                                enabled: false
                            },
                        },
                        {
                            title: {
                                text: 'Đăng ký'
                            },
                            labels: {
                                enabled: false
                            },
                            opposite: true
                        }
                    ],
                    tooltip: {
                        pointFormatter: function() {

                            if (this.series.name == 'Registered customer') {
                                return `<span style="color:${this.series.color}">${this.series.name}</span>: <b>${this.y}</b><br/>`;
                            }

                            let percent = parseFloat(this.percentage).toFixed(2)

                            return `<span style="color:${this.series.color}">${this.series.name}</span>: <b>${this.y}</b> (${percent}%)<br/>`;
                        },
                        shared: true
                    },
                    colors: ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'].concat($scope.localizationColor),
                    series: []
                });

                resolve();

            }, 100);
        });
    }

    const renderCustomerChart = () => 
    {
        if (!document.getElementById('chart-customer')) {
            return;
        }

        $scope.chartCustomerTimeline.showLoading();

        var dateFrom = $("#date-from").val();
        var dateTo = $("#date-to").val();

        dateFrom = new Date(dateFrom);
        dateFrom.setHours(0, 0, 0, 0);
        dateTo = new Date(dateTo)
        dateTo.setHours(23, 59, 59, 0);

        $scope.params = {
            dateFrom: dateFrom.getTime() / 1000,
            dateTo: dateTo.getTime() / 1000,
            locale: $scope.currentLocale.locale
        };
        
        $http.get('/dashboard/get-report-customer', { params: $scope.params }).then(function (response) {
            if (response.data.status == "successful") {

                while ($scope.chartCustomerTimeline.series.length) {
                    $scope.chartCustomerTimeline.series[0].remove();
                }

                $scope.chartCustomerTimeline.xAxis[0].setCategories(response.data.xAxis);

                for (const keyDevice in response.data.group_by_date) {
                    if (Object.hasOwnProperty.call(response.data.group_by_date, keyDevice)) {

                        const payload = response.data.group_by_date[keyDevice];
                        const capitalized = keyDevice.charAt(0).toUpperCase() + keyDevice.slice(1);

                        const seriesValues = [];
                        for (let i = 0; i < response.data.xAxis.length; i++) {
                            const date = response.data.xAxis[i];
                            if (typeof payload[date] != 'undefined') {
                                seriesValues.push(payload[date]);
                            } else {
                                seriesValues.push(0);
                            }
                        }

                        $scope.chartCustomerTimeline.addSeries({
                            yAxis: 1,
                            name: capitalized,
                            data: seriesValues,
                            stack: 'order/customer',
                            stacking: 'percent',
                            colors: $scope.colorLists
                        });
                    }
                }


                const seriesValues = [];
                for (let i = 0; i < response.data.xAxis.length; i++) {
                    const date = response.data.xAxis[i];
                    if (typeof response.data.customer_registed[date] != 'undefined') {
                        seriesValues.push(response.data.customer_registed[date]);
                    } else {
                        seriesValues.push(0);
                    }
                }
                $scope.chartCustomerTimeline.addSeries({
                    yAxis: 0,
                    name: 'Registered customer',
                    data: seriesValues,
                    stack: 'customer_registed',
                    colors: $scope.colorLists
                });

                $scope.chartCustomerTimeline.hideLoading();

            }
        });
    }

    const initTicketChart = () => 
    {
        if (!document.getElementById('chart-ticket')) {
            return;
        }
        return new Promise (function (resolve) 
        {
            $timeout(function () {

                $scope.chartTicketTimeline = Highcharts.chart('chart-ticket', {
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: null
                    },
                    subtitle: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: []
                    },
                    yAxis: {
                        // min: 0,
                        title: {
                            text: 'Number of Ticket'
                        },
                        labels: {
                            enabled: false
                        },
                    },
                    tooltip: {
                        pointFormat: '<span style="color:{series.color}">{series.name}</span>: <b>{point.y}</b> ({point.percentage:.0f}%)<br/>',
                        shared: true
                    },
                    plotOptions: {
                        column: {
                            stacking: 'percent',
                            colors: $scope.colorLists
                        }
                    },
                    colors: ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'].concat($scope.localizationColor),
                    series: []
                });

                $scope.chartTicketPie =  Highcharts.chart('chart-ticket-pie', {
                    chart: {
                        plotBackgroundColor: null,
                        plotBorderWidth: null,
                        plotShadow: false,
                        type: 'pie'
                    },
                    title: {
                        text: null
                    },
                    tooltip: {
                        pointFormat: '<b>{point.percentage:.1f}%</b>'
                    },
                    accessibility: {
                        point: {
                            valueSuffix: '%'
                        }
                    },
                    plotOptions: {
                        pie: {
                            allowPointSelect: true,
                            cursor: 'pointer',
                            dataLabels: {
                                enabled: true,
                                format: '<b>{point.name}</b>: {point.percentage:.1f} %'
                            }
                        }
                    },
                    series: []
                });

                resolve();

            }, 100);
        });
    }

    const renderTicketChart = () => 
    {
        if (!document.getElementById('chart-ticket')) {
            return;
        }

        $scope.chartTicketPie.showLoading();
        $scope.chartTicketTimeline.showLoading();

        var dateFrom = $("#date-from").val();
        var dateTo = $("#date-to").val();

        dateFrom = new Date(dateFrom);
        dateFrom.setHours(0, 0, 0, 0);
        dateTo = new Date(dateTo);
        dateTo.setHours(23, 59, 59, 0);

        $scope.params = {
            dateFrom: dateFrom.getTime() / 1000,
            dateTo: dateTo.getTime() / 1000,
            locale: $scope.currentLocale.locale
        };
        
        $http.get('/dashboard/get-report-ticket', { params: $scope.params }).then(function (response) {
            if (response.data.status == "successful") {

                while ($scope.chartTicketTimeline.series.length) {
                    $scope.chartTicketTimeline.series[0].remove();
                }
                while ($scope.chartTicketPie.series.length) {
                    $scope.chartTicketPie.series[0].remove();
                }

                let groupByType = {
                    colorByPoint: true,
                    data: []
                };

                for (const keyDevice in response.data.group_by_type) {
                    if (Object.hasOwnProperty.call(response.data.group_by_type, keyDevice)) {
                        const count = response.data.group_by_type[keyDevice];
                        const capitalized = keyDevice.charAt(0).toUpperCase() + keyDevice.slice(1);
                        groupByType.data.push({
                            name: capitalized,
                            y: count
                        });
                    }
                }

                groupByType.data.sort((a, b) => b.y - a.y);

                $scope.chartTicketPie.addSeries(groupByType);

                $scope.chartTicketTimeline.xAxis[0].setCategories(response.data.xAxis);
                for (const keyDevice in response.data.group_by_date) {
                    if (Object.hasOwnProperty.call(response.data.group_by_date, keyDevice)) {
                        const payload = response.data.group_by_date[keyDevice];
                        const capitalized = keyDevice.charAt(0).toUpperCase() + keyDevice.slice(1);
                        const seriesValues = Object.values(payload);

                        $scope.chartTicketTimeline.addSeries({
                            name: capitalized,
                            showInLegend: false,
                            data: seriesValues
                        });
                    }
                }

                $scope.chartTicketPie.hideLoading();
                $scope.chartTicketTimeline.hideLoading();

            }
        });
    }


    $scope.initOrderByDeviceTimeLineChart = function() 
    {
        if (!document.getElementById('chart-order-by-device-timline')) {
            return;
        }
        return new Promise (function (resolve) 
        {
            $timeout(function () {

                $scope.chartOrderDeviceTimeline = Highcharts.chart('chart-order-by-device-timline', {
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: null
                    },
                    subtitle: {
                        text: 'Number of orders by day'
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: []
                    },
                    yAxis: {
                        // min: 0,
                        title: {
                            text: 'Order Number'
                        },
                        labels: {
                            enabled: false
                        },
                    },
                    tooltip: {
                        pointFormat: '<span style="color:{series.color}">{series.name}</span>: <b>{point.y}</b> ({point.percentage:.0f}%)<br/>',
                        shared: true
                    },
                    plotOptions: {
                        column: {
                            stacking: 'percent',
                            colors: $scope.colorLists
                        }
                    },
                    colors: ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'].concat($scope.localizationColor),
                    series: []
                });

                resolve();

            }, 100);
        });
    }

    $scope.initOrderByConversionTimeLineChart = function() 
    {
        if (!document.getElementById('chart-order-by-conversion-timeline')) {
            return;
        }
        return new Promise (function (resolve) 
        {
            $timeout(function () {

                $scope.chartOrderConversionTimeline = Highcharts.chart('chart-order-by-conversion-timeline', {
                    title: {
                        text: null
                    },
                    subtitle: {
                        text: 'Amount Average, Order/Cart, Order/View by day'
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: []
                    },
                    yAxis: [
                        {
                            // min: 0,
                            title: {
                                text: null
                            },
                            labels:
                            {
                                enabled: false
                            },
                        },
                        {
                            // min: 0,
                            title: {
                                text: null
                            },
                            labels:
                            {
                                enabled: false
                            },
                        },
                        {
                            // min: 0,
                            title: {
                                text: null
                            },
                            labels:
                            {
                                enabled: false
                            },
                        },
                        {
                            // min: 0,
                            title: {
                                text: null
                            },
                            labels:
                            {
                                enabled: false
                            },
                        }
                    ],
                    tooltip: {
                        shared: true
                    },
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                            colors: $scope.colorLists
                        }
                    },
                    colors: ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'].concat($scope.localizationColor),
                    series: [
                        {
                            name: 'Cart',
                            type: 'column',
                            yAxis: 0,
                            data: [],
                            // colorByPoint: true,
                            color: '#1CA6E0'
                        },
                        {
                            name: 'Amount Average',
                            yAxis: 1,
                            data: [],
                            type: 'spline',
                            color: 'rgb(240, 119, 25)',
                        },
                        {
                            name: 'Order/Cart (%)',
                            type: 'spline',
                            yAxis: 1,
                            data: [],
                            // colorByPoint: true,
                            color: 'rgb(118, 166, 100)'
                        }, 
                        
                        {
                            name: 'Order/View (%)',
                            type: 'spline',
                            yAxis: 2,
                            data: [],
                            tooltip: {
                                // valueSuffix: 'đ'
                            },
                            color: '#8085e9',
                        }

                    ]
                });

                resolve();

            }, 100);
        });
    }

    $scope.renderOrderByConversionChart = function () {
        if (!document.getElementById('chart-order-by-conversion-timeline')) {
            return;
        }
        $scope.chartOrderConversionTimeline.showLoading();

        var dateFrom = $("#date-from").val();
        var dateTo = $("#date-to").val();

        dateFrom = new Date(dateFrom);
        dateFrom.setHours(0, 0, 0, 0);
        dateTo = new Date(dateTo)
        dateTo.setHours(23, 59, 59, 0);

        $scope.params = {
            dateFrom: dateFrom.getTime() / 1000,
            dateTo: dateTo.getTime() / 1000,
            locale: $scope.currentLocale.locale
        };

        if ($scope.currentEvent) {
            $scope.params.event_id = $scope.currentEvent;
        }

        var translateKey = {
            order_cart: 'Order/Cart',
            order_view: 'Order/View',
            amount_avg: 'Amount Avg'
        }

        $http.get('/dashboard/get-report-order-by-conversion', { params: $scope.params }).then(function (response) {
            if (response.data.status == "successful") {

                
                $scope.chartOrderConversionTimeline.xAxis[0].setCategories(response.data.xAxis);
                let index = 0;
                let keys = ['cart', 'amount_avg', 'order_cart', 'order_view']
                for (const keyConversion of keys) {
                    if (Object.hasOwnProperty.call(response.data.group_by_date, keyConversion)) {
                        const payload = response.data.group_by_date[keyConversion];
                        const seriesValues = Object.values(payload);
                        console.log(seriesValues)
                        $scope.chartOrderConversionTimeline.series[index++].setData(seriesValues);
                    }
                }

                $scope.chartOrderConversionTimeline.hideLoading();

            }
        });

    }

    $scope.renderErrorDailyChart = function () {
        let path = '/report/daily-error?ignore_localization=1';
        let apiDomain = 'api.' + window.location.hostname;
        let urls = [];
        $scope.sortErrorType = 'count';

        for (let item of dashboardLocalization) {
            let apiUrl = (item.locale != defaultLocale ? `${window.location.protocol}//${item.locale}.` : `${window.location.protocol}//`) + apiDomain;
            urls.push(apiUrl + path);
        }
        $scope.dailyErrorLinks = [];
        for (let url of urls) {
            $http.get(url, { params: $scope.params }).then(function (response) {
                if (response.data.status == "successful" && response.data.result) {
                    $scope.dailyErrorLinks = $scope.dailyErrorLinks.concat(response.data.result);
                    $scope.sortDailyError();
                } else {
                }
            }, function (error) {
                toastr.error('Có lỗi xảy ra trong quá trình Lấy báo cáo lỗi. Xin vui lòng thử lại.');
            });
        }

    }

    $scope.sortErrorByLatest = function () {
        $scope.sortErrorType = 'latest';
        $scope.dailyErrorLinks.sort((a, b) => {
            if (a.latest_occur_time > b.latest_occur_time) {
                return -1;
            }
            if (a.latest_occur_time < b.latest_occur_time) {
                return 1;
            }
            return 0;
        })
    }

    $scope.sortErrorByCount = function () {
        $scope.sortErrorType = 'count';
        $scope.dailyErrorLinks.sort((a, b) => {
            if (a.count > b.count) {
                return -1;
            }
            if (a.count < b.count) {
                return 1;
            }
            return 0;
        })
    }

    $scope.getProductCountBySource = () => {
        return;
        $scope.productCountBySource  = [];
        let url = ($scope.currentLocale.locale != defaultLocale ? `/${$scope.currentLocale.locale}` : '') +  '/dashboard/get-report-product-count-by-source?ignore_localization=1';
        $http.get(url)
            .then(res => {
                if (res.data.status == 'successful') {
                    $scope.productCountBySource = res.data.result;
                }
            })
    }

    $scope.sortDailyError = function () {
        let priority = {
            us: 200,
            uk: 100,
            de: 90,
            fr: 60
        }
        priority[defaultLocale] = 99999;

        $scope.dailyErrorLinks.sort((a, b) => {
            if (b.count == a.count) {
                if (b.latest_occur_time == a.latest_occur_time) {
                    let priA = priority[a.locale] ? priority[a.locale] : 1;
                    let priB = priority[b.locale] ? priority[b.locale] : 1;
    
                    return priB - priA;
                }
                return b.latest_occur_time - a.latest_occur_time;
            }
            return b.count - a.count;
        })
    }

    function renderOrderByHour()
    {
        if (!document.getElementById('chart-by-hour')) {
            return;
        }

        $scope.chartByHour.showLoading();


        if ($scope.hourReportType.key == 'adCost'){
            renderAdCost();
        }else{
            renderRevanue();
        }
        $scope.chartByHour.hideLoading();

    }

    function renderAdCost(){
        let comparePromise = [];
        $scope.totalCompareDay = [];
        for (let i = $scope.chartByHour.series.length - 1; i >= 0; i--) {
            $scope.chartByHour.series[i].setData([]);
        }
        comparePromise.push(new Promise (function (resolve) {
            let dateSelected = $("#date-compare").val();
            let dateFrom = new Date(dateSelected);
            dateFrom.setHours(0, 0, 0, 0);
            let dateTo = new Date(dateSelected)
            dateTo.setHours(23, 59, 59, 0);
            let filter = {
                dateFrom: dateFrom.getTime() / 1000,
                dateTo: dateTo.getTime() / 1000,
                locale: $scope.currentLocale.locale,
                columns:'hour_report',
                groupBy:'hour_report',
                orderBy:'hour_report,asc'

            };
            filter.searchStartCampaignName = getAdsConfig('bing', 'searchStartCampaignName',$scope.currentLocale.locale);
            $http.get(ADS_API, { params: filter }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    resolve({data: response.data.data,name:dateSelected});
                } else {
                    resolve({data: [],name:dateSelected});
                }
            }, function (error) {
                resolve({data: [],name:dateSelected});
            });
        }));
        comparePromise.push(new Promise (function (resolve) {
            let dateNow = Date.now();
            let dateFrom = new Date(dateNow);
            dateFrom.setHours(0, 0, 0, 0);
            let dateTo = new Date(dateNow)
            dateTo.setHours(23, 59, 59, 0);
            let filter = {
                dateFrom: dateFrom.getTime() / 1000,
                dateTo: dateTo.getTime() / 1000,
                locale: $scope.currentLocale.locale,
                columns:'hour_report',
                groupBy:'hour_report',
                orderBy:'hour_report,asc'

            };
            filter.searchStartCampaignName = getAdsConfig('bing', 'searchStartCampaignName',$scope.currentLocale.locale);
            $http.get(ADS_API, { params: filter }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    resolve({data: response.data.data,name:'Today'});
                } else {
                    resolve({data: [],name:'Today'});
                }
            }, function (error) {
                resolve({data: [],name:'Today'});
            });
        }));
        Promise.all(comparePromise).then(function (compareData) {
            compareData.forEach(function (item,index){
                let serieData = [];
                let totalCost = 0;
                item.data.forEach(function(cost){
                    totalCost += parseFloat(cost.cost);
                    serieData.push(Math.round(totalCost*100)/100);
                });
                $scope.totalCompareDay.push(formatter.format(Math.round(totalCost*100)/100));
                $scope.chartByHour.series[index].setName(item.name);
                $scope.chartByHour.series[index].setData(serieData);
            });

        }).catch(function (error) { console.error(error); });
    }

    function renderRevanue(){
        $scope.totalCompareDay = [];
        let comparePromise = [];
        comparePromise.push(new Promise (function (resolve) {
            let dateSelected = $("#date-compare").val();
            let filter = {
                date: dateSelected,
                report_by:'hour',
                convert_currency:true
            };
            let endPoint = '/dashboard/report-by-order-localization';
            if ($scope.currentLocale.locale != 'us') {
                endPoint = '/' + $scope.currentLocale.locale + endPoint;
            }
            $http.get(endPoint, { params: filter }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    resolve({data: response.data.data,name:dateSelected});
                } else {
                    resolve({data: [],name:dateSelected});
                }
            }, function (error) {
                resolve({data: [],name:dateSelected});
            });
        }));
        comparePromise.push(new Promise (function (resolve) {
            let today = new Date();
            let dd = String(today.getDate()).padStart(2, '0');
            let mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
            let yyyy = today.getFullYear();
            let hour = String(today.getHours()).padStart(2, '0');

            today = yyyy + '-' + mm + '-' + dd;
            $scope.current = today + ' ' + hour;

                let filter = {
                date: today,
                report_by:'hour',
                convert_currency:true

            };
            let endPoint = '/dashboard/report-by-order-localization';
            if ($scope.currentLocale.locale != 'us') {
                endPoint = '/' + $scope.currentLocale.locale + endPoint;
            }
            $http.get(endPoint, { params: filter }).then(function (response) {
                if (response.data.status == "successful" && response.data.data) {
                    resolve({data: response.data.data,name:'Today'});
                } else {
                    resolve({data: [],name:'Today'});
                }
            }, function (error) {
                resolve({data: [],name:'Today'});
            });
        }));
        Promise.all(comparePromise).then(function (compareData) {
            compareData.forEach(function (item,index){
                let serieData = [];
                let serieDataOrder = [];
                let totalRevanue = 0;
                let totalOrder = 0;
                if (!Array.isArray(item.data)){
                    item.data = Object.entries(item.data);
                }
                let flag = false;
                item.data.forEach(function(dataItem){
                    if (!flag){
                        let order = dataItem[1];
                        totalRevanue += parseFloat(order.totalAmount);
                        serieData.push(Math.round(totalRevanue * 100) / 100);
                        totalOrder += parseInt(order.totalQuantity);
                        serieDataOrder.push(totalOrder);
                    }
                    if (index == 1 && dataItem[0] == $scope.current) {
                        flag = true;
                    }
                });
                if ($scope.hourReportType.key == 'revanue'){
                    $scope.totalCompareDay.push(formatter.format(Math.round(totalRevanue*100)/100));
                    $scope.chartByHour.series[index].setData(serieData);
                }else{
                    $scope.totalCompareDay.push(totalOrder);
                    $scope.chartByHour.series[index].setData(serieDataOrder);
                }
                $scope.chartByHour.series[index].setName(item.name);
            });

        }).catch(function (error) { console.error(error); });
    }

    function renderTicketScores()
    {
        if (!document.getElementById('chart-ticket-scores')) {
            return;
        }

        $scope.chartTicketScores.showLoading();

        let url = CENTRAL_API_DOMAIN + '/ticket/avg-scores';
        let dateFrom = $("#date-from").val();
        let dateTo = $("#date-to").val();
        let filter = {
            'dateFrom': dateFrom + ' 00:00:00',
            'dateTo': dateTo + ' 23:59:59',
        };
        $http.get(url, { params: filter }).then(function (response) {
            if (response.data.status == "successful" && response.data.data) {
                $scope.chartTicketScores.xAxis[0].setCategories(response.data.data.date); //x
                $scope.chartTicketScores.series[0].setData(response.data.data.total);
                $scope.chartTicketScores.series[1].setData(response.data.data.scores);
            }
            $scope.chartTicketScores.hideLoading();
        }, function (error) {
            console.error(error);
            $scope.chartTicketScores.hideLoading();
        });
        $scope.chartTicketScores.hideLoading();

    }

    $scope.init();
});
