Number.prototype.round = function(places) {
    return +(Math.round(this + "e+" + places)  + "e-" + places);
}

system.controller("EventDashboardController", function ($scope, $rootScope, $http, $timeout) {

    const BING_NAME = 'Chi phí QC Bing';
    const ADWORDS_NAME = 'Chi phí QC Adwords';
    const PROFIT_ESTIMATE_NAME = 'Lợi nhuận ước tính';
    const PROFIT_NAME = 'Lợi nhuận thực';
    const COST_ESTIMATE_NAME = 'Giá vốn ước tính';
    const COST_NAME = 'Giá vốn thực';
    const ADS_API = 'https://bingads.agoz.me/ads/get-summary-data';
    const BING_SEARCH_CAMPAIGN_NAME = {
        printerval: 'POD_',
        printblur: 'Printblur_'
    }
    $scope.weekDays = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
    $scope.colorLists = ['rgb(17,137,193)', 'rgb(240,119,25)', '#adc560', '#e7540c', '#9fcbe1', '#ccc', '#6aafd7', '#6078ae', '#b8501c'];
    $scope.localizationColor = ["#7cb5ec", "#f7a35c", "#8085e9", "#f15c80", "#e4d354", "#2b908f", "#f45b5b", "#058DC7", "#e7540c", "#6078ae", "#90ed7d"];
    Highcharts.setOptions({
        lang: {
            thousandsSep: ""
        },
        chart: {
            style: {
                fontFamily: '"Source Sans Pro", sans-serif'
            }
        }
    });

    $scope.params = {};
    $scope.localization = dashboardLocalization;
    $scope.currentLocale = currentLocale;
    $scope.chartByOrderLocalization;
    $scope.chartByRevenueLocalization;
    $scope.chartByOrder;
    $scope.chartBySource;
    $scope.chartByCategory;
    $scope.chartByProduct;
    $scope.chartByCategorySource;
    $scope.chartOrderDeviceTimeline;
    $scope.chartCustomer;
    $scope.chartTicket;
    $scope.seasonEvents = [];
    $scope.currentEvent = null;

    var formatingTooltipOrder = function () {
        var text = '', currentDate = new Date(this.x);
        text = '<b>' + $scope.weekDays[currentDate.getDay()] + ' | ' + this.x + '</b><br/><br/>';
        this.points.forEach(function (item) {
            text += '<span style="color:' + item.point.color + '">\u25CF</span> ' + item.series.name + ': ' + item.point.y + '<br />';
        });
        text += '<br/><b>Tổng: ' + this.points[0].total + '</b>';
        return text;
    };
    
    var formatingTooltipRevenue = function () {
        var text = '', currentDate = new Date(this.x);
        text = '<b>' + $scope.weekDays[currentDate.getDay()] + ' | ' + this.x + '</b><br/><br/>';
        var adsValue = 0, 
            adsText = '',
            profitEstimateValue = '',
            profitValue = '';
            costEstimateValue = '',
            costValue = '';
            
        this.points.forEach(function (item) {
            if ([BING_NAME, ADWORDS_NAME, PROFIT_ESTIMATE_NAME, PROFIT_NAME, COST_ESTIMATE_NAME, COST_NAME].indexOf(item.series.name) < 0) {
                text += '<span style="color:' + item.point.color + '">\u25CF</span> ' + item.series.name + ': ' + item.point.y + '<br />';
            } else if ([BING_NAME, ADWORDS_NAME] .indexOf(item.series.name) > -1) {
                adsValue += item.point.y;
                adsText = '<br/><span style="color:' + item.point.color + '">\u25CF</span> <b>Chi phí QC: ' + parseInt(adsValue) + '</b>';
            } else if (item.series.name == PROFIT_ESTIMATE_NAME) {
                profitEstimateValue = '<br/><span style="color:' + item.point.color + '">\u25CF</span> <b>' + PROFIT_ESTIMATE_NAME + ': ' + parseInt(item.point.y) + '</b>';
            } else if (item.series.name == PROFIT_NAME) {
                profitValue = '<br/><span style="color:' + item.point.color + '">\u25CF</span> <b>' + PROFIT_NAME + ': ' + parseInt(item.point.y) + '</b>';
            } else if (item.series.name == COST_ESTIMATE_NAME) {
                costEstimateValue = '<br/><span style="color:' + item.point.color + '">\u25CF</span> <b>' + COST_ESTIMATE_NAME + ': ' + parseInt(item.point.y) + '</b>';
            } else if (item.series.name == COST_NAME) {
                costValue = '<br/><span style="color:' + item.point.color + '">\u25CF</span> <b>' + COST_NAME + ': ' + parseInt(item.point.y) + '</b>';
            }
        });
        text += '<p>---------------------</p>';
        text += '<br/><span style="">\u25CF</span><b> Doanh thu: ' + this.points[0].total + '</b>';
        text += adsText;
        text += profitEstimateValue;
        text += profitValue;
        text += costEstimateValue;
        text += costValue;
        return text;
    };

    const initOrderLocalizationChart = function (series) 
    {
        if (!document.getElementById('chart-by-order-localization')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartByOrderLocalization = Highcharts.chart('chart-by-order-localization', {
                    chart: {
                        type: 'column',
                        zoomType: 'xy'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: []
                    },
                    yAxis: {
                        min: 0,
                        title: {
                            text: null
                        },
                        labels:
                        {
                            enabled: false
                        },
                    },
                    tooltip: {
                        shared: true,
                        formatter: formatingTooltipOrder
                    },
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                        }
                    },
                    series: series
                });
                resolve();
            }, 100);
        });
    }

    const initReportRevenueLocalization = function (series) {
        if (!document.getElementById('chart-by-revenue-localization')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartByRevenueLocalization = Highcharts.chart('chart-by-revenue-localization', {
                    chart: {
                        type: 'column',
                        zoomType: 'xy'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: [],
                    },
                    yAxis: {
                        // min: 0,
                        title: {
                            text: null
                        },
                        labels: {
                            enabled: false
                        },
                    },
                    tooltip: {
                        shared: true,
                        formatter: formatingTooltipRevenue,
                    },
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                        }
                    },
                    series: series
                });
                resolve();
            }, 100);
        });
    }

    const initReportByDay = function () 
    {
        if (!document.getElementById('chart-by-day')) {
            return;
        }

        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartByOrder = Highcharts.chart('chart-by-day', {
                    chart: {
                        type: 'column',
                        zoomType: 'xy'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: [
                        {
                            categories: [],
                            crosshair: true
                        }
                    ],
                    yAxis: [
                        {
                            // min: 0,
                            title: {
                                text: null
                            },
                            labels:
                            {
                                enabled: false
                            },
                        },
                        {
                            // min: 0,
                            title: {
                                text: null
                            },
                            labels:
                            {
                                enabled: false
                            },
                        }
                    ],
                    tooltip: {
                        shared: true
                    },
                    series: [
                        {
                            name: 'Đơn hàng',
                            type: 'column',
                            yAxis: 1,
                            data: [],
                            // colorByPoint: true,
                            color: 'rgb(240, 119, 25)'
                        }, 
                        {
                            name: 'Doanh thu',
                            type: 'spline',
                            data: [],
                            tooltip: {
                                // valueSuffix: 'đ'
                            },
                            color: 'rgb(118, 166, 100)',
                        },
                        /* {
                            name: 'Chi phí Quảng cáo',
                            data: [],
                            type: 'spline',
                            color: '#8085e9',
                        },
                        {
                            name: PROFIT_ESTIMATE_NAME,
                            data: [],
                            type: 'spline',
                            color: '#ff0000'
                        },
                        {
                            name: PROFIT_NAME,
                            data: [],
                            type: 'spline',
                            color: '#0014ff',
                            // negativeColor: '#000000',
                        } */
                    ]
                });
                resolve();
            }, 100);
        })
        
    }

    const initReportByCategory = function () {
        if (!document.getElementById('chart-by-category')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartByCategory = Highcharts.chart('chart-by-category', {
                    chart: {
                        plotBackgroundColor: null,
                        plotBorderWidth: null,
                        plotShadow: false,
                        type: 'pie'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    tooltip: {
                        pointFormat: 'Chiếm: <b>{point.percentage:.1f}%</b>'
                    },
                    accessibility: {
                        point: {
                            valueSuffix: '%'
                        }
                    },
                    plotOptions: {
                        pie: {
                            allowPointSelect: true,
                            cursor: 'pointer',
                            dataLabels: {
                                enabled: false,
                                format: '<b>{point.name}</b>',
                                connectorColor: 'silver'
                            },
                            showInLegend: true,
                            innerSize: 65,
                            depth: 40,
                            colors: $scope.colorLists
                        }
                    },
                    series: [
                        {
                            name: 'Danh mục',
                            data: []
                        }
                    ]
                });
                resolve();
            }, 100);
        });
    }

    const initReportBySource = function () {
        if (!document.getElementById('chart-by-source')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartBySource = Highcharts.chart('chart-by-source', {
                    chart: {
                        plotBackgroundColor: null,
                        plotBorderWidth: null,
                        plotShadow: false,
                        type: 'pie'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    tooltip: {
                        pointFormat: 'Chiếm: <b>{point.percentage:.1f}%</b>'
                    },
                    accessibility: {
                        point: {
                            valueSuffix: '%'
                        }
                    },
                    plotOptions: {
                        pie: {
                            allowPointSelect: true,
                            cursor: 'pointer',
                            dataLabels: {
                                enabled: false,
                                format: '<b>{point.name}</b>',
                                connectorColor: 'silver'
                            },
                            showInLegend: true,
                            innerSize: 65,
                            depth: 40,
                            colors: $scope.colorLists
                        }
                    },
                    series: [
                        {
                            name: 'Nguồn',
                            data: []
                        }
                    ]
                });
                resolve();
            }, 100);
        });
    }

    const initReportByProduct = function () {
        if (!document.getElementById('chart-by-product')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartByProduct = Highcharts.chart('chart-by-product', {
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: [],
                        crosshair: true
                    },
                    yAxis: {
                        min: 0,
                        title: {
                            text: null
                        }
                    },
                    tooltip: {
                        headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
                        pointFormat: '<tr><td style="padding:0">{series.name}: </td>' +
                        '<td style="padding:0"><b>{point.y}</b></td></tr>',
                        footerFormat: '</table>',
                        shared: true,
                        useHTML: true
                    },
                    plotOptions: {
                    column: {
                        pointPadding: 0.2,
                        borderWidth: 0
                    }
                    },
                    series: [
                        {
                            showInLegend: false,             
                            name: 'Số lượng',
                            data: [],
                            colorByPoint: true,
                        }, 
                    ]
                });
                resolve();
            }, 100);
        });
    }

    const initReportByCategorySource = function () {
        if (!document.getElementById('chart-by-category-source')) {
            return;
        }
        return new Promise (function (resolve) {
            $timeout(function () {
                $scope.chartByCategorySource = Highcharts.chart('chart-by-category-source', {
                    chart: {
                        type: 'column',
                        zoomType: 'xy'
                    },
                    title: {
                        text: null
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: []
                    },
                    yAxis: [
                        {
                            min: 0,
                            title: {
                                text: null
                            },
                            labels: {
                                enabled: false
                            },
                        },
                        {
                            min: 0,
                            title: {
                                text: null
                            },
                            labels: {
                                enabled: false
                            },
                            opposite: true
                        }
                    ],
                    legend: {
                        center: 'right',
                        enabled: false
                    },
                    tooltip: {
                        formatter: function () {
                            var text = '', currentDate = new Date(this.x);
                            var columnName = (this.series.userOptions.stack == 1) ? 'Danh mục' : 'Nguồn';
                            text = `<b>${$scope.weekDays[currentDate.getDay()]} | ${this.x}</b><br/>`;
                            text += `<br/><b><span style="color: ${this.color}">\u25CF</span> ${columnName}: </b> ${this.series.name}`;
                            text += `<br/><b><span style="color: ${this.color}">\u25CF</span> Số lượng: </b> ${this.y}`;
                            text += `<br/><b><span style="color: ${this.color}">\u25CF</span> Tổng: </b> ${this.point.stackTotal}`;
                            return text;
                        }
                    },
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                        }
                    },
                    colors: ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'].concat($scope.localizationColor),
                    series: []
                });
                resolve();
            }, 100);
        });
    }

    const initOrderByConversionTimeLineChart = function() 
    {
        if (!document.getElementById('chart-order-by-conversion-timeline')) {
            return;
        }
        return new Promise (function (resolve) 
        {
            $timeout(function () {

                $scope.chartOrderConversionTimeline = Highcharts.chart('chart-order-by-conversion-timeline', {
                    title: {
                        text: null
                    },
                    subtitle: {
                        text: 'Amount Average, Order/Cart, Order/View by day'
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: []
                    },
                    yAxis: [
                        {
                            // min: 0,
                            title: {
                                text: null
                            },
                            labels:
                            {
                                enabled: false
                            },
                        },
                        {
                            // min: 0,
                            title: {
                                text: null
                            },
                            labels:
                            {
                                enabled: false
                            },
                        },
                        {
                            // min: 0,
                            title: {
                                text: null
                            },
                            labels:
                            {
                                enabled: false
                            },
                        }
                    ],
                    tooltip: {
                        shared: true
                    },
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                            colors: $scope.colorLists
                        }
                    },
                    colors: ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'].concat($scope.localizationColor),
                    series: [
                        {
                            name: 'Amount Average',
                            yAxis: 0,
                            data: [],
                            type: 'column',
                            color: 'rgb(240, 119, 25)',
                        },
                        {
                            name: 'Order/Cart (%)',
                            type: 'spline',
                            yAxis: 0,
                            data: [],
                            // colorByPoint: true,
                            color: 'rgb(118, 166, 100)'
                        }, 
                        {
                            name: 'Order/View (%)',
                            type: 'spline',
                            yAxis: 2,
                            data: [],
                            tooltip: {
                                // valueSuffix: 'đ'
                            },
                            color: '#8085e9',
                        }

                    ]
                });

                resolve();

            }, 100);
        });
    }

    
    $scope.find = function () 
    {
        updateParams();

        renderOrderLocalizationReport();
        renderReportByCategoryData();
        renderReportBySource();
        renderReportByProduct();
        renderReportByCategorySource();
        renderOrderByConversionChart();
    }
    $scope.changeCurrentLocale = $scope.find;
    
    const renderOrderLocalizationReport = function () 
    {
        const localizationParams = angular.copy($scope.params);
        localizationParams.convert_currency = true;

        $scope.chartByOrder.series[0].setData([]);
        $scope.chartByOrder.series[1].setData([]);
        /* $scope.chartByOrderLocalization.series[0].setData([]);
        $scope.chartByRevenueLocalization.series[0].setData([]); */

        let endPoint = '/dashboard/event/service/order-by-locale';
        if ($scope.currentLocale != 'us') {
            endPoint = '/' + $scope.currentLocale + endPoint;
        }
        
        $http.get(endPoint, { params: localizationParams }).then(function (response) {
            if (response.data.status == "successful" && response.data.data) 
            {
                var xAxis = [],
                sumRevenue = {}, sumCurrentRevenue = {};

                const item = response.data;
                const orders = [], revenues = [], itemXAxis = Object.keys(item.data);
                if (itemXAxis.length > xAxis.length) {
                    xAxis = itemXAxis;
                }

                itemXAxis.forEach(function (day) {
                    orders.push(item.data[day].totalQuantity);

                    if (!sumRevenue[day]) sumRevenue[day] = 0;
                    var revenueValue = (item.data[day]) ? item.data[day].totalAmount : 0;
                    sumRevenue[day] += revenueValue;
                    revenues.push(revenueValue);
                });

                const currentOrders = [], currentRevenues = [];
                xAxis.forEach(function (day) {
                    sumCurrentRevenue[day] = item.data[day].totalAmount;

                    currentOrders.push(item.data[day].totalQuantity);
                    currentRevenues.push(item.data[day].totalAmount);
                });

                $scope.chartByOrder.xAxis[0].setCategories(xAxis); //x
                $scope.chartByOrder.series[0].setData(currentOrders);
                $scope.chartByOrder.series[1].setData(currentRevenues);

                /* $scope.chartByOrderLocalization.series[0].setData(orders);
                $scope.chartByRevenueLocalization.series[0].setData(revenues);

                $scope.chartByOrderLocalization.xAxis[0].setCategories(xAxis); 
                $scope.chartByRevenueLocalization.xAxis[0].setCategories(xAxis); 

                $scope.chartByOrderLocalization.hideLoading();
                $scope.chartByRevenueLocalization.hideLoading(); */
            }
        }).catch(() => {
            toastr.error('Có lỗi xảy ra trong quá trình Lấy báo cáo thị trường ' + $scope.currentLocale);
        });
    }

    const renderReportByCategoryData = function ()
    {
        $scope.chartByCategory.showLoading();

        let endPoint = '/dashboard/event/service/order-by-category';
        if ($scope.currentLocale != 'us') {
            endPoint = '/' + $scope.currentLocale + endPoint;
        }

        $http.get(endPoint, { params: $scope.params }).then(function (response) {
            if (response.data.status == "successful" && response.data.data) {
                const categories = [];
                response.data.data.forEach(function (item) {
                    categories.push({ name: item.name, y: item.quantity });
                });
                $scope.chartByCategory.series[0].setData(categories);
            } else {
                $scope.chartByCategory.series[0].setData([]);
            }
            $scope.chartByCategory.hideLoading();
        }, function (error) {
            toastr.error('Có lỗi xảy ra trong quá trình Lấy báo cáo đơn hàng theo danh mục. Xin vui lòng thử lại.');
        });
    }

    const renderReportBySource = function () 
    {
        $scope.chartBySource.showLoading();

        let endPoint = '/dashboard/event/service/order-by-source';
        if ($scope.currentLocale != 'us') {
            endPoint = '/' + $scope.currentLocale + endPoint;
        }

        $http.get(endPoint, { params: $scope.params }).then(function (response) {
            var sources = [];
            if (response.data.status == "successful" && response.data.data) {
                response.data.data.forEach(function (item) {
                    sources.push({ name: item.source, y: item.quantity });
                });
                $scope.chartBySource.series[0].setData(sources);
            } else {
                $scope.chartBySource.series[0].setData([]);
            }
            $scope.chartBySource.hideLoading();
        }, function (error) {
            toastr.error('Có lỗi xảy ra trong quá trình Lấy báo cáo đơn hàng theo nguồn. Xin vui lòng thử lại.');
        });
    }

    const renderReportByProduct = function()
    {
        $scope.chartByProduct.showLoading();

        let endPoint = '/dashboard/event/service/report-by-product';
        if ($scope.currentLocale != 'us') {
            endPoint = '/' + $scope.currentLocale + endPoint;
        }

        $http.get(endPoint, { params: $scope.params }).then(function (response) {
            if (response.data.status == "successful" && response.data.data) {
                var xAxis = [], products = [];
                response.data.data.forEach(function (item) {
                    xAxis.push(item.name);
                    products.push(item.quantity);
                });
                $scope.chartByProduct.xAxis[0].setCategories(xAxis); //x
                $scope.chartByProduct.series[0].setData(products);
            } else {
                $scope.chartByProduct.xAxis[0].setCategories([]); //x
                $scope.chartByProduct.series[0].setData([]);
            }
            $scope.chartByProduct.hideLoading();
        }, function (error) {
            toastr.error('Có lỗi xảy ra trong quá trình Lấy báo cáo đơn hàng theo sản phẩm. Xin vui lòng thử lại.');
        });
    }

    const renderReportByCategorySource = function() 
    {
        $scope.chartByCategorySource.showLoading();

        let endPoint = '/dashboard/event/service/report-by-category-source';
        if ($scope.currentLocale != 'us') {
            endPoint = '/' + $scope.currentLocale + endPoint;
        }

        $http.get(endPoint, { params: $scope.params }).then(function (response) {
            if (response.data && response.data.status == "successful") {
                var xAxis = Object.keys(response.data.data), categories = {}, sources = {}, index = 0;
                for (var day in response.data.data) {
                    for (var item of response.data.data[day].categories) {
                        item.name = item.name.trim();
                        if (!categories[item.name]) {
                            categories[item.name] = Array.apply(null, Array(xAxis.length)).map(Number.prototype.valueOf, 0);
                        }
                        categories[item.name][index] = item.quantity;
                    }
                    for (var item of response.data.data[day].sources) {
                        item.name = item.name.trim();
                        if (!sources[item.name]) {
                            sources[item.name] = Array.apply(null, Array(xAxis.length)).map(Number.prototype.valueOf, 0);
                        }
                        sources[item.name][index] = item.quantity;
                    }
                    index++;
                }

                while ($scope.chartByCategorySource.series.length > 0) {
                    $scope.chartByCategorySource.series[0].remove(false);
                }
                
                for (var key in categories) {
                    $scope.chartByCategorySource.addSeries({
                        name: key,
                        data: categories[key],
                        stack: 1,
                        yAxis: 0
                    }, false);
                }
                for (var key in sources) {
                    $scope.chartByCategorySource.addSeries({
                        name: key,
                        data: sources[key],
                        stack: 2,
                        yAxis: 1
                    }, false);
                }
                
                $scope.chartByCategorySource.xAxis[0].setCategories(xAxis); //x
                $scope.chartByCategorySource.redraw();
            } else {
                $scope.chartByProduct.xAxis[0].setCategories([]); //x
                $scope.chartByProduct.series[0].setData([]);
            }
            $scope.chartByCategorySource.hideLoading();
        }, function (error) {
            toastr.error('Có lỗi xảy ra trong quá trình Lấy báo cáo đơn hàng theo Category & Source. Xin vui lòng thử lại.');
        });
    }

    const renderOrderByConversionChart = function () 
    {
        if (!document.getElementById('chart-order-by-conversion-timeline')) {
            return;
        }

        $scope.chartOrderConversionTimeline.showLoading();

        var dateFrom = $("#date-from").val();
        var dateTo = $("#date-to").val();

        dateFrom = new Date(dateFrom);
        dateFrom.setHours(0, 0, 0, 0);
        dateTo = new Date(dateTo)
        dateTo.setHours(23, 59, 59, 0);

        $http.get('/dashboard/event/service/get-report-order-by-conversion', { params: $scope.params }).then(function (response) {
            if (response.data.status == "successful") {
                
                $scope.chartOrderConversionTimeline.xAxis[0].setCategories(response.data.xAxis);
                let index = 0;
                let keys = ['amount_avg', 'order_cart', 'order_view']
                for (const keyConversion of keys) {
                    if (Object.hasOwnProperty.call(response.data.group_by_date, keyConversion)) {
                        const payload = response.data.group_by_date[keyConversion];
                        const seriesValues = Object.values(payload);

                        $scope.chartOrderConversionTimeline.series[index++].setData(seriesValues);
                    }
                }

                $scope.chartOrderConversionTimeline.hideLoading();

            }
        });

    }

    const fetchEvents = () => 
    {
        $scope.seasonEvents = [];
        
        let endPoint = '/dashboard/event/service/fetch-events';
        if ($scope.currentLocale != 'us') {
            endPoint = '/' + $scope.currentLocale + endPoint;
        }

        $http.get(endPoint, { params: $scope.params }).then(function (response) {
            $scope.seasonEvents = response.data.data;
        });
    };

    const updateParams = () => 
    {
        var dateFrom = $("#date-from").val();
        var dateTo = $("#date-to").val();

        if (!dateFrom || dateFrom == '') {
            toastr.error('Mời chọn ngày bắt đầu Thống kê.');
            return;
        }
        if (!dateTo || dateTo == '') {
            toastr.error('Mời chọn kết thúc Thống kê.');
            return;
        }

        dateFrom = new Date(dateFrom);
        dateFrom.setHours(0, 0, 0, 0);
        dateTo = new Date(dateTo)
        dateTo.setHours(23, 59, 59, 0);

        if (dateFrom.getTime() >= dateTo.getTime()) {
            toastr.error('Ngày Bắt đầu thống kê phải nhỏ hơn ngày Kết thúc.');
            return;
        }

        $scope.params = {
            dateFrom: dateFrom.getTime() / 1000,
            dateTo: dateTo.getTime() / 1000,
            locale: $scope.currentLocale,
            ignore_localization: 1
        };

        if ($scope.currentEvent) {
            $scope.params.event_id = $scope.currentEvent;
        }

        // fetchEvents();
    }

    $scope.init = function () 
    {
        $timeout(function () {

            $("#date-from").datepicker({
                dateFormat: "yy-mm-dd",
            }).datepicker("setDate", "-1w");

            $("#date-to").datepicker({
                dateFormat: "yy-mm-dd",
            }).datepicker("setDate", "+0");

            fetchEvents();
            updateParams();

            // main order report
            Promise.all([
                /* initOrderLocalizationChart([{
                    name: 'Số đơn hàng',
                    data: [],
                    stack: 1,
                    type: 'column'
                }]),
                initReportRevenueLocalization([{
                    name: 'Doanh thu',
                    data: [],
                    stack: 1,
                    type: 'column'
                }]), */
                initReportByDay()
            ]).then(function () {
                renderOrderLocalizationReport();
            });

            // order by category report
            initReportByCategory().then(() => renderReportByCategoryData());
            initReportBySource().then(() => renderReportBySource());
            initReportByProduct().then(() => renderReportByProduct());
            initReportByCategorySource().then(() => renderReportByCategorySource());
            initOrderByConversionTimeLineChart().then(() => renderOrderByConversionChart())
        });

    }

    $scope.init();
});
